/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.portlet.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionFileException;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.web.internal.portlet.action.DeployWorkflowDefinitionMVCActionCommand;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet", "mvc.command.name=revertWorkflowDefinition"}, service={MVCActionCommand.class})
public class RevertWorkflowDefinitionMVCActionCommand
extends DeployWorkflowDefinitionMVCActionCommand {
    @Override
    public boolean processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        try {
            this.doProcessAction(actionRequest, actionResponse);
            this.addSuccessMessage(actionRequest, actionResponse);
            return SessionErrors.isEmpty((PortletRequest)actionRequest);
        }
        catch (WorkflowException we) {
            this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)we)).getClass(), (Object)((Object)we));
            actionResponse.setRenderParameter("mvcPath", "/definition/edit_workflow_definition.jsp");
            return false;
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    @Override
    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String previousName = ParamUtil.getString((PortletRequest)actionRequest, (String)"previousName");
        int previousVersion = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"previousVersion");
        WorkflowDefinition previousWorkflowDefinition = WorkflowDefinitionManagerUtil.getWorkflowDefinition((long)themeDisplay.getCompanyId(), (String)previousName, (int)previousVersion);
        actionRequest.setAttribute("WORKFLOW_DEFINITION_MODIFIED_DATE", (Object)previousWorkflowDefinition.getModifiedDate());
        String content = GetterUtil.get((String)previousWorkflowDefinition.getContent(), (String)"");
        WorkflowDefinition workflowDefinition = null;
        if (previousWorkflowDefinition.isActive()) {
            this.validateWorkflowDefinition(actionRequest, content.getBytes("UTF-8"), themeDisplay.getLocale(), previousWorkflowDefinition.getModifiedDate());
            workflowDefinition = this.workflowDefinitionManager.deployWorkflowDefinition(themeDisplay.getCompanyId(), themeDisplay.getUserId(), previousWorkflowDefinition.getTitle(), previousName, content.getBytes());
        } else {
            workflowDefinition = this.workflowDefinitionManager.saveWorkflowDefinition(themeDisplay.getCompanyId(), themeDisplay.getUserId(), previousWorkflowDefinition.getTitle(), previousName, content.getBytes());
        }
        this.setRedirectAttribute(actionRequest, workflowDefinition);
        this.sendRedirect(actionRequest, actionResponse);
    }

    @Override
    protected String getSuccessMessage(ActionRequest actionRequest) {
        ResourceBundle resourceBundle = this.getResourceBundle(actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Locale locale = themeDisplay.getLocale();
        DateFormat dateFormat = this._getDateFormat(locale);
        Date workflowDefinitionModifiedDate = GetterUtil.getDate((Object)actionRequest.getAttribute("WORKFLOW_DEFINITION_MODIFIED_DATE"), (DateFormat)dateFormat);
        return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"restored-to-revision-from-x", (Object)dateFormat.format(workflowDefinitionModifiedDate));
    }

    protected void validateWorkflowDefinition(ActionRequest actionRequest, byte[] bytes, Locale locale, Date previousDateModification) throws WorkflowDefinitionFileException {
        try {
            this.workflowDefinitionManager.validateWorkflowDefinition(bytes);
        }
        catch (WorkflowException we) {
            DateFormat dateFormat = this._getDateFormat(locale);
            String message = LanguageUtil.format((ResourceBundle)this.getResourceBundle(actionRequest), (String)"the-version-from-x-is-not-valid-for-publication", (Object)dateFormat.format(previousDateModification));
            throw new WorkflowDefinitionFileException(message, (Throwable)we);
        }
    }

    private DateFormat _getDateFormat(Locale locale) {
        if (DateUtil.isFormatAmPm((Locale)locale)) {
            return DateFormatFactoryUtil.getSimpleDateFormat((String)"MMM d, yyyy, hh:mm a", (Locale)locale);
        }
        return DateFormatFactoryUtil.getSimpleDateFormat((String)"MMM d, yyyy, HH:mm", (Locale)locale);
    }
}

