/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.portlet.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionFileException;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionTitleException;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.web.internal.portlet.action.BaseWorkflowDefinitionMVCActionCommand;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet", "mvc.command.name=deployWorkflowDefinition"}, service={MVCActionCommand.class})
public class DeployWorkflowDefinitionMVCActionCommand
extends BaseWorkflowDefinitionMVCActionCommand {
    @Reference(target="(proxy.bean=false)")
    protected WorkflowDefinitionManager unproxiedWorkflowDefinitionManager;
    private static final Log _log = LogFactoryUtil.getLog(DeployWorkflowDefinitionMVCActionCommand.class);

    @Override
    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        String title = (String)titleMap.get(LocaleUtil.getDefault());
        if (titleMap.isEmpty() || Validator.isNull((String)title)) {
            throw new WorkflowDefinitionTitleException();
        }
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        if (Validator.isNull((String)content)) {
            throw new WorkflowDefinitionFileException("please-enter-a-valid-definition-before-publishing");
        }
        this.validateWorkflowDefinition(actionRequest, content.getBytes());
        WorkflowDefinition latestWorkflowDefinition = this.getLatestWorkflowDefinition(themeDisplay.getCompanyId(), name);
        if (latestWorkflowDefinition == null || !latestWorkflowDefinition.isActive()) {
            actionRequest.setAttribute("WORKFLOW_PUBLISH_DEFINITION_ACTION", (Object)Boolean.TRUE);
        }
        WorkflowDefinition workflowDefinition = this.unproxiedWorkflowDefinitionManager.deployWorkflowDefinition(themeDisplay.getCompanyId(), themeDisplay.getUserId(), this.getTitle(actionRequest, titleMap), name, content.getBytes());
        this.setRedirectAttribute(actionRequest, workflowDefinition);
        this.sendRedirect(actionRequest, actionResponse);
    }

    protected WorkflowDefinition getLatestWorkflowDefinition(long companyId, String name) {
        try {
            return this.unproxiedWorkflowDefinitionManager.getLatestWorkflowDefinition(companyId, name);
        }
        catch (WorkflowException we) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)we, (Throwable)we);
            }
            return null;
        }
    }

    @Override
    protected String getSuccessMessage(ActionRequest actionRequest) {
        ResourceBundle resourceBundle = this.getResourceBundle(actionRequest);
        boolean definitionPublishing = GetterUtil.getBoolean((Object)actionRequest.getAttribute("WORKFLOW_PUBLISH_DEFINITION_ACTION"));
        if (definitionPublishing) {
            return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"workflow-published-successfully");
        }
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"workflow-updated-successfully");
    }

    protected void setRedirectAttribute(ActionRequest actionRequest, WorkflowDefinition workflowDefinition) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)themeDisplay.getPpid(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/definition/edit_workflow_definition.jsp");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("name", workflowDefinition.getName(), false);
        portletURL.setParameter("version", String.valueOf(workflowDefinition.getVersion()), false);
        portletURL.setWindowState(actionRequest.getWindowState());
        actionRequest.setAttribute("REDIRECT", (Object)portletURL.toString());
    }

    protected void validateWorkflowDefinition(ActionRequest actionRequest, byte[] bytes) throws WorkflowDefinitionFileException {
        try {
            this.unproxiedWorkflowDefinitionManager.validateWorkflowDefinition(bytes);
        }
        catch (WorkflowException we) {
            String message = LanguageUtil.get((ResourceBundle)this.getResourceBundle(actionRequest), (String)"please-enter-a-valid-definition-before-publishing");
            throw new WorkflowDefinitionFileException(message, (Throwable)we);
        }
    }
}

