/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import java.io.Serializable;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet", "javax.portlet.name=com_liferay_portal_workflow_web_internal_portlet_ControlPanelWorkflowInstancePortlet", "javax.portlet.name=com_liferay_portal_workflow_web_internal_portlet_SiteAdministrationWorkflowPortlet", "javax.portlet.name=com_liferay_portal_workflow_web_internal_portlet_UserWorkflowPortlet", "mvc.command.name=deleteWorkflowInstance"}, service={MVCActionCommand.class})
public class DeleteWorkflowInstanceMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private Portal _portal;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    protected void deleteWorkflowInstance(Map<String, Serializable> workflowContext) throws PortalException {
        long companyId = GetterUtil.getLong((Object)workflowContext.get("companyId"));
        long groupId = GetterUtil.getLong((Object)workflowContext.get("groupId"));
        String className = GetterUtil.getString((Object)workflowContext.get("entryClassName"));
        long classPK = GetterUtil.getLong((Object)workflowContext.get("entryClassPK"));
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(companyId, groupId, className, classPK);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            WorkflowInstance workflowInstance = this.getWorkflowInstance(actionRequest);
            Map workflowContext = workflowInstance.getWorkflowContext();
            this.validateUser(workflowContext);
            this.updateEntryStatus(workflowContext);
            this.deleteWorkflowInstance(workflowContext);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException || e instanceof WorkflowException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                PortletSession portletSession = actionRequest.getPortletSession();
                PortletContext portletContext = portletSession.getPortletContext();
                PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/error.jsp");
                portletRequestDispatcher.include((PortletRequest)actionRequest, (PortletResponse)actionResponse);
            }
            throw e;
        }
    }

    protected WorkflowInstance getWorkflowInstance(ActionRequest actionRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long workflowInstanceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"workflowInstanceId");
        return WorkflowInstanceManagerUtil.getWorkflowInstance((long)themeDisplay.getCompanyId(), (long)workflowInstanceId);
    }

    protected void updateEntryStatus(Map<String, Serializable> workflowContext) throws PortalException {
        String className = GetterUtil.getString((Object)workflowContext.get("entryClassName"));
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)className);
        workflowHandler.updateStatus(2, workflowContext);
    }

    protected void validateUser(Map<String, Serializable> workflowContext) throws PortalException {
        long companyId = GetterUtil.getLong((Object)workflowContext.get("companyId"));
        long userId = GetterUtil.getLong((Object)workflowContext.get("userId"));
        long validUserId = this._portal.getValidUserId(companyId, userId);
        workflowContext.put("userId", (Serializable)((Object)String.valueOf(validUserId)));
    }
}

