/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.portlet.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.kernel.workflow.WorkflowException;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseWorkflowDefinitionMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    protected WorkflowDefinitionManager workflowDefinitionManager;

    public boolean processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        try {
            this.doProcessAction(actionRequest, actionResponse);
            this.addSuccessMessage(actionRequest, actionResponse);
            return SessionErrors.isEmpty((PortletRequest)actionRequest);
        }
        catch (WorkflowException we) {
            this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)we)).getClass(), (Object)((Object)we));
            return false;
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected void addDefaultTitle(ActionRequest actionRequest, Map<Locale, String> titleMap) {
        Locale defaultLocale = LocaleUtil.getDefault();
        if (Validator.isNull((String)titleMap.get(defaultLocale))) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)defaultLocale, BaseWorkflowDefinitionMVCActionCommand.class);
            String defaultTitle = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"untitled-workflow");
            titleMap.put(defaultLocale, defaultTitle);
        }
    }

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        String successMessage = this.getSuccessMessage(actionRequest);
        SessionMessages.add((PortletRequest)actionRequest, (String)"requestProcessed", (Object)successMessage);
    }

    protected abstract void doProcessAction(ActionRequest var1, ActionResponse var2) throws Exception;

    protected ResourceBundle getResourceBundle(ActionRequest actionRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return ResourceBundleUtil.getBundle((Locale)themeDisplay.getLocale(), BaseWorkflowDefinitionMVCActionCommand.class);
    }

    protected String getSuccessMessage(ActionRequest actionRequest) {
        ResourceBundle resourceBundle = this.getResourceBundle(actionRequest);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"workflow-updated-successfully");
    }

    protected String getTitle(ActionRequest actionRequest, Map<Locale, String> titleMap) {
        if (titleMap == null) {
            return null;
        }
        this.addDefaultTitle(actionRequest, titleMap);
        String value = "";
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String title = titleMap.get(locale);
            if (Validator.isNotNull((String)title)) {
                value = LocalizationUtil.updateLocalization((String)value, (String)"Title", (String)title, (String)languageId);
                continue;
            }
            value = LocalizationUtil.removeLocalization((String)value, (String)"Title", (String)languageId);
        }
        return value;
    }
}

