/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowLog;
import com.liferay.portal.kernel.workflow.WorkflowLogManagerUtil;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactoryUtil;
import com.liferay.portal.workflow.web.internal.display.context.BaseWorkflowInstanceDisplayContext;
import com.liferay.portal.workflow.web.internal.search.WorkflowInstanceSearch;
import com.liferay.portal.workflow.web.internal.util.WorkflowInstancePortletUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class WorkflowInstanceViewDisplayContext
extends BaseWorkflowInstanceDisplayContext {
    private static final String[] _DISPLAY_VIEWS = new String[]{"descriptive", "list"};
    private String _displayStyle;
    private String _keywords;
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private WorkflowInstanceSearch _searchContainer;

    public WorkflowInstanceViewDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException {
        super(liferayPortletRequest, liferayPortletResponse);
    }

    public String getAssetIconCssClass(WorkflowInstance workflowInstance) {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowInstance);
        return workflowHandler.getIconCssClass();
    }

    public String getAssetTitle(WorkflowInstance workflowInstance) {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowInstance);
        long classPK = this.getWorkflowContextEntryClassPK(workflowInstance.getWorkflowContext());
        return HtmlUtil.escape((String)workflowHandler.getTitle(classPK, this.workflowInstanceRequestHelper.getLocale()));
    }

    public String getAssetType(WorkflowInstance workflowInstance) {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowInstance);
        return workflowHandler.getType(this.workflowInstanceRequestHelper.getLocale());
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getViewPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getDefinition(WorkflowInstance workflowInstance) throws PortalException {
        WorkflowDefinition workflowDefinition = WorkflowDefinitionManagerUtil.getWorkflowDefinition((long)this.workflowInstanceRequestHelper.getCompanyId(), (String)workflowInstance.getWorkflowDefinitionName(), (int)workflowInstance.getWorkflowDefinitionVersion());
        return HtmlUtil.escape((String)workflowDefinition.getTitle(LanguageUtil.getLanguageId((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest())));
    }

    public String getDisplayStyle() {
        if (this._displayStyle == null) {
            this._displayStyle = WorkflowInstancePortletUtil.getDisplayStyle((PortletRequest)this.liferayPortletRequest, this.getDisplayViews());
        }
        return this._displayStyle;
    }

    public String[] getDisplayViews() {
        return _DISPLAY_VIEWS;
    }

    public Date getEndDate(WorkflowInstance workflowInstance) {
        return workflowInstance.getEndDate();
    }

    public DropdownItemList getFilterOptions(final HttpServletRequest httpServletRequest) {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems((List)new DropdownItemList(){
                        {
                            this.add(WorkflowInstanceViewDisplayContext.this._getFilterNavigationDropdownItem("all"));
                            this.add(WorkflowInstanceViewDisplayContext.this._getFilterNavigationDropdownItem("pending"));
                            this.add(WorkflowInstanceViewDisplayContext.this._getFilterNavigationDropdownItem("completed"));
                        }
                    });
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"filter"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems((List)new DropdownItemList(){
                        {
                            this.add(WorkflowInstanceViewDisplayContext.this._getOrderByDropdownItem("last-activity-date"));
                            this.add(WorkflowInstanceViewDisplayContext.this._getOrderByDropdownItem("end-date"));
                        }
                    });
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public String getHeaderTitle() {
        return "workflow-submissions";
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((PortletRequest)this.liferayPortletRequest, (String)"keywords");
        return this._keywords;
    }

    public Date getLastActivityDate(WorkflowInstance workflowInstance) throws PortalException {
        WorkflowLog workflowLog = this.getLatestWorkflowLog(workflowInstance);
        if (workflowLog == null) {
            return null;
        }
        return workflowLog.getCreateDate();
    }

    public String getNavigation() {
        if (this._navigation != null) {
            return this._navigation;
        }
        this._navigation = ParamUtil.getString((HttpServletRequest)this.request, (String)"navigation", (String)"all");
        return this._navigation;
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this.request, (String)"orderByCol");
        if (Validator.isNull((String)this._orderByCol)) {
            this._orderByCol = this.portalPreferences.getValue("com_liferay_portal_workflow_web_internal_portlet_UserWorkflowPortlet", "instance-order-by-col", "last-activity-date");
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this.request, (String)"saveOrderBy");
            if (saveOrderBy) {
                this.portalPreferences.setValue("com_liferay_portal_workflow_web_internal_portlet_UserWorkflowPortlet", "instance-order-by-col", this._orderByCol);
            }
        }
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this.request, (String)"orderByType");
        if (Validator.isNull((String)this._orderByType)) {
            this._orderByType = this.portalPreferences.getValue("com_liferay_portal_workflow_web_internal_portlet_UserWorkflowPortlet", "instance-order-by-type", "asc");
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this.request, (String)"saveOrderBy");
            if (saveOrderBy) {
                this.portalPreferences.setValue("com_liferay_portal_workflow_web_internal_portlet_UserWorkflowPortlet", "instance-order-by-type", this._orderByType);
            }
        }
        return this._orderByType;
    }

    public List<WorkflowHandler<?>> getSearchableAssetsWorkflowHandlers() {
        ArrayList searchableAssetsWorkflowHandlers = new ArrayList();
        List workflowHandlers = WorkflowHandlerRegistryUtil.getWorkflowHandlers();
        for (WorkflowHandler workflowHandler : workflowHandlers) {
            if (!workflowHandler.isAssetTypeSearchable()) continue;
            searchableAssetsWorkflowHandlers.add(workflowHandler);
        }
        return searchableAssetsWorkflowHandlers;
    }

    public WorkflowInstanceSearch getSearchContainer() throws PortalException {
        PortletURL portletURL = PortletURLUtil.getCurrent((LiferayPortletRequest)this.liferayPortletRequest, (LiferayPortletResponse)this.liferayPortletResponse);
        this._searchContainer = new WorkflowInstanceSearch((PortletRequest)this.liferayPortletRequest, portletURL);
        this._searchContainer.setResults(this.getSearchContainerResults(this._searchContainer.getStart(), this._searchContainer.getEnd(), (OrderByComparator<WorkflowInstance>)this._searchContainer.getOrderByComparator()));
        this._searchContainer.setTotal(this.getSearchContainerTotal());
        this.setSearchContainerEmptyResultsMessage(this._searchContainer);
        return this._searchContainer;
    }

    public String getSearchURL() {
        PortletURL portletURL = this.getViewPortletURL();
        ThemeDisplay themeDisplay = this.workflowInstanceRequestHelper.getThemeDisplay();
        portletURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
        return portletURL.toString();
    }

    public String getSortingURL(HttpServletRequest httpServletRequest) throws PortletException {
        String orderByCol;
        String orderByType = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"orderByType", (String)"asc");
        LiferayPortletResponse response = this.workflowInstanceRequestHelper.getLiferayPortletResponse();
        PortletURL portletURL = response.createRenderURL();
        portletURL.setParameter("orderByType", Objects.equals(orderByType, "asc") ? "desc" : "asc");
        String instanceNavigation = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"navigation");
        if (Validator.isNotNull((String)instanceNavigation)) {
            portletURL.setParameter("navigation", instanceNavigation);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        portletURL.setParameter("tab", "submissions");
        return portletURL.toString();
    }

    public String getStatus(WorkflowInstance workflowInstance) {
        return LanguageUtil.get((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest(), (String)HtmlUtil.escape((String)workflowInstance.getState()));
    }

    public int getTotalItems() throws PortalException {
        WorkflowInstanceSearch searchContainer = this.getSearchContainer();
        return searchContainer.getTotal();
    }

    public PortletURL getViewPortletURL() {
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        portletURL.setParameter("tab", "submissions");
        portletURL.setParameter("orderByType", this.getOrderByType());
        return portletURL;
    }

    public ViewTypeItemList getViewTypes() {
        return new ViewTypeItemList(this.getViewPortletURL(), this.getDisplayStyle()){
            {
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean isDisabledManagementBar() throws PortalException {
        WorkflowInstanceSearch searchContainer = this.getSearchContainer();
        return !searchContainer.hasResults();
    }

    public boolean isNavigationAll() {
        return Objects.equals(this.getNavigation(), "all");
    }

    public boolean isNavigationCompleted() {
        return Objects.equals(this.getNavigation(), "completed");
    }

    public boolean isNavigationPending() {
        return Objects.equals(this.getNavigation(), "pending");
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    protected String getAssetType(String keywords) {
        for (WorkflowHandler<?> workflowHandler : this.getSearchableAssetsWorkflowHandlers()) {
            String assetType = workflowHandler.getType(this.workflowInstanceRequestHelper.getLocale());
            if (!StringUtil.equalsIgnoreCase((String)keywords, (String)assetType)) continue;
            return workflowHandler.getClassName();
        }
        return "";
    }

    protected Boolean getCompleted() {
        if (this.isNavigationAll()) {
            return null;
        }
        if (this.isNavigationCompleted()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected WorkflowLog getLatestWorkflowLog(WorkflowInstance workflowInstance) throws PortalException {
        List workflowLogs = WorkflowLogManagerUtil.getWorkflowLogsByWorkflowInstance((long)this.workflowInstanceRequestHelper.getCompanyId(), (long)workflowInstance.getWorkflowInstanceId(), null, (int)0, (int)1, (OrderByComparator)WorkflowComparatorFactoryUtil.getLogCreateDateComparator());
        if (workflowLogs.isEmpty()) {
            return null;
        }
        return (WorkflowLog)workflowLogs.get(0);
    }

    protected List<WorkflowInstance> getSearchContainerResults(int start, int end, OrderByComparator<WorkflowInstance> comparator) throws PortalException {
        return WorkflowInstanceManagerUtil.search((long)this.workflowInstanceRequestHelper.getCompanyId(), null, (String)this.getKeywords(), (String)this.getKeywords(), (String)this.getAssetType(this.getKeywords()), (String)this.getKeywords(), (String)this.getKeywords(), (Boolean)this.getCompleted(), (int)start, (int)end, comparator);
    }

    protected int getSearchContainerTotal() throws PortalException {
        return WorkflowInstanceManagerUtil.searchCount((long)this.workflowInstanceRequestHelper.getCompanyId(), null, (String)this.getKeywords(), (String)this.getKeywords(), (String)this.getAssetType(this.getKeywords()), (String)this.getKeywords(), (String)this.getKeywords(), (Boolean)this.getCompleted());
    }

    protected String getWorkflowContextEntryClassName(Map<String, Serializable> workflowContext) {
        return (String)((Object)workflowContext.get("entryClassName"));
    }

    protected long getWorkflowContextEntryClassPK(Map<String, Serializable> workflowContext) {
        return GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
    }

    protected WorkflowHandler<?> getWorkflowHandler(WorkflowInstance workflowInstance) {
        String className = this.getWorkflowContextEntryClassName(workflowInstance.getWorkflowContext());
        return WorkflowHandlerRegistryUtil.getWorkflowHandler((String)className);
    }

    protected void setSearchContainerEmptyResultsMessage(WorkflowInstanceSearch searchContainer) {
        DisplayTerms searchTerms = searchContainer.getDisplayTerms();
        if (this.isNavigationAll()) {
            searchContainer.setEmptyResultsMessage("there-are-no-instances");
        } else if (this.isNavigationPending()) {
            searchContainer.setEmptyResultsMessage("there-are-no-pending-instances");
        } else {
            searchContainer.setEmptyResultsMessage("there-are-no-completed-instances");
        }
        if (Validator.isNotNull((String)searchTerms.getKeywords())) {
            searchContainer.setEmptyResultsMessage(searchContainer.getEmptyResultsMessage() + "-with-the-specified-search-criteria");
        }
    }

    private UnsafeConsumer<DropdownItem, Exception> _getFilterNavigationDropdownItem(String navigation) {
        return dropdownItem -> {
            dropdownItem.setActive(Objects.equals(this.getNavigation(), navigation));
            dropdownItem.setHref(this.getViewPortletURL(), new Object[]{"navigation", navigation, "mvcPath", "/view.jsp"});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this.request, (String)navigation));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getOrderByDropdownItem(String orderByCol) {
        return dropdownItem -> {
            dropdownItem.setActive(Objects.equals(this.getOrderByCol(), orderByCol));
            dropdownItem.setHref(this.getViewPortletURL(), new Object[]{"orderByCol", orderByCol});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this.request, (String)orderByCol));
        };
    }
}

