/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.display.context;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowLog;
import com.liferay.portal.kernel.workflow.WorkflowLogManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactoryUtil;
import com.liferay.portal.workflow.web.internal.display.context.BaseWorkflowInstanceDisplayContext;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class WorkflowInstanceEditDisplayContext
extends BaseWorkflowInstanceDisplayContext {
    protected List<WorkflowTask> workflowTasks;
    private static final List<Integer> _logTypes = Arrays.asList(1, 3, 2, 0);
    private final Map<Long, Role> _roles = new HashMap<Long, Role>();
    private final Map<Long, User> _users = new HashMap<Long, User>();
    private List<WorkflowLog> _workflowLogs;

    public WorkflowInstanceEditDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        super(liferayPortletRequest, liferayPortletResponse);
    }

    public AssetEntry getAssetEntry() throws PortalException {
        AssetRenderer<?> assetRenderer = this.getAssetRenderer();
        if (assetRenderer == null) {
            return null;
        }
        AssetRendererFactory<?> assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getAssetEntry(assetRendererFactory.getClassName(), assetRenderer.getClassPK());
    }

    public String getAssetEntryVersionId() {
        long classPK = this.getWorkflowContextEntryClassPK();
        return String.valueOf(classPK);
    }

    public String getAssetName() throws PortalException {
        return this.getWorkflowDefinitionName();
    }

    public AssetRenderer<?> getAssetRenderer() throws PortalException {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler();
        return workflowHandler.getAssetRenderer(this.getWorkflowContextEntryClassPK());
    }

    public AssetRendererFactory<?> getAssetRendererFactory() {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler();
        return workflowHandler.getAssetRendererFactory();
    }

    public String getAssignedTheTaskMessageKey(WorkflowLog workflowLog) throws PortalException {
        User user = this.getUser(workflowLog.getUserId());
        if (user.isMale()) {
            return "x-assigned-the-task-to-himself";
        }
        return "x-assigned-the-task-to-herself";
    }

    public Object getAssignedTheTaskToMessageArguments(WorkflowLog workflowLog) throws PortalException {
        String userName = PortalUtil.getUserName((long)workflowLog.getAuditUserId(), (String)"");
        String actorName = this.getActorName(workflowLog);
        return new Object[]{HtmlUtil.escape((String)userName), HtmlUtil.escape((String)actorName)};
    }

    public String getHeaderTitle() throws PortalException {
        return LanguageUtil.get((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest(), (String)this.getWorkflowDefinitionName());
    }

    public String getIconCssClass() {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler();
        return workflowHandler.getIconCssClass();
    }

    public String getPanelTitle() {
        String modelResource = ResourceActionsUtil.getModelResource((Locale)this.workflowInstanceRequestHelper.getLocale(), (String)this.getWorkflowContextEntryClassName());
        return LanguageUtil.format((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest(), (String)"preview-of-x", (Object)modelResource, (boolean)false);
    }

    public Object getPreviousAssigneeMessageArguments(WorkflowLog workflowLog) {
        return HtmlUtil.escape((String)PortalUtil.getUserName((long)workflowLog.getPreviousUserId(), (String)""));
    }

    public String getTaskCompleted(WorkflowTask workflowTask) {
        if (workflowTask.isCompleted()) {
            return LanguageUtil.get((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest(), (String)"yes");
        }
        return LanguageUtil.get((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest(), (String)"no");
    }

    public Object getTaskCompletionMessageArguments(WorkflowLog workflowLog) throws PortalException {
        String actorName = this.getActorName(workflowLog);
        return new Object[]{HtmlUtil.escape((String)actorName), HtmlUtil.escape((String)workflowLog.getState())};
    }

    public String getTaskContentTitleMessage() {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler();
        long classPK = this.getWorkflowContextEntryClassPK();
        return HtmlUtil.escape((String)workflowHandler.getTitle(classPK, this.workflowInstanceRequestHelper.getLocale()));
    }

    public String getTaskDueDate(WorkflowTask workflowTask) {
        if (workflowTask.getDueDate() == null) {
            return LanguageUtil.get((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest(), (String)"never");
        }
        return this.dateFormatDateTime.format(workflowTask.getDueDate());
    }

    public Object getTaskInitiallyAssignedMessageArguments(WorkflowLog workflowLog) throws PortalException {
        return HtmlUtil.escape((String)this.getActorName(workflowLog));
    }

    public String getTaskName(WorkflowTask workflowTask) {
        return HtmlUtil.escape((String)workflowTask.getName());
    }

    public Object getTaskUpdateMessageArguments(WorkflowLog workflowLog) throws PortalException {
        return HtmlUtil.escape((String)this.getActorName(workflowLog));
    }

    public Object getTransitionMessageArguments(WorkflowLog workflowLog) throws PortalException {
        String actorName = this.getActorName(workflowLog);
        return new Object[]{HtmlUtil.escape((String)actorName), HtmlUtil.escape((String)workflowLog.getPreviousState()), HtmlUtil.escape((String)workflowLog.getState())};
    }

    public String getUserFullName(WorkflowLog workflowLog) throws PortalException {
        User user = this.getUser(workflowLog.getUserId());
        return HtmlUtil.escape((String)user.getFullName());
    }

    public String getWorkflowInstanceEndDate() {
        WorkflowInstance workflowInstance = this.getWorkflowInstance();
        if (workflowInstance.getEndDate() == null) {
            return LanguageUtil.get((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest(), (String)"never");
        }
        return this.dateFormatDateTime.format(workflowInstance.getEndDate());
    }

    public String getWorkflowInstanceState() {
        WorkflowInstance workflowInstance = this.getWorkflowInstance();
        return LanguageUtil.get((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest(), (String)workflowInstance.getState());
    }

    public String getWorkflowLogComment(WorkflowLog workflowLog) {
        return HtmlUtil.escape((String)LanguageUtil.get((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest(), (String)workflowLog.getComment()));
    }

    public String getWorkflowLogCreateDate(WorkflowLog workflowLog) {
        return this.dateFormatDateTime.format(workflowLog.getCreateDate());
    }

    public List<WorkflowLog> getWorkflowLogs() throws WorkflowException {
        if (this._workflowLogs == null) {
            OrderByComparator orderByComparator = WorkflowComparatorFactoryUtil.getLogCreateDateComparator((boolean)false);
            this._workflowLogs = WorkflowLogManagerUtil.getWorkflowLogsByWorkflowInstance((long)this.workflowInstanceRequestHelper.getCompanyId(), (long)this.getWorkflowInstanceId(), _logTypes, (int)-1, (int)-1, (OrderByComparator)orderByComparator);
        }
        return this._workflowLogs;
    }

    public List<WorkflowTask> getWorkflowTasks() throws PortalException {
        if (this.workflowTasks == null) {
            this.workflowTasks = WorkflowTaskManagerUtil.getWorkflowTasksByWorkflowInstance((long)this.workflowInstanceRequestHelper.getCompanyId(), null, (long)this.getWorkflowInstanceId(), null, (int)-1, (int)-1, null);
        }
        return this.workflowTasks;
    }

    public boolean isAuditUser(WorkflowLog workflowLog) {
        if (workflowLog.getUserId() == 0L) {
            return false;
        }
        return workflowLog.getAuditUserId() == workflowLog.getUserId();
    }

    public boolean isWorkflowTasksEmpty() throws PortalException {
        return this.getWorkflowTasks().isEmpty();
    }

    protected String getActorName(WorkflowLog workflowLog) throws PortalException {
        if (workflowLog.getRoleId() != 0L) {
            Role role = this.getRole(workflowLog.getRoleId());
            return role.getDescriptiveName();
        }
        if (workflowLog.getUserId() != 0L) {
            User user = this.getUser(workflowLog.getUserId());
            return user.getFullName();
        }
        return "";
    }

    protected Role getRole(long roleId) throws PortalException {
        Role role = this._roles.get(roleId);
        if (role == null) {
            role = RoleLocalServiceUtil.getRole((long)roleId);
            this._roles.put(roleId, role);
        }
        return role;
    }

    protected User getUser(long userId) throws PortalException {
        User user = this._users.get(userId);
        if (user == null) {
            user = UserLocalServiceUtil.getUser((long)userId);
            this._users.put(userId, user);
        }
        return user;
    }

    protected Map<String, Serializable> getWorkflowContext() {
        WorkflowInstance workflowInstance = this.getWorkflowInstance();
        return workflowInstance.getWorkflowContext();
    }

    protected String getWorkflowContextEntryClassName() {
        Map<String, Serializable> workflowContext = this.getWorkflowContext();
        return (String)((Object)workflowContext.get("entryClassName"));
    }

    protected long getWorkflowContextEntryClassPK() {
        Map<String, Serializable> workflowContext = this.getWorkflowContext();
        return GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
    }

    protected String getWorkflowDefinitionName() throws PortalException {
        WorkflowInstance workflowInstance = this.getWorkflowInstance();
        WorkflowDefinition workflowDefinition = WorkflowDefinitionManagerUtil.getWorkflowDefinition((long)this.workflowInstanceRequestHelper.getCompanyId(), (String)workflowInstance.getWorkflowDefinitionName(), (int)workflowInstance.getWorkflowDefinitionVersion());
        return HtmlUtil.escape((String)workflowDefinition.getTitle(LanguageUtil.getLanguageId((HttpServletRequest)this.workflowInstanceRequestHelper.getRequest())));
    }

    protected WorkflowHandler<?> getWorkflowHandler() {
        String className = this.getWorkflowContextEntryClassName();
        return WorkflowHandlerRegistryUtil.getWorkflowHandler((String)className);
    }

    protected WorkflowInstance getWorkflowInstance() {
        return (WorkflowInstance)this.liferayPortletRequest.getAttribute("WORKFLOW_INSTANCE");
    }

    protected long getWorkflowInstanceId() {
        WorkflowInstance workflowInstance = this.getWorkflowInstance();
        return workflowInstance.getWorkflowInstanceId();
    }
}

