/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.portlet;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.workflow.portlet.tab.WorkflowPortletTab;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;

public abstract class BaseWorkflowPortlet
extends MVCPortlet {
    private ServiceTrackerMap<String, WorkflowPortletTab> _workflowPortletTabServiceTrackerMap;

    public String getDefaultWorkflowPortletTabName() {
        List<String> workflowPortletTabNames = this.getWorkflowPortletTabNames();
        return workflowPortletTabNames.get(0);
    }

    public abstract List<String> getWorkflowPortletTabNames();

    public List<WorkflowPortletTab> getWorkflowPortletTabs() {
        List<String> workflowPortletTabNames = this.getWorkflowPortletTabNames();
        Stream stream = workflowPortletTabNames.stream();
        return stream.map(name -> (WorkflowPortletTab)this._workflowPortletTabServiceTrackerMap.getService(name)).collect(Collectors.toList());
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        for (WorkflowPortletTab workflowPortletTab : this.getWorkflowPortletTabs()) {
            workflowPortletTab.prepareProcessAction(actionRequest, actionResponse);
        }
        super.processAction(actionRequest, actionResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.addRenderRequestAttributes(renderRequest);
        for (WorkflowPortletTab workflowPortletTab : this.getWorkflowPortletTabs()) {
            workflowPortletTab.prepareRender(renderRequest, renderResponse);
        }
        super.render(renderRequest, renderResponse);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._workflowPortletTabServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, WorkflowPortletTab.class, (String)"portal.workflow.tabs.name");
    }

    protected void addRenderRequestAttributes(RenderRequest renderRequest) {
        renderRequest.setAttribute("WORKFLOW_PORTLET_TABS", this.getWorkflowPortletTabs());
        renderRequest.setAttribute("SELECTED_WORKFLOW_PORTLET_TAB", (Object)this.getSelectedWorkflowPortletTab(renderRequest));
    }

    @Deactivate
    protected void deactivate() {
        this._workflowPortletTabServiceTrackerMap.close();
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        for (WorkflowPortletTab workflowPortletTab : this.getWorkflowPortletTabs()) {
            workflowPortletTab.prepareDispatch(renderRequest, renderResponse);
        }
        super.doDispatch(renderRequest, renderResponse);
    }

    protected WorkflowPortletTab getSelectedWorkflowPortletTab(RenderRequest renderRequest) {
        String workflowPortletTabName = ParamUtil.get((PortletRequest)renderRequest, (String)"tab", (String)this.getDefaultWorkflowPortletTabName());
        return (WorkflowPortletTab)this._workflowPortletTabServiceTrackerMap.getService((Object)workflowPortletTabName);
    }

    protected WorkflowPortletTab getWorkflowPortletTab(String name) {
        return (WorkflowPortletTab)this._workflowPortletTabServiceTrackerMap.getService((Object)name);
    }
}

