/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.portlet.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.workflow.web.internal.portlet.action.DeployWorkflowDefinitionMVCActionCommand;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet", "mvc.command.name=duplicateWorkflowDefinition"}, service={MVCActionCommand.class})
public class DuplicateWorkflowDefinitionMVCActionCommand
extends DeployWorkflowDefinitionMVCActionCommand {
    @Override
    protected void addDefaultTitle(ActionRequest actionRequest, Map<Locale, String> titleMap) {
        String title = titleMap.get(LocaleUtil.getDefault());
        if (titleMap.isEmpty() || Validator.isNull((String)title)) {
            title = ParamUtil.getString((PortletRequest)actionRequest, (String)"defaultDuplicationTitle");
            titleMap.put(LocaleUtil.getDefault(), title);
        }
    }

    @Override
    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String randomNamespace = ParamUtil.getString((PortletRequest)actionRequest, (String)"randomNamespace");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)(randomNamespace + "title"));
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        WorkflowDefinition workflowDefinition = this.workflowDefinitionManager.deployWorkflowDefinition(themeDisplay.getCompanyId(), themeDisplay.getUserId(), this.getTitle(actionRequest, titleMap), name, content.getBytes());
        this.setRedirectAttribute(actionRequest, workflowDefinition);
        this.sendRedirect(actionRequest, actionResponse);
    }

    @Override
    protected String getSuccessMessage(ActionRequest actionRequest) {
        ResourceBundle resourceBundle = this.getResourceBundle(actionRequest);
        String duplicatedDefinitionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"duplicatedDefinitionTitle");
        return LanguageUtil.format((ResourceBundle)resourceBundle, (String)"duplicated-from-x", (Object)StringUtil.quote((String)duplicatedDefinitionName));
    }
}

