/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.JSPCreationMenu;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.AggregatePredicateFilter;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManagerUtil;
import com.liferay.portal.workflow.web.internal.display.context.util.WorkflowDefinitionRequestHelper;
import com.liferay.portal.workflow.web.internal.search.WorkflowDefinitionSearch;
import com.liferay.portal.workflow.web.internal.search.WorkflowDefinitionSearchTerms;
import com.liferay.portal.workflow.web.internal.util.WorkflowDefinitionPortletUtil;
import com.liferay.portal.workflow.web.internal.util.filter.WorkflowDefinitionActivePredicateFilter;
import com.liferay.portal.workflow.web.internal.util.filter.WorkflowDefinitionDescriptionPredicateFilter;
import com.liferay.portal.workflow.web.internal.util.filter.WorkflowDefinitionTitlePredicateFilter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class WorkflowDefinitionDisplayContext {
    private static final String _HTML = "<a class='alert-link' href='[$RENDER_URL$]'>[$MESSAGE$]</a>";
    private final ResourceBundleLoader _resourceBundleLoader;
    private final UserLocalService _userLocalService;
    private final WorkflowDefinitionRequestHelper _workflowDefinitionRequestHelper;

    public WorkflowDefinitionDisplayContext(RenderRequest renderRequest, ResourceBundleLoader resourceBundleLoader, UserLocalService userLocalService) {
        this._resourceBundleLoader = resourceBundleLoader;
        this._userLocalService = userLocalService;
        this._workflowDefinitionRequestHelper = new WorkflowDefinitionRequestHelper(renderRequest);
    }

    public String getActive(WorkflowDefinition workflowDefinition) {
        HttpServletRequest request = this._workflowDefinitionRequestHelper.getRequest();
        if (workflowDefinition.isActive()) {
            return LanguageUtil.get((HttpServletRequest)request, (String)"yes");
        }
        return LanguageUtil.get((HttpServletRequest)request, (String)"no");
    }

    public String getClearResultsURL(HttpServletRequest request) {
        PortletURL clearResultsURL = this._getPortletURL(request);
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public Date getCreatedDate(WorkflowDefinition workflowDefinition) throws PortalException {
        List<WorkflowDefinition> workflowDefinitions = this.getWorkflowDefinitions(workflowDefinition.getName());
        WorkflowDefinition firstWorkflowDefinition = workflowDefinitions.get(0);
        return firstWorkflowDefinition.getModifiedDate();
    }

    public JSPCreationMenu getCreationMenu(PageContext pageContext) {
        final LiferayPortletResponse response = this._workflowDefinitionRequestHelper.getLiferayPortletResponse();
        return new JSPCreationMenu(pageContext){
            {
                super(x0);
                this.addPrimaryDropdownItem(dropdownItem -> {
                    dropdownItem.setHref(response.createRenderURL(), new Object[]{"mvcPath", "/definition/edit_workflow_definition.jsp"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)WorkflowDefinitionDisplayContext.this._workflowDefinitionRequestHelper.getRequest(), (String)"new-workflow"));
                });
            }
        };
    }

    public String getCreatorUserName(WorkflowDefinition workflowDefinition) throws PortalException {
        List<WorkflowDefinition> workflowDefinitions = this.getWorkflowDefinitions(workflowDefinition.getName());
        WorkflowDefinition firstWorkflowDefinition = workflowDefinitions.get(0);
        return this.getUserName(firstWorkflowDefinition);
    }

    public String getDescription(WorkflowDefinition workflowDefinition) {
        return HtmlUtil.escape((String)workflowDefinition.getDescription());
    }

    public String getDuplicateTitle(WorkflowDefinition workflowDefinition) {
        if (workflowDefinition == null) {
            return "";
        }
        ResourceBundle resourceBundle = this.getResourceBundle();
        String title = workflowDefinition.getTitle();
        String defaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)title);
        String newTitle = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"copy-of-x", (Object)workflowDefinition.getTitle(defaultLanguageId));
        return LocalizationUtil.updateLocalization((String)title, (String)"title", (String)newTitle, (String)defaultLanguageId);
    }

    public DropdownItemList getFilterOptions(final HttpServletRequest request) {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems((List)new DropdownItemList(){
                        {
                            this.add(WorkflowDefinitionDisplayContext.this._getFilterNavigationDropdownItem("all", WorkflowDefinitionDisplayContext.this._getCurrentNavigation(request), "all"));
                            this.add(WorkflowDefinitionDisplayContext.this._getFilterNavigationDropdownItem("published", WorkflowDefinitionDisplayContext.this._getCurrentNavigation(request), "published"));
                            this.add(WorkflowDefinitionDisplayContext.this._getFilterNavigationDropdownItem("not-published", WorkflowDefinitionDisplayContext.this._getCurrentNavigation(request), "not-published"));
                        }
                    });
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)WorkflowDefinitionDisplayContext.this._workflowDefinitionRequestHelper.getRequest(), (String)"filter"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems((List)new DropdownItemList(){
                        {
                            this.add(WorkflowDefinitionDisplayContext.this._getOrderByDropdownItem("last-modified", WorkflowDefinitionDisplayContext.this._getCurrentOrder(request), request));
                            this.add(WorkflowDefinitionDisplayContext.this._getOrderByDropdownItem("title", WorkflowDefinitionDisplayContext.this._getCurrentOrder(request), request));
                        }
                    });
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)WorkflowDefinitionDisplayContext.this._workflowDefinitionRequestHelper.getRequest(), (String)"order-by"));
                });
            }
        };
    }

    public Object[] getMessageArguments(List<WorkflowDefinitionLink> workflowDefinitionLinks) throws PortletException {
        if (workflowDefinitionLinks.isEmpty()) {
            return new Object[0];
        }
        if (workflowDefinitionLinks.size() == 1) {
            WorkflowDefinitionLink workflowDefinitionLink = workflowDefinitionLinks.get(0);
            return new Object[]{this.getLocalizedAssetName(workflowDefinitionLink.getClassName()), this.getConfigureAssignementLink()};
        }
        if (workflowDefinitionLinks.size() == 2) {
            WorkflowDefinitionLink workflowDefinitionLink1 = workflowDefinitionLinks.get(0);
            WorkflowDefinitionLink workflowDefinitionLink2 = workflowDefinitionLinks.get(1);
            return new Object[]{this.getLocalizedAssetName(workflowDefinitionLink1.getClassName()), this.getLocalizedAssetName(workflowDefinitionLink2.getClassName()), this.getConfigureAssignementLink()};
        }
        int moreAssets = workflowDefinitionLinks.size() - 2;
        WorkflowDefinitionLink workflowDefinitionLink1 = workflowDefinitionLinks.get(0);
        WorkflowDefinitionLink workflowDefinitionLink2 = workflowDefinitionLinks.get(1);
        return new Object[]{this.getLocalizedAssetName(workflowDefinitionLink1.getClassName()), this.getLocalizedAssetName(workflowDefinitionLink2.getClassName()), moreAssets, this.getConfigureAssignementLink()};
    }

    public String getMessageKey(List<WorkflowDefinitionLink> workflowDefinitionLinks) {
        if (workflowDefinitionLinks.isEmpty()) {
            return "";
        }
        if (workflowDefinitionLinks.size() == 1) {
            return "workflow-in-use-remove-assignement-to-x-x";
        }
        if (workflowDefinitionLinks.size() == 2) {
            return "workflow-in-use-remove-assignements-to-x-and-x-x";
        }
        return "workflow-in-use-remove-assignements-to-x-x-and-x-more-x";
    }

    public Date getModifiedDate(WorkflowDefinition workflowDefinition) {
        return workflowDefinition.getModifiedDate();
    }

    public String getName(WorkflowDefinition workflowDefinition) {
        return HtmlUtil.escape((String)workflowDefinition.getName());
    }

    public SearchContainer<WorkflowDefinition> getSearch(HttpServletRequest request, RenderRequest renderRequest, int status) throws PortalException {
        WorkflowDefinitionSearch workflowDefinitionSearch = new WorkflowDefinitionSearch((PortletRequest)renderRequest, this._getPortletURL(request));
        workflowDefinitionSearch.setEmptyResultsMessage("no-workflow-definitions-are-defined");
        List<Object> workflowDefinitions = WorkflowDefinitionManagerUtil.getLatestWorkflowDefinitions((long)this._workflowDefinitionRequestHelper.getCompanyId(), (int)-1, (int)-1, this.getWorkflowDefinitionOrderByComparator());
        WorkflowDefinitionSearchTerms searchTerms = new WorkflowDefinitionSearchTerms((PortletRequest)renderRequest);
        workflowDefinitions = searchTerms.isAdvancedSearch() ? this.filter((List<WorkflowDefinition>)workflowDefinitions, searchTerms.getDescription(), searchTerms.getTitle(), status, searchTerms.isAndOperator()) : this.filter((List<WorkflowDefinition>)workflowDefinitions, searchTerms.getKeywords(), searchTerms.getKeywords(), status, false);
        workflowDefinitionSearch.setTotal(workflowDefinitions.size());
        if (workflowDefinitions.size() > workflowDefinitionSearch.getEnd() - workflowDefinitionSearch.getStart()) {
            workflowDefinitions = ListUtil.subList(workflowDefinitions, (int)workflowDefinitionSearch.getStart(), (int)workflowDefinitionSearch.getEnd());
        }
        workflowDefinitionSearch.setTotal(workflowDefinitions.size());
        workflowDefinitionSearch.setResults(workflowDefinitions);
        return workflowDefinitionSearch;
    }

    public String getSearchURL(HttpServletRequest request) {
        PortletURL portletURL = this._getPortletURL(null);
        ThemeDisplay themeDisplay = this._workflowDefinitionRequestHelper.getThemeDisplay();
        portletURL.setParameter("mvcPath", "/view.jsp");
        portletURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
        portletURL.setParameter("tab", "workflows");
        return portletURL.toString();
    }

    public String getSortingURL(HttpServletRequest request) throws PortletException {
        String orderByType = ParamUtil.getString((HttpServletRequest)request, (String)"orderByType", (String)"asc");
        LiferayPortletResponse response = this._workflowDefinitionRequestHelper.getLiferayPortletResponse();
        PortletURL portletURL = response.createRenderURL();
        portletURL.setParameter("orderByType", Objects.equals(orderByType, "asc") ? "desc" : "asc");
        String definitionsNavigation = ParamUtil.getString((HttpServletRequest)request, (String)"definitionsNavigation");
        if (Validator.isNotNull((String)definitionsNavigation)) {
            portletURL.setParameter("definitionsNavigation", definitionsNavigation);
        }
        return portletURL.toString();
    }

    public String getTitle(WorkflowDefinition workflowDefinition) {
        ThemeDisplay themeDisplay = this._workflowDefinitionRequestHelper.getThemeDisplay();
        return HtmlUtil.escape((String)workflowDefinition.getTitle(themeDisplay.getLanguageId()));
    }

    public int getTotalItems(HttpServletRequest request, RenderRequest renderRequest, int status) throws PortalException {
        SearchContainer<WorkflowDefinition> searchContainer = this.getSearch(request, renderRequest, status);
        return searchContainer.getTotal();
    }

    public String getUserName(WorkflowDefinition workflowDefinition) {
        User user = this._userLocalService.fetchUser(workflowDefinition.getUserId());
        if (user == null || user.isDefaultUser() || Validator.isNull((String)user.getFullName())) {
            return null;
        }
        return user.getFullName();
    }

    public String getUserNameOrBlank(WorkflowDefinition workflowDefinition) {
        String userName = this.getUserName(workflowDefinition);
        if (userName == null) {
            userName = "";
        }
        return userName;
    }

    public int getWorkflowDefinitionCount(WorkflowDefinition workflowDefinition) throws PortalException {
        return WorkflowDefinitionManagerUtil.getWorkflowDefinitionCount((long)this._workflowDefinitionRequestHelper.getCompanyId(), (String)workflowDefinition.getName());
    }

    public List<WorkflowDefinition> getWorkflowDefinitions(String name) throws PortalException {
        return WorkflowDefinitionManagerUtil.getWorkflowDefinitions((long)this._workflowDefinitionRequestHelper.getCompanyId(), (String)name, (int)-1, (int)-1, null);
    }

    public List<WorkflowDefinition> getWorkflowDefinitionsOrderByDesc(String name) throws PortalException {
        List<WorkflowDefinition> workFlowDefinitions = this.getWorkflowDefinitions(name);
        if (workFlowDefinitions.size() <= 1) {
            return workFlowDefinitions;
        }
        Collections.reverse(workFlowDefinitions);
        return workFlowDefinitions;
    }

    public boolean isDisabledManagementBar(HttpServletRequest request, RenderRequest renderRequest, int status) throws PortalException {
        SearchContainer<WorkflowDefinition> searchContainer = this.getSearch(request, renderRequest, status);
        return !searchContainer.hasResults();
    }

    protected PredicateFilter<WorkflowDefinition> createPredicateFilter(String description, String title, int status, boolean andOperator) {
        AggregatePredicateFilter aggregatePredicateFilter = new AggregatePredicateFilter((PredicateFilter)new WorkflowDefinitionTitlePredicateFilter(title));
        if (andOperator) {
            aggregatePredicateFilter.and((PredicateFilter)new WorkflowDefinitionDescriptionPredicateFilter(description));
        } else {
            aggregatePredicateFilter.or((PredicateFilter)new WorkflowDefinitionDescriptionPredicateFilter(description));
        }
        aggregatePredicateFilter.and((PredicateFilter)new WorkflowDefinitionActivePredicateFilter(status));
        return aggregatePredicateFilter;
    }

    protected List<WorkflowDefinition> filter(List<WorkflowDefinition> workflowDefinitions, String description, String title, int status, boolean andOperator) {
        if (status == 0 && Validator.isNull((String)title) && Validator.isNull((String)description)) {
            return workflowDefinitions;
        }
        PredicateFilter<WorkflowDefinition> predicateFilter = this.createPredicateFilter(description, title, status, andOperator);
        return ListUtil.filter(workflowDefinitions, predicateFilter);
    }

    protected String getConfigureAssignementLink() throws PortletException {
        PortletURL portletURL = this.getWorkflowDefinitionLinkPortletURL();
        ResourceBundle resourceBundle = this.getResourceBundle();
        return StringUtil.replace((String)_HTML, (String[])new String[]{"[$RENDER_URL$]", "[$MESSAGE$]"}, (String[])new String[]{portletURL.toString(), LanguageUtil.get((ResourceBundle)resourceBundle, (String)"configure-assignments")});
    }

    protected String getLocalizedAssetName(String className) {
        return ResourceActionsUtil.getModelResource((Locale)this._workflowDefinitionRequestHelper.getLocale(), (String)className);
    }

    protected ResourceBundle getResourceBundle() {
        return this._resourceBundleLoader.loadResourceBundle(this._workflowDefinitionRequestHelper.getLocale());
    }

    protected PortletURL getWorkflowDefinitionLinkPortletURL() {
        LiferayPortletResponse response = this._workflowDefinitionRequestHelper.getLiferayPortletResponse();
        LiferayPortletURL portletURL = response.createLiferayPortletURL("com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet", "RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/view.jsp");
        portletURL.setParameter("tab", "schemes");
        return portletURL;
    }

    protected OrderByComparator<WorkflowDefinition> getWorkflowDefinitionOrderByComparator() {
        String orderByCol = ParamUtil.getString((HttpServletRequest)this._workflowDefinitionRequestHelper.getRequest(), (String)"orderByCol", (String)"name");
        String orderByType = ParamUtil.getString((HttpServletRequest)this._workflowDefinitionRequestHelper.getRequest(), (String)"orderByType", (String)"asc");
        return WorkflowDefinitionPortletUtil.getWorkflowDefitionOrderByComparator(orderByCol, orderByType, this._workflowDefinitionRequestHelper.getLocale());
    }

    private String _getCurrentNavigation(HttpServletRequest request) {
        return ParamUtil.getString((HttpServletRequest)request, (String)"definitionsNavigation", (String)"all");
    }

    private String _getCurrentOrder(HttpServletRequest request) {
        return ParamUtil.getString((HttpServletRequest)request, (String)"orderByCol", (String)"title");
    }

    private Consumer<DropdownItem> _getFilterNavigationDropdownItem(String navigation, String currentNavigation, String definitionsNavigation) {
        return dropdownItem -> {
            dropdownItem.setActive(Objects.equals(currentNavigation, navigation));
            dropdownItem.setHref(this._getPortletURL(null), new Object[]{"definitionsNavigation", definitionsNavigation, "mvcPath", "/view.jsp", "tab", "workflows"});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._workflowDefinitionRequestHelper.getRequest(), (String)navigation));
        };
    }

    private Consumer<DropdownItem> _getOrderByDropdownItem(String orderByCol, String currentOrder, HttpServletRequest request) {
        return dropdownItem -> {
            dropdownItem.setActive(Objects.equals(currentOrder, orderByCol));
            dropdownItem.setHref(this._getPortletURL(request), new Object[]{"orderByCol", orderByCol});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._workflowDefinitionRequestHelper.getRequest(), (String)orderByCol));
        };
    }

    private PortletURL _getPortletURL(HttpServletRequest request) {
        LiferayPortletResponse liferayPortletResponse = this._workflowDefinitionRequestHelper.getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        if (request == null) {
            return portletURL;
        }
        String definitionsNavigation = ParamUtil.getString((HttpServletRequest)request, (String)"definitionsNavigation");
        if (Validator.isNotNull((String)definitionsNavigation)) {
            portletURL.setParameter("definitionsNavigation", definitionsNavigation);
        }
        String orderByType = ParamUtil.getString((HttpServletRequest)request, (String)"orderByType", (String)"asc");
        portletURL.setParameter("orderByType", orderByType);
        return portletURL;
    }
}

