/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.util.comparator;

import com.liferay.portal.kernel.util.CollatorUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import java.text.Collator;
import java.util.Locale;

public class WorkflowDefinitionTitleComparator
extends OrderByComparator<WorkflowDefinition> {
    public static final String ORDER_BY_ASC = "title ASC";
    public static final String ORDER_BY_DESC = "title DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"title"};
    private final boolean _ascending;
    private final Collator _collator;
    private final String _languageId;
    private final Locale _locale;

    public WorkflowDefinitionTitleComparator() {
        this(false, Locale.getDefault());
    }

    public WorkflowDefinitionTitleComparator(boolean ascending, Locale locale) {
        this._ascending = ascending;
        this._locale = locale;
        this._collator = CollatorUtil.getInstance((Locale)this._locale);
        this._languageId = LocaleUtil.toLanguageId((Locale)locale);
    }

    public int compare(WorkflowDefinition workflowDefinition1, WorkflowDefinition workflowDefinition2) {
        String workflowDefinitionTitle1 = workflowDefinition1.getTitle(this._languageId);
        String workflowDefinitionTitle2 = workflowDefinition2.getTitle(this._languageId);
        int value = this._collator.compare(workflowDefinitionTitle1, workflowDefinitionTitle2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

