/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.util.comparator;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.CollatorUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import java.text.Collator;
import java.util.Locale;

public class WorkflowDefinitionActiveComparator
extends OrderByComparator<WorkflowDefinition> {
    public static final String ORDER_BY_ASC = "active ASC";
    public static final String ORDER_BY_DESC = "active DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"active"};
    private final boolean _ascending;
    private final Collator _collator;
    private final Locale _locale;

    public WorkflowDefinitionActiveComparator() {
        this(false, Locale.getDefault());
    }

    public WorkflowDefinitionActiveComparator(boolean ascending, Locale locale) {
        this._ascending = ascending;
        this._locale = locale;
        this._collator = CollatorUtil.getInstance((Locale)this._locale);
    }

    public int compare(WorkflowDefinition workflowDefinition1, WorkflowDefinition workflowDefinition2) {
        String activeLabel1 = this.getActiveLabel(workflowDefinition1.isActive());
        String activeLabel2 = this.getActiveLabel(workflowDefinition2.isActive());
        int value = this._collator.compare(activeLabel1, activeLabel2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected String getActiveLabel(boolean active) {
        if (active) {
            return LanguageUtil.get((Locale)this._locale, (String)"yes");
        }
        return LanguageUtil.get((Locale)this._locale, (String)"no");
    }
}

