/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.portlet.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.web.internal.portlet.action.BaseWorkflowDefinitionMVCActionCommand;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet", "javax.portlet.name=com_liferay_portal_workflow_web_internal_portlet_SiteAdministrationWorkflowPortlet", "mvc.command.name=updateWorkflowDefinitionLink"}, service={MVCActionCommand.class})
public class UpdateWorkflowDefinitionLinkMVCActionCommand
extends BaseWorkflowDefinitionMVCActionCommand {
    private static final String _PREFIX = "workflowDefinitionName@";
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    @Override
    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        String workflowDefinition = (String)actionRequest.getAttribute("WORKFLOW_DEFINITION_NAME");
        String resource = ParamUtil.getString((PortletRequest)actionRequest, (String)"resource");
        String successMessage = "";
        successMessage = Validator.isNull((String)workflowDefinition) ? LanguageUtil.format((ResourceBundle)this.getResourceBundle(actionRequest), (String)"workflow-unassigned-from-x", (Object)resource) : LanguageUtil.format((ResourceBundle)this.getResourceBundle(actionRequest), (String)"workflow-assigned-to-x", (Object)resource);
        SessionMessages.add((PortletRequest)actionRequest, (String)"requestProcessed", (Object)successMessage);
    }

    @Override
    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String[] classNameAndWorkflowDefinition = this.getClassNameAndWorkflowDefinition(actionRequest);
        String className = classNameAndWorkflowDefinition[0];
        String workflowDefinition = classNameAndWorkflowDefinition[1];
        if (Validator.isNotNull((String)className)) {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            this._workflowDefinitionLinkLocalService.updateWorkflowDefinitionLink(themeDisplay.getUserId(), themeDisplay.getCompanyId(), groupId, className, 0L, 0L, workflowDefinition);
            actionRequest.setAttribute("WORKFLOW_DEFINITION_NAME", (Object)workflowDefinition);
        }
        this.sendRedirect(actionRequest, actionResponse);
    }

    protected String[] getClassNameAndWorkflowDefinition(ActionRequest actionRequest) {
        String className = "";
        String workflowDefinition = "";
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith(_PREFIX)) continue;
            className = name.substring(_PREFIX.length());
            workflowDefinition = ParamUtil.getString((PortletRequest)actionRequest, (String)name);
            break;
        }
        return new String[]{className, workflowDefinition};
    }

    @Reference(unbind="-")
    protected void setWorkflowDefinitionLinkLocalService(WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService) {
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
    }
}

