/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.portal.kernel.exception.NoSuchWorkflowDefinitionLinkException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.AggregatePredicateFilter;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactoryUtil;
import com.liferay.portal.workflow.web.internal.display.context.util.WorkflowDefinitionLinkRequestHelper;
import com.liferay.portal.workflow.web.internal.search.WorkflowDefinitionLinkSearch;
import com.liferay.portal.workflow.web.internal.search.WorkflowDefinitionLinkSearchEntry;
import com.liferay.portal.workflow.web.internal.search.WorkflowDefinitionLinkSearchTerms;
import com.liferay.portal.workflow.web.internal.util.WorkflowDefinitionLinkPortletUtil;
import com.liferay.portal.workflow.web.internal.util.filter.WorkflowDefinitionLinkSearchEntryLabelPredicateFilter;
import com.liferay.portal.workflow.web.internal.util.filter.WorkflowDefinitionLinkSearchEntryResourcePredicateFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class WorkflowDefinitionLinkDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowDefinitionLinkDisplayContext.class);
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _orderByCol;
    private String _orderByType;
    private final PortalPreferences _portalPreferences;
    private final HttpServletRequest _request;
    private final ResourceBundleLoader _resourceBundleLoader;
    private final WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;
    private final WorkflowDefinitionLinkRequestHelper _workflowDefinitionLinkRequestHelper;

    public WorkflowDefinitionLinkDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService, ResourceBundleLoader resourceBundleLoader) {
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
        this._liferayPortletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)renderRequest);
        this._liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)renderResponse);
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._workflowDefinitionLinkRequestHelper = new WorkflowDefinitionLinkRequestHelper(renderRequest);
        this._portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        this._resourceBundleLoader = resourceBundleLoader;
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getDefaultWorkflowDefinitionLabel(String className) throws PortalException {
        if (this.isControlPanelPortlet()) {
            return LanguageUtil.get((HttpServletRequest)this._workflowDefinitionLinkRequestHelper.getRequest(), (String)"no-workflow");
        }
        try {
            WorkflowDefinitionLink defaultWorkflowDefinitionLink = this._workflowDefinitionLinkLocalService.getDefaultWorkflowDefinitionLink(this._workflowDefinitionLinkRequestHelper.getCompanyId(), className, 0L, 0L);
            WorkflowDefinition defaultWorkflowDefinition = WorkflowDefinitionManagerUtil.getLatestWorkflowDefinition((long)this._workflowDefinitionLinkRequestHelper.getCompanyId(), (String)defaultWorkflowDefinitionLink.getWorkflowDefinitionName());
            return defaultWorkflowDefinition.getTitle();
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return LanguageUtil.get((HttpServletRequest)this._workflowDefinitionLinkRequestHelper.getRequest(), (String)"no-workflow");
        }
    }

    public DropdownItemList getFilterOptions(final HttpServletRequest request) {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems((List)new DropdownItemList(){
                        {
                            this.add(WorkflowDefinitionLinkDisplayContext.this._getOrderByDropdownItem("resource", WorkflowDefinitionLinkDisplayContext.this._getCurrentOrder(request)));
                            this.add(WorkflowDefinitionLinkDisplayContext.this._getOrderByDropdownItem("workflow", WorkflowDefinitionLinkDisplayContext.this._getCurrentOrder(request)));
                        }
                    });
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)WorkflowDefinitionLinkDisplayContext.this._workflowDefinitionLinkRequestHelper.getRequest(), (String)"order-by"));
                });
            }
        };
    }

    public long getGroupId() {
        if (this.isControlPanelPortlet()) {
            return 0L;
        }
        ThemeDisplay themeDisplay = this._workflowDefinitionLinkRequestHelper.getThemeDisplay();
        return themeDisplay.getSiteGroupIdOrLiveGroupId();
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol");
        if (Validator.isNull((String)this._orderByCol)) {
            this._orderByCol = this._portalPreferences.getValue("com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet", "definition-link-order-by-col", "resource");
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"saveOrderBy");
            if (saveOrderBy) {
                this._portalPreferences.setValue("com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet", "definition-link-order-by-col", this._orderByCol);
            }
        }
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType");
        if (Validator.isNull((String)this._orderByType)) {
            this._orderByType = this._portalPreferences.getValue("com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet", "definition-link-order-by-type", "asc");
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"saveOrderBy");
            if (saveOrderBy) {
                this._portalPreferences.setValue("com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet", "definition-link-order-by-type", this._orderByType);
            }
        }
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String keywords;
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view.jsp");
        portletURL.setParameter("tab", "schemes");
        portletURL.setParameter("tabs1", "default-configuration");
        String delta = ParamUtil.getString((HttpServletRequest)this._request, (String)"delta");
        if (Validator.isNotNull((String)delta)) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords")))) {
            portletURL.setParameter("keywords", keywords);
        }
        String orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        portletURL.setParameter("orderByType", orderByType);
        return portletURL;
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundleLoader.loadResourceBundle(this._workflowDefinitionLinkRequestHelper.getLocale());
    }

    public Map<String, String> getResourceTooltips() {
        HashMap<String, String> resourceTooltips = new HashMap<String, String>();
        resourceTooltips.put("com.liferay.blogs.model.BlogsEntry", LanguageUtil.get((ResourceBundle)this.getResourceBundle(), (String)"workflow-triggered-on-blog-post-submission"));
        resourceTooltips.put("com.liferay.calendar.model.CalendarBooking", LanguageUtil.get((ResourceBundle)this.getResourceBundle(), (String)"workflow-triggered-on-event-submission"));
        resourceTooltips.put("com.liferay.message.boards.model.MBDiscussion", LanguageUtil.get((ResourceBundle)this.getResourceBundle(), (String)"workflow-triggered-on-comment-submission"));
        resourceTooltips.put("com.liferay.knowledge.base.model.KBArticle", LanguageUtil.get((ResourceBundle)this.getResourceBundle(), (String)"workflow-triggered-on-article-submission"));
        resourceTooltips.put("com.liferay.message.boards.model.MBMessage", LanguageUtil.get((ResourceBundle)this.getResourceBundle(), (String)"workflow-triggered-on-message-submission"));
        resourceTooltips.put("com.liferay.portal.kernel.model.LayoutRevision", LanguageUtil.get((ResourceBundle)this.getResourceBundle(), (String)"workflow-triggered-on-page-modification-in-the-stage-enviroment"));
        resourceTooltips.put("com.liferay.wiki.model.WikiPage", LanguageUtil.get((ResourceBundle)this.getResourceBundle(), (String)"workflow-triggered-on-wiki-page-submission"));
        resourceTooltips.put("com.liferay.portal.kernel.model.User", LanguageUtil.get((ResourceBundle)this.getResourceBundle(), (String)"workflow-triggered-on-guest-user-account-submission"));
        resourceTooltips.put("com.liferay.journal.model.JournalArticle", LanguageUtil.get((ResourceBundle)this.getResourceBundle(), (String)"workflow-triggered-on-web-content-submission"));
        return resourceTooltips;
    }

    public WorkflowDefinitionLinkSearch getSearchContainer() throws PortalException {
        WorkflowDefinitionLinkSearch searchContainer = new WorkflowDefinitionLinkSearch((PortletRequest)this._liferayPortletRequest, this.getPortletURL());
        WorkflowDefinitionLinkSearchTerms searchTerms = (WorkflowDefinitionLinkSearchTerms)searchContainer.getSearchTerms();
        OrderByComparator<WorkflowDefinitionLinkSearchEntry> orderByComparator = WorkflowDefinitionLinkPortletUtil.getWorkflowDefinitionLinkOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        searchContainer.setOrderByCol(this.getOrderByCol());
        searchContainer.setOrderByComparator(orderByComparator);
        searchContainer.setOrderByType(this.getOrderByType());
        List<WorkflowDefinitionLinkSearchEntry> workflowDefinitionLinkSearchEntries = this.createWorkflowDefinitionLinkSearchEntryList();
        workflowDefinitionLinkSearchEntries = searchTerms.isAdvancedSearch() ? this.filter(workflowDefinitionLinkSearchEntries, searchTerms.getResource(), searchTerms.getWorkflow(), searchTerms.isAndOperator()) : this.filter(workflowDefinitionLinkSearchEntries, searchTerms.getKeywords(), searchTerms.getKeywords(), false);
        int total = workflowDefinitionLinkSearchEntries.size();
        searchContainer.setTotal(total);
        Collections.sort(workflowDefinitionLinkSearchEntries, searchContainer.getOrderByComparator());
        List results = ListUtil.subList(workflowDefinitionLinkSearchEntries, (int)searchContainer.getStart(), (int)searchContainer.getEnd());
        searchContainer.setResults(results);
        return searchContainer;
    }

    public String getSearchURL() {
        PortletURL portletURL = this.getPortletURL();
        ThemeDisplay themeDisplay = this._workflowDefinitionLinkRequestHelper.getThemeDisplay();
        portletURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
        return portletURL.toString();
    }

    public String getSortingURL() throws PortletException {
        LiferayPortletResponse response = this._workflowDefinitionLinkRequestHelper.getLiferayPortletResponse();
        PortletURL portletURL = response.createRenderURL();
        portletURL.setParameter("tab", "schemes");
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        String orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        portletURL.setParameter("orderByType", Objects.equals(orderByType, "asc") ? "desc" : "asc");
        return portletURL.toString();
    }

    public int getTotalItems() throws PortalException {
        WorkflowDefinitionLinkSearch searchContainer = this.getSearchContainer();
        return searchContainer.getTotal();
    }

    public String getWorkflowDefinitionLabel(WorkflowDefinition workflowDefinition) {
        String workflowDefinitionName = workflowDefinition.getTitle(LanguageUtil.getLanguageId((HttpServletRequest)this._workflowDefinitionLinkRequestHelper.getRequest()));
        return workflowDefinitionName;
    }

    public List<WorkflowDefinition> getWorkflowDefinitions() throws PortalException {
        return WorkflowDefinitionManagerUtil.getActiveWorkflowDefinitions((long)this._workflowDefinitionLinkRequestHelper.getCompanyId(), (int)-1, (int)-1, (OrderByComparator)WorkflowComparatorFactoryUtil.getDefinitionNameComparator((boolean)true));
    }

    public String getWorkflowDefinitionValue(WorkflowDefinition workflowDefinition) {
        return HtmlUtil.escapeAttribute((String)workflowDefinition.getName()) + "@" + workflowDefinition.getVersion();
    }

    public boolean isDisabledManagementBar() throws PortalException {
        WorkflowDefinitionLinkSearch searchContainer = this.getSearchContainer();
        return !searchContainer.hasResults();
    }

    public boolean isWorkflowDefinitionSelected(WorkflowDefinition workflowDefinition, String className) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = this.getWorkflowDefinitionLink(className);
        if (workflowDefinitionLink == null) {
            return false;
        }
        String workflowDefinitionName = workflowDefinitionLink.getWorkflowDefinitionName();
        return workflowDefinitionName.equals(workflowDefinition.getName()) && workflowDefinitionLink.getWorkflowDefinitionVersion() == workflowDefinition.getVersion();
    }

    public boolean showStripeMessage(HttpServletRequest request) {
        HttpSession httpSession = request.getSession(false);
        String showDefinitionLinkInfo = SessionClicks.get((HttpSession)httpSession, (String)"show_definition_link_info", (String)"");
        if (Validator.isNull((String)showDefinitionLinkInfo)) {
            SessionClicks.put((HttpSession)httpSession, (String)"show_definition_link_info", (String)"show_definition_link_info");
            return true;
        }
        return false;
    }

    protected PredicateFilter<WorkflowDefinitionLinkSearchEntry> createPredicateFilter(String resource, String workflowDefinitionLabel, boolean andOperator) {
        AggregatePredicateFilter aggregatePredicateFilter = new AggregatePredicateFilter((PredicateFilter)new WorkflowDefinitionLinkSearchEntryResourcePredicateFilter(resource));
        if (andOperator) {
            aggregatePredicateFilter.and((PredicateFilter)new WorkflowDefinitionLinkSearchEntryLabelPredicateFilter(workflowDefinitionLabel));
        } else {
            aggregatePredicateFilter.or((PredicateFilter)new WorkflowDefinitionLinkSearchEntryLabelPredicateFilter(workflowDefinitionLabel));
        }
        return aggregatePredicateFilter;
    }

    protected WorkflowDefinitionLinkSearchEntry createWorkflowDefinitionLinkSearchEntry(WorkflowHandler<?> workflowHandler) throws PortalException {
        String resource = ResourceActionsUtil.getModelResource((Locale)this._workflowDefinitionLinkRequestHelper.getLocale(), (String)workflowHandler.getClassName());
        String workflowDefinitionLabel = this.getWorkflowDefinitionLabel(workflowHandler);
        return new WorkflowDefinitionLinkSearchEntry(workflowHandler.getClassName(), resource, workflowDefinitionLabel);
    }

    protected List<WorkflowDefinitionLinkSearchEntry> createWorkflowDefinitionLinkSearchEntryList() throws PortalException {
        ArrayList<WorkflowDefinitionLinkSearchEntry> workflowDefinitionLinkSearchEntries = new ArrayList<WorkflowDefinitionLinkSearchEntry>();
        for (WorkflowHandler<?> workflowHandler : this.getWorkflowHandlers()) {
            WorkflowDefinitionLinkSearchEntry workflowDefinitionLinkSearchEntry = this.createWorkflowDefinitionLinkSearchEntry(workflowHandler);
            workflowDefinitionLinkSearchEntries.add(workflowDefinitionLinkSearchEntry);
        }
        return workflowDefinitionLinkSearchEntries;
    }

    protected List<WorkflowDefinitionLinkSearchEntry> filter(List<WorkflowDefinitionLinkSearchEntry> workflowDefinitionLinkSearchEntries, String resource, String workflowDefinitionLabel, boolean andOperator) {
        if (Validator.isNull((String)resource) && Validator.isNull((String)workflowDefinitionLabel)) {
            return workflowDefinitionLinkSearchEntries;
        }
        PredicateFilter<WorkflowDefinitionLinkSearchEntry> predicateFilter = this.createPredicateFilter(resource, workflowDefinitionLabel, andOperator);
        return ListUtil.filter(workflowDefinitionLinkSearchEntries, predicateFilter);
    }

    protected String getPortletName() {
        ThemeDisplay themeDisplay = this._workflowDefinitionLinkRequestHelper.getThemeDisplay();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return portletDisplay.getPortletName();
    }

    protected String getWorkflowDefinitionLabel(WorkflowHandler<?> workflowHandler) throws PortalException {
        List<WorkflowDefinition> workflowDefinitions = this.getWorkflowDefinitions();
        for (WorkflowDefinition workflowDefinition : workflowDefinitions) {
            if (!this.isWorkflowDefinitionSelected(workflowDefinition, workflowHandler.getClassName())) continue;
            return this.getWorkflowDefinitionLabel(workflowDefinition);
        }
        return this.getDefaultWorkflowDefinitionLabel(workflowHandler.getClassName());
    }

    protected WorkflowDefinitionLink getWorkflowDefinitionLink(String className) throws PortalException {
        try {
            if (this.isControlPanelPortlet()) {
                return this._workflowDefinitionLinkLocalService.getDefaultWorkflowDefinitionLink(this._workflowDefinitionLinkRequestHelper.getCompanyId(), className, 0L, 0L);
            }
            return this._workflowDefinitionLinkLocalService.getWorkflowDefinitionLink(this._workflowDefinitionLinkRequestHelper.getCompanyId(), this.getGroupId(), className, 0L, 0L, true);
        }
        catch (NoSuchWorkflowDefinitionLinkException nswdle) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nswdle, (Throwable)nswdle);
            }
            return null;
        }
    }

    protected List<WorkflowHandler<?>> getWorkflowHandlers() {
        List workflowHandlers = null;
        workflowHandlers = this.isControlPanelPortlet() ? WorkflowHandlerRegistryUtil.getWorkflowHandlers() : WorkflowHandlerRegistryUtil.getScopeableWorkflowHandlers();
        PredicateFilter predicateFilter = new PredicateFilter<WorkflowHandler<?>>(){

            public boolean filter(WorkflowHandler<?> workflowHandler) {
                return workflowHandler.isVisible();
            }
        };
        return ListUtil.filter((List)workflowHandlers, (PredicateFilter)predicateFilter);
    }

    protected boolean isControlPanelPortlet() {
        String portletName = this.getPortletName();
        return portletName.equals("com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet");
    }

    private String _getCurrentOrder(HttpServletRequest request) {
        return ParamUtil.getString((HttpServletRequest)request, (String)"orderByCol", (String)"resource");
    }

    private Consumer<DropdownItem> _getOrderByDropdownItem(String orderByCol, String currentOrder) {
        return dropdownItem -> {
            dropdownItem.setActive(Objects.equals(currentOrder, orderByCol));
            dropdownItem.setHref(this.getPortletURL(), new Object[]{"orderByCol", orderByCol});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._workflowDefinitionLinkRequestHelper.getRequest(), (String)orderByCol));
        };
    }
}

