/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.task.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.workflow.task.web.internal.permission.WorkflowTaskPermissionChecker;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", "mvc.command.name=assignWorkflowTask"}, service={MVCResourceCommand.class})
public class AssignTaskMVCResourceCommand
extends BaseMVCResourceCommand {
    @Reference
    protected WorkflowTaskManager workflowTaskManager;
    private final WorkflowTaskPermissionChecker _workflowTaskPermissionChecker = new WorkflowTaskPermissionChecker();

    protected void checkWorkflowTaskAssignmentPermission(long workflowTaskId, ThemeDisplay themeDisplay) throws Exception {
        WorkflowTask workflowTask = this.workflowTaskManager.getWorkflowTask(themeDisplay.getCompanyId(), workflowTaskId);
        long groupId = MapUtil.getLong((Map)workflowTask.getOptionalAttributes(), (String)"groupId", (long)themeDisplay.getSiteGroupId());
        if (!this._workflowTaskPermissionChecker.hasPermission(groupId, workflowTask, themeDisplay.getPermissionChecker())) {
            throw new PrincipalException(String.format("User %d does not have permission to assign task %d", themeDisplay.getUserId(), workflowTaskId));
        }
    }

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long workflowTaskId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"workflowTaskId");
        long assigneeUserId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"assigneeUserId");
        String comment = ParamUtil.getString((PortletRequest)resourceRequest, (String)"comment");
        this.checkWorkflowTaskAssignmentPermission(workflowTaskId, themeDisplay);
        this.workflowTaskManager.assignWorkflowTaskToUser(themeDisplay.getCompanyId(), themeDisplay.getUserId(), workflowTaskId, assigneeUserId, comment, null, null);
        SessionMessages.add((PortletRequest)resourceRequest, (String)"requestProcessed", (Object)"");
    }
}

