/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.task.web.internal.notifications;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.workflow.task.web.internal.permission.WorkflowTaskPermissionChecker;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet"}, service={UserNotificationHandler.class})
public class WorkflowTaskUserNotificationHandler
extends BaseUserNotificationHandler {
    private UserNotificationEventLocalService _userNotificationEventLocalService;
    private final WorkflowTaskPermissionChecker _workflowTaskPermissionChecker = new WorkflowTaskPermissionChecker();

    public WorkflowTaskUserNotificationHandler() {
        this.setOpenDialog(true);
        this.setPortletId("com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet");
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        if (!this.isWorkflowTaskVisible(jsonObject.getLong("workflowTaskId"), serviceContext)) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent.getUserNotificationEventId());
            return "";
        }
        return HtmlUtil.escape((String)jsonObject.getString("notificationMessage"));
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        String entryClassName = jsonObject.getString("entryClassName");
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)entryClassName);
        long workflowTaskId = jsonObject.getLong("workflowTaskId");
        if (workflowHandler == null || workflowTaskId <= 0L) {
            return "";
        }
        return workflowHandler.getURLEditWorkflowTask(workflowTaskId, serviceContext);
    }

    protected boolean isWorkflowTaskVisible(long workflowTaskId, ServiceContext serviceContext) throws WorkflowException {
        if (workflowTaskId <= 0L) {
            return true;
        }
        WorkflowTask workflowTask = WorkflowTaskManagerUtil.fetchWorkflowTask((long)serviceContext.getCompanyId(), (long)workflowTaskId);
        if (workflowTask == null) {
            return false;
        }
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        long groupId = MapUtil.getLong((Map)workflowTask.getOptionalAttributes(), (String)"groupId", (long)themeDisplay.getSiteGroupId());
        return this._workflowTaskPermissionChecker.hasPermission(groupId, workflowTask, themeDisplay.getPermissionChecker());
    }

    @Reference(unbind="-")
    protected void setUserNotificationEventLocalService(UserNotificationEventLocalService userNotificationEventLocalService) {
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }
}

