/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.task.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.workflow.task.web.internal.permission.WorkflowTaskPermissionChecker;
import com.liferay.portal.workflow.task.web.internal.portlet.action.WorkflowTaskBaseMVCActionCommand;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", "mvc.command.name=assignWorkflowTask"}, service={MVCActionCommand.class})
public class AssignTaskMVCActionCommand
extends WorkflowTaskBaseMVCActionCommand {
    private final WorkflowTaskPermissionChecker _workflowTaskPermissionChecker = new WorkflowTaskPermissionChecker();

    protected void checkWorkflowTaskAssignmentPermission(long workflowTaskId, ThemeDisplay themeDisplay) throws Exception {
        WorkflowTask workflowTask = WorkflowTaskManagerUtil.getWorkflowTask((long)themeDisplay.getCompanyId(), (long)workflowTaskId);
        if (!this._workflowTaskPermissionChecker.hasPermission(themeDisplay.getScopeGroupId(), workflowTask, themeDisplay.getPermissionChecker())) {
            throw new PrincipalException(String.format("User %d does not have permission to assign task %d", themeDisplay.getUserId(), workflowTaskId));
        }
    }

    @Override
    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long workflowTaskId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"workflowTaskId");
        long assigneeUserId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"assigneeUserId");
        String comment = ParamUtil.getString((PortletRequest)actionRequest, (String)"comment");
        this.checkWorkflowTaskAssignmentPermission(workflowTaskId, themeDisplay);
        WorkflowTaskManagerUtil.assignWorkflowTaskToUser((long)themeDisplay.getCompanyId(), (long)themeDisplay.getUserId(), (long)workflowTaskId, (long)assigneeUserId, (String)comment, null, null);
    }
}

