/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.task.web.internal.portlet;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.workflow.task.web.configuration.WorkflowTaskWebConfiguration;
import com.liferay.portal.workflow.task.web.internal.permission.WorkflowTaskPermissionChecker;
import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.workflow.task.web.configuration.WorkflowTaskWebConfiguration"}, immediate=true, property={"com.liferay.portlet.css-class-wrapper=portlet-workflow-tasks", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.footer-portlet-javascript=/js/main.js", "com.liferay.portlet.friendly-url-mapping=my_workflow_tasks", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.icon=/icons/my_workflow_task.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=My Workflow Tasks", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class MyWorkflowTaskPortlet
extends MVCPortlet {
    private final WorkflowTaskPermissionChecker _workflowTaskPermissionChecker = new WorkflowTaskPermissionChecker();
    private volatile WorkflowTaskWebConfiguration _workflowTaskWebConfiguration;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        super.processAction(actionRequest, actionResponse);
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
        if (StringUtil.equalsIgnoreCase((String)actionName, (String)"invokeTaglibDiscussion")) {
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    public void render(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        try {
            this.setWorkflowTaskRenderRequestAttribute(request);
        }
        catch (Exception e) {
            if (this.isSessionErrorException(e)) {
                this.hideDefaultErrorMessage((PortletRequest)request);
                SessionErrors.add((PortletRequest)request, e.getClass());
            }
            throw new PortletException((Throwable)e);
        }
        super.render(request, response);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._workflowTaskWebConfiguration = (WorkflowTaskWebConfiguration)ConfigurableUtil.createConfigurable(WorkflowTaskWebConfiguration.class, properties);
    }

    protected void checkWorkflowTaskViewPermission(WorkflowTask workflowTask, ThemeDisplay themeDisplay) throws PortalException {
        if (!this._workflowTaskPermissionChecker.hasPermission(themeDisplay.getScopeGroupId(), workflowTask, themeDisplay.getPermissionChecker())) {
            throw new PrincipalException(String.format("User %d does not have permission to view task %d", themeDisplay.getUserId(), workflowTask.getWorkflowTaskId()));
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses()) || SessionErrors.contains((PortletRequest)renderRequest, (String)WorkflowException.class.getName())) {
            this.hideDefaultErrorMessage((PortletRequest)renderRequest);
            this.include("/error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof WorkflowException || cause instanceof PrincipalException;
    }

    protected void setWorkflowTaskRenderRequestAttribute(RenderRequest renderRequest) throws PortalException {
        long workflowTaskId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"workflowTaskId");
        if (workflowTaskId > 0L) {
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            WorkflowTask workflowTask = WorkflowTaskManagerUtil.getWorkflowTask((long)themeDisplay.getCompanyId(), (long)workflowTaskId);
            this.checkWorkflowTaskViewPermission(workflowTask, themeDisplay);
            renderRequest.setAttribute("WORKFLOW_TASK", (Object)workflowTask);
        }
        renderRequest.setAttribute(WorkflowTaskWebConfiguration.class.getName(), (Object)this._workflowTaskWebConfiguration);
    }
}

