/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.task.web.internal.permission;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskAssignee;

public class WorkflowTaskPermissionChecker {
    public boolean hasPermission(long groupId, WorkflowTask workflowTask, PermissionChecker permissionChecker) {
        if (permissionChecker.isOmniadmin() || permissionChecker.isCompanyAdmin()) {
            return true;
        }
        if (!permissionChecker.isContentReviewer(permissionChecker.getCompanyId(), groupId)) {
            return false;
        }
        long[] roleIds = permissionChecker.getRoleIds(permissionChecker.getUserId(), groupId);
        for (WorkflowTaskAssignee workflowTaskAssignee : workflowTask.getWorkflowTaskAssignees()) {
            if (!this.isWorkflowTaskAssignableToRoles(workflowTaskAssignee, roleIds) && !this.isWorkflowTaskAssignableToUser(workflowTaskAssignee, permissionChecker.getUserId())) continue;
            return true;
        }
        return false;
    }

    protected boolean isWorkflowTaskAssignableToRoles(WorkflowTaskAssignee workflowTaskAssignee, long[] roleIds) {
        String assigneeClassName = workflowTaskAssignee.getAssigneeClassName();
        if (!assigneeClassName.equals(Role.class.getName())) {
            return false;
        }
        return ArrayUtil.contains((long[])roleIds, (long)workflowTaskAssignee.getAssigneeClassPK());
    }

    protected boolean isWorkflowTaskAssignableToUser(WorkflowTaskAssignee workflowTaskAssignee, long userId) {
        String assigneeClassName = workflowTaskAssignee.getAssigneeClassName();
        if (!assigneeClassName.equals(User.class.getName())) {
            return false;
        }
        return workflowTaskAssignee.getAssigneeClassPK() == userId;
    }
}

