/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.task.web.internal.notifications;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet"}, service={UserNotificationHandler.class})
public class WorkflowTaskUserNotificationHandler
extends BaseUserNotificationHandler {
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public WorkflowTaskUserNotificationHandler() {
        this.setOpenDialog(true);
        this.setPortletId("com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet");
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        long workflowTaskId = jsonObject.getLong("workflowTaskId");
        WorkflowTask workflowTask = WorkflowTaskManagerUtil.fetchWorkflowTask((long)serviceContext.getCompanyId(), (long)workflowTaskId);
        if (workflowTask == null) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent.getUserNotificationEventId());
            return null;
        }
        return HtmlUtil.escape((String)jsonObject.getString("notificationMessage"));
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        String entryClassName = jsonObject.getString("entryClassName");
        WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)entryClassName);
        if (workflowHandler == null) {
            return null;
        }
        long workflowTaskId = jsonObject.getLong("workflowTaskId");
        return workflowHandler.getURLEditWorkflowTask(workflowTaskId, serviceContext);
    }

    @Reference(unbind="-")
    protected void setUserNotificationEventLocalService(UserNotificationEventLocalService userNotificationEventLocalService) {
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }
}

