/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.task.web.internal.display.context;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.ResultRow;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowLog;
import com.liferay.portal.kernel.workflow.WorkflowLogManagerUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManagerUtil;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactoryUtil;
import com.liferay.portal.workflow.task.web.internal.display.context.util.WorkflowTaskRequestHelper;
import com.liferay.portal.workflow.task.web.internal.search.WorkflowTaskSearch;
import com.liferay.portal.workflow.task.web.internal.util.WorkflowTaskPortletUtil;
import java.io.Serializable;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class WorkflowTaskDisplayContext {
    private static final String[] _DISPLAY_VIEWS = new String[]{"descriptive", "list"};
    private final Format _dateFormatDateTime;
    private String _displayStyle;
    private String _keywords;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private final PortalPreferences _portalPreferences;
    private final HttpServletRequest _request;
    private final Map<Long, Role> _roles = new HashMap<Long, Role>();
    private final Map<Long, User> _users = new HashMap<Long, User>();
    private final WorkflowTaskRequestHelper _workflowTaskRequestHelper;

    public WorkflowTaskDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest);
        this._portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._dateFormatDateTime = FastDateFormatFactoryUtil.getDateTime((Locale)themeDisplay.getLocale(), (TimeZone)themeDisplay.getTimeZone());
        this._workflowTaskRequestHelper = new WorkflowTaskRequestHelper(this._request);
    }

    public String getActorName(long actorId) {
        return HtmlUtil.escape((String)PortalUtil.getUserName((long)actorId, (String)""));
    }

    public long[] getActorsIds(WorkflowTask workflowTask) throws PortalException {
        long[] pooledActorsIds;
        ArrayList<Long> pooledActorIdsList = new ArrayList<Long>();
        for (long pooledActorId : pooledActorsIds = this.getPooledActorsIds(workflowTask)) {
            if (pooledActorId == this._workflowTaskRequestHelper.getUserId()) continue;
            pooledActorIdsList.add(pooledActorId);
        }
        return ArrayUtil.toLongArray(pooledActorIdsList);
    }

    public AssetEntry getAssetEntry() throws PortalException {
        long assetEntryId = ParamUtil.getLong((PortletRequest)this._liferayPortletRequest, (String)"assetEntryId");
        AssetRendererFactory<?> assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getAssetEntry(assetEntryId);
    }

    public String getAssetIconCssClass(WorkflowTask workflowTask) throws PortalException {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowTask);
        return workflowHandler.getIconCssClass();
    }

    public AssetRenderer<?> getAssetRenderer() throws PortalException {
        long assetEntryClassPK = ParamUtil.getLong((HttpServletRequest)this._workflowTaskRequestHelper.getRequest(), (String)"assetEntryClassPK");
        AssetRendererFactory<?> assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getAssetRenderer(assetEntryClassPK, 0);
    }

    public AssetRenderer<?> getAssetRenderer(WorkflowTask workflowTask) throws PortalException, PortletException {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowTask);
        long classPK = this.getWorkflowContextEntryClassPK(workflowTask);
        return workflowHandler.getAssetRenderer(classPK);
    }

    public AssetRendererFactory<?> getAssetRendererFactory() {
        String type = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"type");
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByType((String)type);
    }

    public String getAssetTitle(WorkflowTask workflowTask) throws PortalException {
        long classPK = this.getWorkflowContextEntryClassPK(workflowTask);
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowTask);
        return HtmlUtil.escape((String)workflowHandler.getTitle(classPK, this._workflowTaskRequestHelper.getLocale()));
    }

    public String getAssetType(WorkflowTask workflowTask) throws PortalException {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowTask);
        return workflowHandler.getType(this._workflowTaskRequestHelper.getLocale());
    }

    public String getAssignedTheTaskMessageKey(WorkflowLog workflowLog) throws PortalException {
        User user = this._users.get(workflowLog.getUserId());
        if (user.isMale()) {
            return "x-assigned-the-task-to-himself";
        }
        return "x-assigned-the-task-to-herself";
    }

    public Object getAssignedTheTaskToMessageArguments(WorkflowLog workflowLog) throws PortalException {
        String actorName = this.getActorName(workflowLog);
        return new Object[]{HtmlUtil.escape((String)PortalUtil.getUserName((long)workflowLog.getAuditUserId(), (String)"")), HtmlUtil.escape((String)actorName)};
    }

    public String getCreateDate(WorkflowLog workflowLog) {
        return this._dateFormatDateTime.format(workflowLog.getCreateDate());
    }

    public String getCreateDate(WorkflowTask workflowTask) {
        return this._dateFormatDateTime.format(workflowTask.getCreateDate());
    }

    public String getCurrentURL() {
        PortletURL portletURL = PortletURLUtil.getCurrent((LiferayPortletRequest)this._liferayPortletRequest, (LiferayPortletResponse)this._liferayPortletResponse);
        return portletURL.toString();
    }

    public String getDescription(WorkflowTask workflowTask) {
        return HtmlUtil.escape((String)workflowTask.getDescription());
    }

    public String getDisplayStyle() {
        if (this._displayStyle == null) {
            this._displayStyle = WorkflowTaskPortletUtil.getWorkflowTaskDisplayStyle((PortletRequest)this._liferayPortletRequest, this.getDisplayViews());
        }
        return this._displayStyle;
    }

    public String[] getDisplayViews() {
        return _DISPLAY_VIEWS;
    }

    public Date getDueDate(WorkflowTask workflowTask) {
        return workflowTask.getDueDate();
    }

    public String getDueDateString(WorkflowTask workflowTask) {
        if (workflowTask.getDueDate() == null) {
            return LanguageUtil.get((HttpServletRequest)this._workflowTaskRequestHelper.getRequest(), (String)"never");
        }
        return this._dateFormatDateTime.format(workflowTask.getDueDate());
    }

    public PortletURL getEditPortletURL(WorkflowTask workflowTask) throws PortalException {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowTask);
        long classPK = this.getWorkflowContextEntryClassPK(workflowTask);
        return workflowHandler.getURLEdit(classPK, this._liferayPortletRequest, this._liferayPortletResponse);
    }

    public String getEditTaskName(WorkflowTask workflowTask) {
        return LanguageUtil.get((HttpServletRequest)this._workflowTaskRequestHelper.getRequest(), (String)HtmlUtil.escape((String)workflowTask.getName()));
    }

    public String getHeaderTitle(WorkflowTask workflowTask) throws PortalException {
        String taskName = LanguageUtil.get((HttpServletRequest)this._workflowTaskRequestHelper.getRequest(), (String)workflowTask.getName());
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowTask);
        long classPK = this.getWorkflowContextEntryClassPK(workflowTask);
        String title = workflowHandler.getTitle(classPK, this._workflowTaskRequestHelper.getLocale());
        return taskName + ": " + title;
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"keywords");
        return this._keywords;
    }

    public Date getLastActivityDate(WorkflowTask workflowTask) throws PortalException {
        WorkflowLog workflowLog = this.getWorkflowLog(workflowTask);
        if (workflowLog != null) {
            return workflowLog.getCreateDate();
        }
        return null;
    }

    public String[] getMetadataFields() {
        return new String[]{"author", "categories", "tags"};
    }

    public String getNavigation() {
        if (this._navigation != null) {
            return this._navigation;
        }
        this._navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all");
        return this._navigation;
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol");
        if (Validator.isNull((String)this._orderByCol)) {
            this._orderByCol = this._portalPreferences.getValue("com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", "order-by-col", "last-activity-date");
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"saveOrderBy");
            if (saveOrderBy) {
                this._portalPreferences.setValue("com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", "order-by-col", this._orderByCol);
            }
        }
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType");
        if (Validator.isNull((String)this._orderByType)) {
            this._orderByType = this._portalPreferences.getValue("com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", "order-by-type", "asc");
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"saveOrderBy");
            if (saveOrderBy) {
                this._portalPreferences.setValue("com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", "order-by-type", this._orderByType);
            }
        }
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("tabs1", this.getTabs1());
        String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation");
        if (Validator.isNotNull((String)navigation)) {
            portletURL.setParameter("navigation", this.getNavigation());
        }
        return portletURL;
    }

    public String getPreviewOfTitle(WorkflowTask workflowTask) throws PortalException {
        String className = this.getWorkflowContextEntryClassName(workflowTask);
        String modelResource = ResourceActionsUtil.getModelResource((Locale)this._workflowTaskRequestHelper.getLocale(), (String)className);
        return LanguageUtil.format((HttpServletRequest)this._workflowTaskRequestHelper.getRequest(), (String)"preview-of-x", (Object)modelResource, (boolean)false);
    }

    public String getPreviousAssigneeMessageArguments(WorkflowLog workflowLog) {
        String userName = PortalUtil.getUserName((long)workflowLog.getPreviousUserId(), (String)"");
        return HtmlUtil.escape((String)userName);
    }

    public List<WorkflowHandler<?>> getSearchableAssetsWorkflowHandlers() {
        ArrayList searchableAssetsWorkflowHandlers = new ArrayList();
        List workflowHandlers = WorkflowHandlerRegistryUtil.getWorkflowHandlers();
        for (WorkflowHandler workflowHandler : workflowHandlers) {
            if (!workflowHandler.isAssetTypeSearchable()) continue;
            searchableAssetsWorkflowHandlers.add(workflowHandler);
        }
        return searchableAssetsWorkflowHandlers;
    }

    public String getState(WorkflowTask workflowTask) throws PortalException {
        long companyId = this.getWorkflowCompanyId(workflowTask);
        long groupId = this.getWorkflowGroupId(workflowTask);
        String className = this.getWorkflowContextEntryClassName(workflowTask);
        long classPK = this.getWorkflowContextEntryClassPK(workflowTask);
        String state = WorkflowInstanceLinkLocalServiceUtil.getState((long)companyId, (long)groupId, (String)className, (long)classPK);
        return LanguageUtil.get((HttpServletRequest)this._workflowTaskRequestHelper.getRequest(), (String)state);
    }

    public String getTabs1() {
        return ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"tabs1", (String)"assigned-to-me");
    }

    public String getTaglibEditURL(WorkflowTask workflowTask) throws PortalException, PortletException {
        StringBundler sb = new StringBundler(7);
        sb.append("javascript:Liferay.Util.openWindow({id: '");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("editAsset', title: '");
        AssetRenderer<?> assetRenderer = this.getAssetRenderer(workflowTask);
        String assetTitle = HtmlUtil.escape((String)assetRenderer.getTitle(this._workflowTaskRequestHelper.getLocale()));
        sb.append(LanguageUtil.format((HttpServletRequest)this._workflowTaskRequestHelper.getRequest(), (String)"edit-x", (Object)assetTitle));
        sb.append("', uri:'");
        PortletURL editPortletURL = this.getEditPortletURL(workflowTask);
        ThemeDisplay themeDisplay = this._workflowTaskRequestHelper.getThemeDisplay();
        editPortletURL.setParameter("refererPlid", String.valueOf(themeDisplay.getPlid()));
        editPortletURL.setParameter("workflowTaskId", String.valueOf(workflowTask.getWorkflowTaskId()));
        editPortletURL.setPortletMode(PortletMode.VIEW);
        editPortletURL.setWindowState(LiferayWindowState.POP_UP);
        sb.append(HtmlUtil.escapeJS((String)editPortletURL.toString()));
        sb.append("'});");
        return sb.toString();
    }

    public String getTaglibViewDiffsURL(WorkflowTask workflowTask) throws PortalException, PortletException {
        StringBundler sb = new StringBundler(7);
        sb.append("javascript:Liferay.Util.openWindow({id: '");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("viewDiffs', title: '");
        String title = LanguageUtil.get((HttpServletRequest)this._workflowTaskRequestHelper.getRequest(), (String)"diffs");
        sb.append(HtmlUtil.escapeJS((String)title));
        sb.append("', uri:'");
        PortletURL viewDiffsPortletURL = this.getViewDiffsPortletURL(workflowTask);
        viewDiffsPortletURL.setParameter("redirect", this.getCurrentURL());
        viewDiffsPortletURL.setParameter("hideControls", Boolean.TRUE.toString());
        viewDiffsPortletURL.setWindowState(LiferayWindowState.POP_UP);
        viewDiffsPortletURL.setPortletMode(PortletMode.VIEW);
        sb.append(HtmlUtil.escapeJS((String)viewDiffsPortletURL.toString()));
        sb.append("'});");
        return sb.toString();
    }

    public Object getTaskCompletionMessageArguments(WorkflowLog workflowLog) throws PortalException {
        String actorName = this.getActorName(workflowLog);
        return new Object[]{HtmlUtil.escape((String)actorName), HtmlUtil.escape((String)workflowLog.getState())};
    }

    public String getTaskContentTitle(WorkflowTask workflowTask) throws PortalException {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowTask);
        long classPK = this.getWorkflowContextEntryClassPK(workflowTask);
        return HtmlUtil.escape((String)workflowHandler.getTitle(classPK, this._workflowTaskRequestHelper.getLocale()));
    }

    public String getTaskInitiallyAssignedMessageArguments(WorkflowLog workflowLog) throws PortalException {
        String actorName = this.getActorName(workflowLog);
        return HtmlUtil.escape((String)actorName);
    }

    public String getTaskName(WorkflowTask workflowTask) {
        return HtmlUtil.escape((String)workflowTask.getName());
    }

    public WorkflowTaskSearch getTasksAssignedToMe() throws PortalException {
        return this.searchTasks(false);
    }

    public WorkflowTaskSearch getTasksAssignedToMyRoles() throws PortalException {
        return this.searchTasks(true);
    }

    public Object getTaskUpdateMessageArguments(WorkflowLog workflowLog) throws PortalException {
        String actorName = this.getActorName(workflowLog);
        return HtmlUtil.escape((String)actorName);
    }

    public String getTransitionMessage(String transitionName) {
        if (Validator.isNull((String)transitionName)) {
            return "proceed";
        }
        return HtmlUtil.escape((String)transitionName);
    }

    public Object getTransitionMessageArguments(WorkflowLog workflowLog) throws PortalException {
        String actorName = this.getActorName(workflowLog);
        return new Object[]{HtmlUtil.escape((String)actorName), HtmlUtil.escape((String)workflowLog.getPreviousState()), HtmlUtil.escape((String)workflowLog.getState())};
    }

    public List<String> getTransitionNames(WorkflowTask workflowTask) throws PortalException {
        return WorkflowTaskManagerUtil.getNextTransitionNames((long)this._workflowTaskRequestHelper.getCompanyId(), (long)this._workflowTaskRequestHelper.getUserId(), (long)workflowTask.getWorkflowTaskId());
    }

    public String getUserFullName(WorkflowLog workflowLog) {
        User user = this._users.get(workflowLog.getUserId());
        return HtmlUtil.escape((String)user.getFullName());
    }

    public PortletURL getViewDiffsPortletURL(WorkflowTask workflowTask) throws PortalException {
        WorkflowHandler<?> workflowHandler = this.getWorkflowHandler(workflowTask);
        long classPK = this.getWorkflowContextEntryClassPK(workflowTask);
        return workflowHandler.getURLViewDiffs(classPK, this._liferayPortletRequest, this._liferayPortletResponse);
    }

    public WindowState getWindowState() {
        return this._liferayPortletRequest.getWindowState();
    }

    public long getWorkflowCompanyId(WorkflowTask workflowTask) throws PortalException {
        WorkflowInstance workflowInstance = this.getWorkflowInstance(workflowTask);
        Map workflowContext = workflowInstance.getWorkflowContext();
        return GetterUtil.getLong((String)((String)workflowContext.get("companyId")));
    }

    public String getWorkflowContextEntryClassName(WorkflowTask workflowTask) throws PortalException {
        Map<String, Serializable> workflowContext = this.getWorkflowContext(workflowTask);
        return (String)((Object)workflowContext.get("entryClassName"));
    }

    public long getWorkflowContextEntryClassPK(WorkflowTask workflowTask) throws PortalException {
        Map<String, Serializable> workflowContext = this.getWorkflowContext(workflowTask);
        return GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
    }

    public long getWorkflowGroupId(WorkflowTask workflowTask) throws PortalException {
        WorkflowInstance workflowInstance = this.getWorkflowInstance(workflowTask);
        Map workflowContext = workflowInstance.getWorkflowContext();
        return GetterUtil.getLong((String)((String)workflowContext.get("groupId")));
    }

    public WorkflowHandler<?> getWorkflowHandler(WorkflowTask workflowTask) throws PortalException {
        String className = this.getWorkflowContextEntryClassName(workflowTask);
        return WorkflowHandlerRegistryUtil.getWorkflowHandler((String)className);
    }

    public WorkflowInstance getWorkflowInstance(WorkflowTask workflowTask) throws PortalException {
        return WorkflowInstanceManagerUtil.getWorkflowInstance((long)this._workflowTaskRequestHelper.getCompanyId(), (long)this.getWorkflowInstanceId(workflowTask));
    }

    public long getWorkflowInstanceId(WorkflowTask workflowTask) {
        return workflowTask.getWorkflowInstanceId();
    }

    public WorkflowLog getWorkflowLog(WorkflowTask workflowTask) throws PortalException {
        List workflowLogs = WorkflowLogManagerUtil.getWorkflowLogsByWorkflowInstance((long)this._workflowTaskRequestHelper.getCompanyId(), (long)this.getWorkflowInstanceId(workflowTask), null, (int)0, (int)1, (OrderByComparator)WorkflowComparatorFactoryUtil.getLogCreateDateComparator());
        if (!workflowLogs.isEmpty()) {
            return (WorkflowLog)workflowLogs.get(0);
        }
        return null;
    }

    public String getWorkflowLogComment(WorkflowLog workflowLog) {
        return HtmlUtil.escape((String)workflowLog.getComment());
    }

    public String getWorkflowLogCreateDate(WorkflowLog workflowLog) {
        return this._dateFormatDateTime.format(workflowLog.getCreateDate());
    }

    public List<WorkflowLog> getWorkflowLogs(WorkflowTask workflowTask) throws PortalException {
        ArrayList<Integer> logTypes = new ArrayList<Integer>();
        logTypes.add(1);
        logTypes.add(3);
        logTypes.add(2);
        logTypes.add(0);
        return WorkflowLogManagerUtil.getWorkflowLogsByWorkflowInstance((long)this._workflowTaskRequestHelper.getCompanyId(), (long)this.getWorkflowInstanceId(workflowTask), logTypes, (int)-1, (int)-1, (OrderByComparator)WorkflowComparatorFactoryUtil.getLogCreateDateComparator((boolean)false));
    }

    public WorkflowTask getWorkflowTask() {
        ResultRow resultRow = (ResultRow)this._liferayPortletRequest.getAttribute("SEARCH_CONTAINER_RESULT_ROW");
        if (Validator.isNotNull((Object)resultRow)) {
            return (WorkflowTask)resultRow.getParameter("workflowTask");
        }
        return (WorkflowTask)this._liferayPortletRequest.getAttribute("WORKFLOW_TASK");
    }

    public Map<String, Object> getWorkflowTaskActionLinkData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        return data;
    }

    public String getWorkflowTaskAssigneeUserName(WorkflowTask workflowTask) {
        return PortalUtil.getUserName((long)workflowTask.getAssigneeUserId(), (String)"");
    }

    public String getWorkflowTaskRandomId() {
        String randomId = "";
        ResultRow resultRow = (ResultRow)this._liferayPortletRequest.getAttribute("SEARCH_CONTAINER_RESULT_ROW");
        if (resultRow != null) {
            randomId = StringUtil.randomId();
        }
        return randomId;
    }

    public String getWorkflowTaskUnassignedUserName() {
        return LanguageUtil.get((HttpServletRequest)this._workflowTaskRequestHelper.getRequest(), (String)"nobody");
    }

    public boolean hasEditPortletURL(WorkflowTask workflowTask) throws PortalException {
        PortletURL editPortletURL = this.getEditPortletURL(workflowTask);
        return editPortletURL != null;
    }

    public boolean hasOtherAssignees(WorkflowTask workflowTask) throws PortalException {
        if (workflowTask.isCompleted()) {
            return false;
        }
        return WorkflowTaskManagerUtil.hasOtherAssignees((long)workflowTask.getWorkflowTaskId(), (long)this._workflowTaskRequestHelper.getUserId());
    }

    public boolean hasViewDiffsPortletURL(WorkflowTask workflowTask) throws PortalException {
        PortletURL viewDiffsPortletURL = this.getViewDiffsPortletURL(workflowTask);
        return viewDiffsPortletURL != null;
    }

    public boolean isAssignedToMeTabSelected() {
        String tabs1 = this.getTabs1();
        return tabs1.equals("assigned-to-me");
    }

    public boolean isAssignedToMyRolesTabSelected() {
        String tabs1 = this.getTabs1();
        return tabs1.equals("assigned-to-my-roles");
    }

    public boolean isAssignedToUser(WorkflowTask workflowTask) {
        return workflowTask.getAssigneeUserId() == this._workflowTaskRequestHelper.getUserId();
    }

    public boolean isAuditUser(WorkflowLog workflowLog) {
        User user = null;
        if (workflowLog.getUserId() != 0L) {
            user = this._users.get(workflowLog.getUserId());
        }
        return user != null && workflowLog.getAuditUserId() == user.getUserId();
    }

    public boolean isNavigationAll() {
        return Objects.equals(this.getNavigation(), "all");
    }

    public boolean isNavigationCompleted() {
        return Objects.equals(this.getNavigation(), "completed");
    }

    public boolean isNavigationPending() {
        return Objects.equals(this.getNavigation(), "pending");
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    public boolean isShowEditURL(WorkflowTask workflowTask) {
        boolean showEditURL = false;
        if (workflowTask.getAssigneeUserId() == this._workflowTaskRequestHelper.getUserId() && !workflowTask.isCompleted()) {
            showEditURL = true;
        }
        return showEditURL;
    }

    protected String getActorName(WorkflowLog workflowLog) throws PortalException {
        if (workflowLog.getRoleId() != 0L) {
            Role role = this.getRole(workflowLog.getRoleId());
            return role.getDescriptiveName();
        }
        if (workflowLog.getUserId() != 0L) {
            User user = this.getUser(workflowLog.getUserId());
            return user.getFullName();
        }
        return "";
    }

    protected String getAssetType(String keywords) {
        for (WorkflowHandler<?> workflowHandler : this.getSearchableAssetsWorkflowHandlers()) {
            String assetType = workflowHandler.getType(this._workflowTaskRequestHelper.getLocale());
            if (!StringUtil.equalsIgnoreCase((String)keywords, (String)assetType)) continue;
            return workflowHandler.getClassName();
        }
        return "";
    }

    protected Boolean getCompleted() {
        if (this.isNavigationAll()) {
            return null;
        }
        if (this.isNavigationCompleted()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected String getCurParam(boolean searchByUserRoles) {
        Boolean completedTasks = this.getCompleted();
        String curParam = !searchByUserRoles && completedTasks == null ? "cur" : (!searchByUserRoles && completedTasks != false ? "cur1" : (!searchByUserRoles && completedTasks == false ? "cur2" : (searchByUserRoles && completedTasks == null ? "cur3" : (searchByUserRoles && completedTasks != false ? "cur4" : "cur5"))));
        return curParam;
    }

    protected long[] getPooledActorsIds(WorkflowTask workflowTask) throws PortalException {
        return WorkflowTaskManagerUtil.getPooledActorsIds((long)this._workflowTaskRequestHelper.getCompanyId(), (long)workflowTask.getWorkflowTaskId());
    }

    protected Role getRole(long roleId) throws PortalException {
        Role role = this._roles.get(roleId);
        if (role == null) {
            role = RoleLocalServiceUtil.getRole((long)roleId);
            this._roles.put(roleId, role);
        }
        return role;
    }

    protected User getUser(long userId) throws PortalException {
        User user = this._users.get(userId);
        if (user == null) {
            user = UserLocalServiceUtil.getUser((long)userId);
            this._users.put(userId, user);
        }
        return user;
    }

    protected Map<String, Serializable> getWorkflowContext(WorkflowTask workflowTask) throws PortalException {
        return this.getWorkflowInstance(workflowTask).getWorkflowContext();
    }

    protected WorkflowTaskSearch searchTasks(boolean searchByUserRoles) throws PortalException {
        WorkflowTaskSearch searchContainer = new WorkflowTaskSearch((PortletRequest)this._liferayPortletRequest, this.getCurParam(searchByUserRoles), this.getPortletURL());
        DisplayTerms searchTerms = searchContainer.getDisplayTerms();
        int total = WorkflowTaskManagerUtil.searchCount((long)this._workflowTaskRequestHelper.getCompanyId(), (long)this._workflowTaskRequestHelper.getUserId(), (String)searchTerms.getKeywords(), (String)this.getAssetType(searchTerms.getKeywords()), null, null, null, (Boolean)this.getCompleted(), (Boolean)searchByUserRoles, (boolean)false);
        searchContainer.setTotal(total);
        List results = WorkflowTaskManagerUtil.search((long)this._workflowTaskRequestHelper.getCompanyId(), (long)this._workflowTaskRequestHelper.getUserId(), (String)searchTerms.getKeywords(), (String)this.getAssetType(searchTerms.getKeywords()), null, null, null, (Boolean)this.getCompleted(), (Boolean)searchByUserRoles, (boolean)false, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)searchContainer.getOrderByComparator());
        searchContainer.setResults(results);
        this.setSearchContainerEmptyResultsMessage(searchContainer, searchByUserRoles, this.getCompleted());
        return searchContainer;
    }

    protected void setSearchContainerEmptyResultsMessage(WorkflowTaskSearch searchContainer, boolean searchByUserRoles, Boolean completedTasks) {
        DisplayTerms searchTerms = searchContainer.getDisplayTerms();
        if (!searchByUserRoles && completedTasks == null) {
            searchContainer.setEmptyResultsMessage("there-are-no-tasks-assigned-to-you");
        } else if (!searchByUserRoles && !completedTasks.booleanValue()) {
            searchContainer.setEmptyResultsMessage("there-are-no-pending-tasks-assigned-to-you");
        } else if (searchByUserRoles && completedTasks == null) {
            searchContainer.setEmptyResultsMessage("there-are-no-tasks-assigned-to-your-roles");
        } else if (searchByUserRoles && !completedTasks.booleanValue()) {
            searchContainer.setEmptyResultsMessage("there-are-no-pending-tasks-assigned-to-your-roles");
        } else {
            searchContainer.setEmptyResultsMessage("there-are-no-completed-tasks");
        }
        if (Validator.isNotNull((String)searchTerms.getKeywords())) {
            searchContainer.setEmptyResultsMessage(searchContainer.getEmptyResultsMessage() + "-with-the-specified-search-criteria");
        }
    }
}

