/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.workflow.kaleo.exception.NoSuchTransitionException;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.model.impl.KaleoTransitionImpl;
import com.liferay.portal.workflow.kaleo.model.impl.KaleoTransitionModelImpl;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTransitionPersistence;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class KaleoTransitionPersistenceImpl
extends BasePersistenceImpl<KaleoTransition>
implements KaleoTransitionPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = KaleoTransitionImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "kaleoTransition.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByKaleoDefinitionVersionId;
    private FinderPath _finderPathWithoutPaginationFindByKaleoDefinitionVersionId;
    private FinderPath _finderPathCountByKaleoDefinitionVersionId;
    private static final String _FINDER_COLUMN_KALEODEFINITIONVERSIONID_KALEODEFINITIONVERSIONID_2 = "kaleoTransition.kaleoDefinitionVersionId = ?";
    private FinderPath _finderPathWithPaginationFindByKaleoNodeId;
    private FinderPath _finderPathWithoutPaginationFindByKaleoNodeId;
    private FinderPath _finderPathCountByKaleoNodeId;
    private static final String _FINDER_COLUMN_KALEONODEID_KALEONODEID_2 = "kaleoTransition.kaleoNodeId = ?";
    private FinderPath _finderPathFetchByKNI_N;
    private FinderPath _finderPathCountByKNI_N;
    private static final String _FINDER_COLUMN_KNI_N_KALEONODEID_2 = "kaleoTransition.kaleoNodeId = ? AND ";
    private static final String _FINDER_COLUMN_KNI_N_NAME_2 = "kaleoTransition.name = ?";
    private static final String _FINDER_COLUMN_KNI_N_NAME_3 = "(kaleoTransition.name IS NULL OR kaleoTransition.name = '')";
    private FinderPath _finderPathFetchByKNI_DT;
    private FinderPath _finderPathCountByKNI_DT;
    private static final String _FINDER_COLUMN_KNI_DT_KALEONODEID_2 = "kaleoTransition.kaleoNodeId = ? AND ";
    private static final String _FINDER_COLUMN_KNI_DT_DEFAULTTRANSITION_2 = "kaleoTransition.defaultTransition = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_KALEOTRANSITION = "SELECT kaleoTransition FROM KaleoTransition kaleoTransition";
    private static final String _SQL_SELECT_KALEOTRANSITION_WHERE = "SELECT kaleoTransition FROM KaleoTransition kaleoTransition WHERE ";
    private static final String _SQL_COUNT_KALEOTRANSITION = "SELECT COUNT(kaleoTransition) FROM KaleoTransition kaleoTransition";
    private static final String _SQL_COUNT_KALEOTRANSITION_WHERE = "SELECT COUNT(kaleoTransition) FROM KaleoTransition kaleoTransition WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "kaleoTransition.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No KaleoTransition exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No KaleoTransition exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(KaleoTransitionPersistenceImpl.class);

    public List<KaleoTransition> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<KaleoTransition> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<KaleoTransition> findByCompanyId(long companyId, int start, int end, OrderByComparator<KaleoTransition> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<KaleoTransition> findByCompanyId(long companyId, int start, int end, OrderByComparator<KaleoTransition> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<KaleoTransition> list = null;
        if (retrieveFromCache && (list = (List<KaleoTransition>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (KaleoTransition kaleoTransition : list) {
                if (companyId == kaleoTransition.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_KALEOTRANSITION_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY kaleoTransition.kaleoTransitionId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KaleoTransition findByCompanyId_First(long companyId, OrderByComparator<KaleoTransition> orderByComparator) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (kaleoTransition != null) {
            return kaleoTransition;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchTransitionException(msg.toString());
    }

    public KaleoTransition fetchByCompanyId_First(long companyId, OrderByComparator<KaleoTransition> orderByComparator) {
        List<KaleoTransition> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoTransition findByCompanyId_Last(long companyId, OrderByComparator<KaleoTransition> orderByComparator) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (kaleoTransition != null) {
            return kaleoTransition;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchTransitionException(msg.toString());
    }

    public KaleoTransition fetchByCompanyId_Last(long companyId, OrderByComparator<KaleoTransition> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<KaleoTransition> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoTransition[] findByCompanyId_PrevAndNext(long kaleoTransitionId, long companyId, OrderByComparator<KaleoTransition> orderByComparator) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.findByPrimaryKey(kaleoTransitionId);
        Session session = null;
        try {
            session = this.openSession();
            KaleoTransition[] array = new KaleoTransitionImpl[]{this.getByCompanyId_PrevAndNext(session, kaleoTransition, companyId, orderByComparator, true), kaleoTransition, this.getByCompanyId_PrevAndNext(session, kaleoTransition, companyId, orderByComparator, false)};
            KaleoTransition[] kaleoTransitionArray = array;
            return kaleoTransitionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoTransition getByCompanyId_PrevAndNext(Session session, KaleoTransition kaleoTransition, long companyId, OrderByComparator<KaleoTransition> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_KALEOTRANSITION_WHERE);
        query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY kaleoTransition.kaleoTransitionId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kaleoTransition)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (KaleoTransition)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (KaleoTransition kaleoTransition : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)kaleoTransition);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_KALEOTRANSITION_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<KaleoTransition> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId) {
        return this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, -1, -1, null);
    }

    public List<KaleoTransition> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId, int start, int end) {
        return this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, start, end, null);
    }

    public List<KaleoTransition> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId, int start, int end, OrderByComparator<KaleoTransition> orderByComparator) {
        return this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, start, end, orderByComparator, true);
    }

    public List<KaleoTransition> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId, int start, int end, OrderByComparator<KaleoTransition> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId;
            finderArgs = new Object[]{kaleoDefinitionVersionId};
        } else {
            finderPath = this._finderPathWithPaginationFindByKaleoDefinitionVersionId;
            finderArgs = new Object[]{kaleoDefinitionVersionId, start, end, orderByComparator};
        }
        List<KaleoTransition> list = null;
        if (retrieveFromCache && (list = (List<KaleoTransition>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (KaleoTransition kaleoTransition : list) {
                if (kaleoDefinitionVersionId == kaleoTransition.getKaleoDefinitionVersionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_KALEOTRANSITION_WHERE);
            query.append(_FINDER_COLUMN_KALEODEFINITIONVERSIONID_KALEODEFINITIONVERSIONID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY kaleoTransition.kaleoTransitionId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoDefinitionVersionId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KaleoTransition findByKaleoDefinitionVersionId_First(long kaleoDefinitionVersionId, OrderByComparator<KaleoTransition> orderByComparator) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.fetchByKaleoDefinitionVersionId_First(kaleoDefinitionVersionId, orderByComparator);
        if (kaleoTransition != null) {
            return kaleoTransition;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("kaleoDefinitionVersionId=");
        msg.append(kaleoDefinitionVersionId);
        msg.append("}");
        throw new NoSuchTransitionException(msg.toString());
    }

    public KaleoTransition fetchByKaleoDefinitionVersionId_First(long kaleoDefinitionVersionId, OrderByComparator<KaleoTransition> orderByComparator) {
        List<KaleoTransition> list = this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoTransition findByKaleoDefinitionVersionId_Last(long kaleoDefinitionVersionId, OrderByComparator<KaleoTransition> orderByComparator) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.fetchByKaleoDefinitionVersionId_Last(kaleoDefinitionVersionId, orderByComparator);
        if (kaleoTransition != null) {
            return kaleoTransition;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("kaleoDefinitionVersionId=");
        msg.append(kaleoDefinitionVersionId);
        msg.append("}");
        throw new NoSuchTransitionException(msg.toString());
    }

    public KaleoTransition fetchByKaleoDefinitionVersionId_Last(long kaleoDefinitionVersionId, OrderByComparator<KaleoTransition> orderByComparator) {
        int count = this.countByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        if (count == 0) {
            return null;
        }
        List<KaleoTransition> list = this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoTransition[] findByKaleoDefinitionVersionId_PrevAndNext(long kaleoTransitionId, long kaleoDefinitionVersionId, OrderByComparator<KaleoTransition> orderByComparator) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.findByPrimaryKey(kaleoTransitionId);
        Session session = null;
        try {
            session = this.openSession();
            KaleoTransition[] array = new KaleoTransitionImpl[]{this.getByKaleoDefinitionVersionId_PrevAndNext(session, kaleoTransition, kaleoDefinitionVersionId, orderByComparator, true), kaleoTransition, this.getByKaleoDefinitionVersionId_PrevAndNext(session, kaleoTransition, kaleoDefinitionVersionId, orderByComparator, false)};
            KaleoTransition[] kaleoTransitionArray = array;
            return kaleoTransitionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoTransition getByKaleoDefinitionVersionId_PrevAndNext(Session session, KaleoTransition kaleoTransition, long kaleoDefinitionVersionId, OrderByComparator<KaleoTransition> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_KALEOTRANSITION_WHERE);
        query.append(_FINDER_COLUMN_KALEODEFINITIONVERSIONID_KALEODEFINITIONVERSIONID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY kaleoTransition.kaleoTransitionId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(kaleoDefinitionVersionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kaleoTransition)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (KaleoTransition)list.get(1);
        }
        return null;
    }

    public void removeByKaleoDefinitionVersionId(long kaleoDefinitionVersionId) {
        for (KaleoTransition kaleoTransition : this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, -1, -1, null)) {
            this.remove((BaseModel)kaleoTransition);
        }
    }

    public int countByKaleoDefinitionVersionId(long kaleoDefinitionVersionId) {
        FinderPath finderPath = this._finderPathCountByKaleoDefinitionVersionId;
        Object[] finderArgs = new Object[]{kaleoDefinitionVersionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_KALEOTRANSITION_WHERE);
            query.append(_FINDER_COLUMN_KALEODEFINITIONVERSIONID_KALEODEFINITIONVERSIONID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoDefinitionVersionId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<KaleoTransition> findByKaleoNodeId(long kaleoNodeId) {
        return this.findByKaleoNodeId(kaleoNodeId, -1, -1, null);
    }

    public List<KaleoTransition> findByKaleoNodeId(long kaleoNodeId, int start, int end) {
        return this.findByKaleoNodeId(kaleoNodeId, start, end, null);
    }

    public List<KaleoTransition> findByKaleoNodeId(long kaleoNodeId, int start, int end, OrderByComparator<KaleoTransition> orderByComparator) {
        return this.findByKaleoNodeId(kaleoNodeId, start, end, orderByComparator, true);
    }

    public List<KaleoTransition> findByKaleoNodeId(long kaleoNodeId, int start, int end, OrderByComparator<KaleoTransition> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByKaleoNodeId;
            finderArgs = new Object[]{kaleoNodeId};
        } else {
            finderPath = this._finderPathWithPaginationFindByKaleoNodeId;
            finderArgs = new Object[]{kaleoNodeId, start, end, orderByComparator};
        }
        List<KaleoTransition> list = null;
        if (retrieveFromCache && (list = (List<KaleoTransition>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (KaleoTransition kaleoTransition : list) {
                if (kaleoNodeId == kaleoTransition.getKaleoNodeId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_KALEOTRANSITION_WHERE);
            query.append(_FINDER_COLUMN_KALEONODEID_KALEONODEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY kaleoTransition.kaleoTransitionId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoNodeId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KaleoTransition findByKaleoNodeId_First(long kaleoNodeId, OrderByComparator<KaleoTransition> orderByComparator) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.fetchByKaleoNodeId_First(kaleoNodeId, orderByComparator);
        if (kaleoTransition != null) {
            return kaleoTransition;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("kaleoNodeId=");
        msg.append(kaleoNodeId);
        msg.append("}");
        throw new NoSuchTransitionException(msg.toString());
    }

    public KaleoTransition fetchByKaleoNodeId_First(long kaleoNodeId, OrderByComparator<KaleoTransition> orderByComparator) {
        List<KaleoTransition> list = this.findByKaleoNodeId(kaleoNodeId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoTransition findByKaleoNodeId_Last(long kaleoNodeId, OrderByComparator<KaleoTransition> orderByComparator) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.fetchByKaleoNodeId_Last(kaleoNodeId, orderByComparator);
        if (kaleoTransition != null) {
            return kaleoTransition;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("kaleoNodeId=");
        msg.append(kaleoNodeId);
        msg.append("}");
        throw new NoSuchTransitionException(msg.toString());
    }

    public KaleoTransition fetchByKaleoNodeId_Last(long kaleoNodeId, OrderByComparator<KaleoTransition> orderByComparator) {
        int count = this.countByKaleoNodeId(kaleoNodeId);
        if (count == 0) {
            return null;
        }
        List<KaleoTransition> list = this.findByKaleoNodeId(kaleoNodeId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoTransition[] findByKaleoNodeId_PrevAndNext(long kaleoTransitionId, long kaleoNodeId, OrderByComparator<KaleoTransition> orderByComparator) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.findByPrimaryKey(kaleoTransitionId);
        Session session = null;
        try {
            session = this.openSession();
            KaleoTransition[] array = new KaleoTransitionImpl[]{this.getByKaleoNodeId_PrevAndNext(session, kaleoTransition, kaleoNodeId, orderByComparator, true), kaleoTransition, this.getByKaleoNodeId_PrevAndNext(session, kaleoTransition, kaleoNodeId, orderByComparator, false)};
            KaleoTransition[] kaleoTransitionArray = array;
            return kaleoTransitionArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoTransition getByKaleoNodeId_PrevAndNext(Session session, KaleoTransition kaleoTransition, long kaleoNodeId, OrderByComparator<KaleoTransition> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_KALEOTRANSITION_WHERE);
        query.append(_FINDER_COLUMN_KALEONODEID_KALEONODEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY kaleoTransition.kaleoTransitionId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(kaleoNodeId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kaleoTransition)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (KaleoTransition)list.get(1);
        }
        return null;
    }

    public void removeByKaleoNodeId(long kaleoNodeId) {
        for (KaleoTransition kaleoTransition : this.findByKaleoNodeId(kaleoNodeId, -1, -1, null)) {
            this.remove((BaseModel)kaleoTransition);
        }
    }

    public int countByKaleoNodeId(long kaleoNodeId) {
        FinderPath finderPath = this._finderPathCountByKaleoNodeId;
        Object[] finderArgs = new Object[]{kaleoNodeId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_KALEOTRANSITION_WHERE);
            query.append(_FINDER_COLUMN_KALEONODEID_KALEONODEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoNodeId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public KaleoTransition findByKNI_N(long kaleoNodeId, String name) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.fetchByKNI_N(kaleoNodeId, name);
        if (kaleoTransition == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("kaleoNodeId=");
            msg.append(kaleoNodeId);
            msg.append(", name=");
            msg.append(name);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchTransitionException(msg.toString());
        }
        return kaleoTransition;
    }

    public KaleoTransition fetchByKNI_N(long kaleoNodeId, String name) {
        return this.fetchByKNI_N(kaleoNodeId, name, true);
    }

    public KaleoTransition fetchByKNI_N(long kaleoNodeId, String name, boolean retrieveFromCache) {
        KaleoTransition kaleoTransition;
        name = Objects.toString(name, "");
        Object[] finderArgs = new Object[]{kaleoNodeId, name};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(this._finderPathFetchByKNI_N, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof KaleoTransition && (kaleoNodeId != (kaleoTransition = (KaleoTransition)result).getKaleoNodeId() || !Objects.equals(name, kaleoTransition.getName()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_KALEOTRANSITION_WHERE);
            query.append("kaleoTransition.kaleoNodeId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_KNI_N_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_KNI_N_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoNodeId);
                if (bindName) {
                    qPos.add(name);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(this._finderPathFetchByKNI_N, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("KaleoTransitionPersistenceImpl.fetchByKNI_N(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    KaleoTransition kaleoTransition2 = (KaleoTransition)list.get(0);
                    result = kaleoTransition2;
                    this.cacheResult(kaleoTransition2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathFetchByKNI_N, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (KaleoTransition)result;
    }

    public KaleoTransition removeByKNI_N(long kaleoNodeId, String name) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.findByKNI_N(kaleoNodeId, name);
        return (KaleoTransition)this.remove((BaseModel)kaleoTransition);
    }

    public int countByKNI_N(long kaleoNodeId, String name) {
        name = Objects.toString(name, "");
        FinderPath finderPath = this._finderPathCountByKNI_N;
        Object[] finderArgs = new Object[]{kaleoNodeId, name};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_KALEOTRANSITION_WHERE);
            query.append("kaleoTransition.kaleoNodeId = ? AND ");
            boolean bindName = false;
            if (name.isEmpty()) {
                query.append(_FINDER_COLUMN_KNI_N_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_KNI_N_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoNodeId);
                if (bindName) {
                    qPos.add(name);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public KaleoTransition findByKNI_DT(long kaleoNodeId, boolean defaultTransition) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.fetchByKNI_DT(kaleoNodeId, defaultTransition);
        if (kaleoTransition == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("kaleoNodeId=");
            msg.append(kaleoNodeId);
            msg.append(", defaultTransition=");
            msg.append(defaultTransition);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchTransitionException(msg.toString());
        }
        return kaleoTransition;
    }

    public KaleoTransition fetchByKNI_DT(long kaleoNodeId, boolean defaultTransition) {
        return this.fetchByKNI_DT(kaleoNodeId, defaultTransition, true);
    }

    public KaleoTransition fetchByKNI_DT(long kaleoNodeId, boolean defaultTransition, boolean retrieveFromCache) {
        KaleoTransition kaleoTransition;
        Object[] finderArgs = new Object[]{kaleoNodeId, defaultTransition};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(this._finderPathFetchByKNI_DT, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof KaleoTransition && (kaleoNodeId != (kaleoTransition = (KaleoTransition)result).getKaleoNodeId() || defaultTransition != kaleoTransition.isDefaultTransition())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_KALEOTRANSITION_WHERE);
            query.append("kaleoTransition.kaleoNodeId = ? AND ");
            query.append(_FINDER_COLUMN_KNI_DT_DEFAULTTRANSITION_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoNodeId);
                qPos.add(defaultTransition);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(this._finderPathFetchByKNI_DT, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("KaleoTransitionPersistenceImpl.fetchByKNI_DT(long, boolean, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    KaleoTransition kaleoTransition2 = (KaleoTransition)list.get(0);
                    result = kaleoTransition2;
                    this.cacheResult(kaleoTransition2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathFetchByKNI_DT, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (KaleoTransition)result;
    }

    public KaleoTransition removeByKNI_DT(long kaleoNodeId, boolean defaultTransition) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = this.findByKNI_DT(kaleoNodeId, defaultTransition);
        return (KaleoTransition)this.remove((BaseModel)kaleoTransition);
    }

    public int countByKNI_DT(long kaleoNodeId, boolean defaultTransition) {
        FinderPath finderPath = this._finderPathCountByKNI_DT;
        Object[] finderArgs = new Object[]{kaleoNodeId, defaultTransition};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_KALEOTRANSITION_WHERE);
            query.append("kaleoTransition.kaleoNodeId = ? AND ");
            query.append(_FINDER_COLUMN_KNI_DT_DEFAULTTRANSITION_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoNodeId);
                qPos.add(defaultTransition);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public KaleoTransitionPersistenceImpl() {
        this.setModelClass(KaleoTransition.class);
        this.setModelImplClass(KaleoTransitionImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED);
    }

    public void cacheResult(KaleoTransition kaleoTransition) {
        this.entityCache.putResult(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionImpl.class, (Serializable)Long.valueOf(kaleoTransition.getPrimaryKey()), (Serializable)kaleoTransition);
        this.finderCache.putResult(this._finderPathFetchByKNI_N, new Object[]{kaleoTransition.getKaleoNodeId(), kaleoTransition.getName()}, (Object)kaleoTransition);
        this.finderCache.putResult(this._finderPathFetchByKNI_DT, new Object[]{kaleoTransition.getKaleoNodeId(), kaleoTransition.isDefaultTransition()}, (Object)kaleoTransition);
        kaleoTransition.resetOriginalValues();
    }

    public void cacheResult(List<KaleoTransition> kaleoTransitions) {
        for (KaleoTransition kaleoTransition : kaleoTransitions) {
            if (this.entityCache.getResult(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionImpl.class, (Serializable)Long.valueOf(kaleoTransition.getPrimaryKey())) == null) {
                this.cacheResult(kaleoTransition);
                continue;
            }
            kaleoTransition.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(KaleoTransitionImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(KaleoTransition kaleoTransition) {
        this.entityCache.removeResult(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionImpl.class, (Serializable)Long.valueOf(kaleoTransition.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((KaleoTransitionModelImpl)kaleoTransition, true);
    }

    public void clearCache(List<KaleoTransition> kaleoTransitions) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (KaleoTransition kaleoTransition : kaleoTransitions) {
            this.entityCache.removeResult(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionImpl.class, (Serializable)Long.valueOf(kaleoTransition.getPrimaryKey()));
            this.clearUniqueFindersCache((KaleoTransitionModelImpl)kaleoTransition, true);
        }
    }

    protected void cacheUniqueFindersCache(KaleoTransitionModelImpl kaleoTransitionModelImpl) {
        Object[] args = new Object[]{kaleoTransitionModelImpl.getKaleoNodeId(), kaleoTransitionModelImpl.getName()};
        this.finderCache.putResult(this._finderPathCountByKNI_N, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByKNI_N, args, (Object)kaleoTransitionModelImpl, false);
        args = new Object[]{kaleoTransitionModelImpl.getKaleoNodeId(), kaleoTransitionModelImpl.isDefaultTransition()};
        this.finderCache.putResult(this._finderPathCountByKNI_DT, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByKNI_DT, args, (Object)kaleoTransitionModelImpl, false);
    }

    protected void clearUniqueFindersCache(KaleoTransitionModelImpl kaleoTransitionModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{kaleoTransitionModelImpl.getKaleoNodeId(), kaleoTransitionModelImpl.getName()};
            this.finderCache.removeResult(this._finderPathCountByKNI_N, args);
            this.finderCache.removeResult(this._finderPathFetchByKNI_N, args);
        }
        if ((kaleoTransitionModelImpl.getColumnBitmask() & this._finderPathFetchByKNI_N.getColumnBitmask()) != 0L) {
            args = new Object[]{kaleoTransitionModelImpl.getOriginalKaleoNodeId(), kaleoTransitionModelImpl.getOriginalName()};
            this.finderCache.removeResult(this._finderPathCountByKNI_N, args);
            this.finderCache.removeResult(this._finderPathFetchByKNI_N, args);
        }
        if (clearCurrent) {
            args = new Object[]{kaleoTransitionModelImpl.getKaleoNodeId(), kaleoTransitionModelImpl.isDefaultTransition()};
            this.finderCache.removeResult(this._finderPathCountByKNI_DT, args);
            this.finderCache.removeResult(this._finderPathFetchByKNI_DT, args);
        }
        if ((kaleoTransitionModelImpl.getColumnBitmask() & this._finderPathFetchByKNI_DT.getColumnBitmask()) != 0L) {
            args = new Object[]{kaleoTransitionModelImpl.getOriginalKaleoNodeId(), kaleoTransitionModelImpl.getOriginalDefaultTransition()};
            this.finderCache.removeResult(this._finderPathCountByKNI_DT, args);
            this.finderCache.removeResult(this._finderPathFetchByKNI_DT, args);
        }
    }

    public KaleoTransition create(long kaleoTransitionId) {
        KaleoTransitionImpl kaleoTransition = new KaleoTransitionImpl();
        kaleoTransition.setNew(true);
        kaleoTransition.setPrimaryKey(kaleoTransitionId);
        kaleoTransition.setCompanyId(this.companyProvider.getCompanyId());
        return kaleoTransition;
    }

    public KaleoTransition remove(long kaleoTransitionId) throws NoSuchTransitionException {
        return this.remove(Long.valueOf(kaleoTransitionId));
    }

    public KaleoTransition remove(Serializable primaryKey) throws NoSuchTransitionException {
        Session session = null;
        try {
            session = this.openSession();
            KaleoTransition kaleoTransition = (KaleoTransition)session.get(KaleoTransitionImpl.class, primaryKey);
            if (kaleoTransition == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchTransitionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            KaleoTransition kaleoTransition2 = (KaleoTransition)this.remove((BaseModel)kaleoTransition);
            return kaleoTransition2;
        }
        catch (NoSuchTransitionException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoTransition removeImpl(KaleoTransition kaleoTransition) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)kaleoTransition)) {
                kaleoTransition = (KaleoTransition)session.get(KaleoTransitionImpl.class, kaleoTransition.getPrimaryKeyObj());
            }
            if (kaleoTransition != null) {
                session.delete((Object)kaleoTransition);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (kaleoTransition != null) {
            this.clearCache(kaleoTransition);
        }
        return kaleoTransition;
    }

    public KaleoTransition updateImpl(KaleoTransition kaleoTransition) {
        boolean isNew = kaleoTransition.isNew();
        if (!(kaleoTransition instanceof KaleoTransitionModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(kaleoTransition.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)kaleoTransition);
                throw new IllegalArgumentException("Implement ModelWrapper in kaleoTransition proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom KaleoTransition implementation " + kaleoTransition.getClass());
        }
        KaleoTransitionModelImpl kaleoTransitionModelImpl = (KaleoTransitionModelImpl)kaleoTransition;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && kaleoTransition.getCreateDate() == null) {
            if (serviceContext == null) {
                kaleoTransition.setCreateDate(now);
            } else {
                kaleoTransition.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!kaleoTransitionModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                kaleoTransition.setModifiedDate(now);
            } else {
                kaleoTransition.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (kaleoTransition.isNew()) {
                session.save((Object)kaleoTransition);
                kaleoTransition.setNew(false);
            } else {
                kaleoTransition = (KaleoTransition)session.merge((Object)kaleoTransition);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!KaleoTransitionModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{kaleoTransitionModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{kaleoTransitionModelImpl.getKaleoDefinitionVersionId()};
            this.finderCache.removeResult(this._finderPathCountByKaleoDefinitionVersionId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId, args);
            args = new Object[]{kaleoTransitionModelImpl.getKaleoNodeId()};
            this.finderCache.removeResult(this._finderPathCountByKaleoNodeId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoNodeId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((kaleoTransitionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{kaleoTransitionModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{kaleoTransitionModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((kaleoTransitionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId.getColumnBitmask()) != 0L) {
                args = new Object[]{kaleoTransitionModelImpl.getOriginalKaleoDefinitionVersionId()};
                this.finderCache.removeResult(this._finderPathCountByKaleoDefinitionVersionId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId, args);
                args = new Object[]{kaleoTransitionModelImpl.getKaleoDefinitionVersionId()};
                this.finderCache.removeResult(this._finderPathCountByKaleoDefinitionVersionId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId, args);
            }
            if ((kaleoTransitionModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByKaleoNodeId.getColumnBitmask()) != 0L) {
                args = new Object[]{kaleoTransitionModelImpl.getOriginalKaleoNodeId()};
                this.finderCache.removeResult(this._finderPathCountByKaleoNodeId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoNodeId, args);
                args = new Object[]{kaleoTransitionModelImpl.getKaleoNodeId()};
                this.finderCache.removeResult(this._finderPathCountByKaleoNodeId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoNodeId, args);
            }
        }
        this.entityCache.putResult(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionImpl.class, (Serializable)Long.valueOf(kaleoTransition.getPrimaryKey()), (Serializable)kaleoTransition, false);
        this.clearUniqueFindersCache(kaleoTransitionModelImpl, false);
        this.cacheUniqueFindersCache(kaleoTransitionModelImpl);
        kaleoTransition.resetOriginalValues();
        return kaleoTransition;
    }

    public KaleoTransition findByPrimaryKey(Serializable primaryKey) throws NoSuchTransitionException {
        KaleoTransition kaleoTransition = (KaleoTransition)this.fetchByPrimaryKey(primaryKey);
        if (kaleoTransition == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchTransitionException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return kaleoTransition;
    }

    public KaleoTransition findByPrimaryKey(long kaleoTransitionId) throws NoSuchTransitionException {
        return this.findByPrimaryKey(Long.valueOf(kaleoTransitionId));
    }

    public KaleoTransition fetchByPrimaryKey(long kaleoTransitionId) {
        return (KaleoTransition)this.fetchByPrimaryKey(Long.valueOf(kaleoTransitionId));
    }

    public List<KaleoTransition> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<KaleoTransition> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<KaleoTransition> findAll(int start, int end, OrderByComparator<KaleoTransition> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<KaleoTransition> findAll(int start, int end, OrderByComparator<KaleoTransition> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_KALEOTRANSITION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_KALEOTRANSITION;
                if (pagination) {
                    sql = sql.concat(" ORDER BY kaleoTransition.kaleoTransitionId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (KaleoTransition kaleoTransition : this.findAll()) {
            this.remove((BaseModel)kaleoTransition);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_KALEOTRANSITION);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "kaleoTransitionId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_KALEOTRANSITION;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return KaleoTransitionModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, KaleoTransitionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, KaleoTransitionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, KaleoTransitionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, KaleoTransitionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByCompanyId = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByKaleoDefinitionVersionId = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, KaleoTransitionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByKaleoDefinitionVersionId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, KaleoTransitionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByKaleoDefinitionVersionId", new String[]{Long.class.getName()}, 4L);
        this._finderPathCountByKaleoDefinitionVersionId = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByKaleoDefinitionVersionId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByKaleoNodeId = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, KaleoTransitionImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByKaleoNodeId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByKaleoNodeId = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, KaleoTransitionImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByKaleoNodeId", new String[]{Long.class.getName()}, 8L);
        this._finderPathCountByKaleoNodeId = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByKaleoNodeId", new String[]{Long.class.getName()});
        this._finderPathFetchByKNI_N = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, KaleoTransitionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByKNI_N", new String[]{Long.class.getName(), String.class.getName()}, 24L);
        this._finderPathCountByKNI_N = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByKNI_N", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathFetchByKNI_DT = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, KaleoTransitionImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByKNI_DT", new String[]{Long.class.getName(), Boolean.class.getName()}, 10L);
        this._finderPathCountByKNI_DT = new FinderPath(KaleoTransitionModelImpl.ENTITY_CACHE_ENABLED, KaleoTransitionModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByKNI_DT", new String[]{Long.class.getName(), Boolean.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(KaleoTransitionImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

