/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.workflow.kaleo.exception.NoSuchTaskException;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.impl.KaleoTaskImpl;
import com.liferay.portal.workflow.kaleo.model.impl.KaleoTaskModelImpl;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTaskPersistence;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class KaleoTaskPersistenceImpl
extends BasePersistenceImpl<KaleoTask>
implements KaleoTaskPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = KaleoTaskImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "kaleoTask.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByKaleoDefinitionVersionId;
    private FinderPath _finderPathWithoutPaginationFindByKaleoDefinitionVersionId;
    private FinderPath _finderPathCountByKaleoDefinitionVersionId;
    private static final String _FINDER_COLUMN_KALEODEFINITIONVERSIONID_KALEODEFINITIONVERSIONID_2 = "kaleoTask.kaleoDefinitionVersionId = ?";
    private FinderPath _finderPathFetchByKaleoNodeId;
    private FinderPath _finderPathCountByKaleoNodeId;
    private static final String _FINDER_COLUMN_KALEONODEID_KALEONODEID_2 = "kaleoTask.kaleoNodeId = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_KALEOTASK = "SELECT kaleoTask FROM KaleoTask kaleoTask";
    private static final String _SQL_SELECT_KALEOTASK_WHERE = "SELECT kaleoTask FROM KaleoTask kaleoTask WHERE ";
    private static final String _SQL_COUNT_KALEOTASK = "SELECT COUNT(kaleoTask) FROM KaleoTask kaleoTask";
    private static final String _SQL_COUNT_KALEOTASK_WHERE = "SELECT COUNT(kaleoTask) FROM KaleoTask kaleoTask WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "kaleoTask.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No KaleoTask exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No KaleoTask exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(KaleoTaskPersistenceImpl.class);

    public List<KaleoTask> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<KaleoTask> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<KaleoTask> findByCompanyId(long companyId, int start, int end, OrderByComparator<KaleoTask> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<KaleoTask> findByCompanyId(long companyId, int start, int end, OrderByComparator<KaleoTask> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<KaleoTask> list = null;
        if (retrieveFromCache && (list = (List<KaleoTask>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (KaleoTask kaleoTask : list) {
                if (companyId == kaleoTask.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_KALEOTASK_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY kaleoTask.kaleoTaskId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KaleoTask findByCompanyId_First(long companyId, OrderByComparator<KaleoTask> orderByComparator) throws NoSuchTaskException {
        KaleoTask kaleoTask = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (kaleoTask != null) {
            return kaleoTask;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchTaskException(msg.toString());
    }

    public KaleoTask fetchByCompanyId_First(long companyId, OrderByComparator<KaleoTask> orderByComparator) {
        List<KaleoTask> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoTask findByCompanyId_Last(long companyId, OrderByComparator<KaleoTask> orderByComparator) throws NoSuchTaskException {
        KaleoTask kaleoTask = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (kaleoTask != null) {
            return kaleoTask;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchTaskException(msg.toString());
    }

    public KaleoTask fetchByCompanyId_Last(long companyId, OrderByComparator<KaleoTask> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<KaleoTask> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoTask[] findByCompanyId_PrevAndNext(long kaleoTaskId, long companyId, OrderByComparator<KaleoTask> orderByComparator) throws NoSuchTaskException {
        KaleoTask kaleoTask = this.findByPrimaryKey(kaleoTaskId);
        Session session = null;
        try {
            session = this.openSession();
            KaleoTask[] array = new KaleoTaskImpl[]{this.getByCompanyId_PrevAndNext(session, kaleoTask, companyId, orderByComparator, true), kaleoTask, this.getByCompanyId_PrevAndNext(session, kaleoTask, companyId, orderByComparator, false)};
            KaleoTask[] kaleoTaskArray = array;
            return kaleoTaskArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoTask getByCompanyId_PrevAndNext(Session session, KaleoTask kaleoTask, long companyId, OrderByComparator<KaleoTask> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_KALEOTASK_WHERE);
        query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY kaleoTask.kaleoTaskId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kaleoTask)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (KaleoTask)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (KaleoTask kaleoTask : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)kaleoTask);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_KALEOTASK_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<KaleoTask> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId) {
        return this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, -1, -1, null);
    }

    public List<KaleoTask> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId, int start, int end) {
        return this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, start, end, null);
    }

    public List<KaleoTask> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId, int start, int end, OrderByComparator<KaleoTask> orderByComparator) {
        return this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, start, end, orderByComparator, true);
    }

    public List<KaleoTask> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId, int start, int end, OrderByComparator<KaleoTask> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId;
            finderArgs = new Object[]{kaleoDefinitionVersionId};
        } else {
            finderPath = this._finderPathWithPaginationFindByKaleoDefinitionVersionId;
            finderArgs = new Object[]{kaleoDefinitionVersionId, start, end, orderByComparator};
        }
        List<KaleoTask> list = null;
        if (retrieveFromCache && (list = (List<KaleoTask>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (KaleoTask kaleoTask : list) {
                if (kaleoDefinitionVersionId == kaleoTask.getKaleoDefinitionVersionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_KALEOTASK_WHERE);
            query.append(_FINDER_COLUMN_KALEODEFINITIONVERSIONID_KALEODEFINITIONVERSIONID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY kaleoTask.kaleoTaskId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoDefinitionVersionId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KaleoTask findByKaleoDefinitionVersionId_First(long kaleoDefinitionVersionId, OrderByComparator<KaleoTask> orderByComparator) throws NoSuchTaskException {
        KaleoTask kaleoTask = this.fetchByKaleoDefinitionVersionId_First(kaleoDefinitionVersionId, orderByComparator);
        if (kaleoTask != null) {
            return kaleoTask;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("kaleoDefinitionVersionId=");
        msg.append(kaleoDefinitionVersionId);
        msg.append("}");
        throw new NoSuchTaskException(msg.toString());
    }

    public KaleoTask fetchByKaleoDefinitionVersionId_First(long kaleoDefinitionVersionId, OrderByComparator<KaleoTask> orderByComparator) {
        List<KaleoTask> list = this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoTask findByKaleoDefinitionVersionId_Last(long kaleoDefinitionVersionId, OrderByComparator<KaleoTask> orderByComparator) throws NoSuchTaskException {
        KaleoTask kaleoTask = this.fetchByKaleoDefinitionVersionId_Last(kaleoDefinitionVersionId, orderByComparator);
        if (kaleoTask != null) {
            return kaleoTask;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("kaleoDefinitionVersionId=");
        msg.append(kaleoDefinitionVersionId);
        msg.append("}");
        throw new NoSuchTaskException(msg.toString());
    }

    public KaleoTask fetchByKaleoDefinitionVersionId_Last(long kaleoDefinitionVersionId, OrderByComparator<KaleoTask> orderByComparator) {
        int count = this.countByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        if (count == 0) {
            return null;
        }
        List<KaleoTask> list = this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoTask[] findByKaleoDefinitionVersionId_PrevAndNext(long kaleoTaskId, long kaleoDefinitionVersionId, OrderByComparator<KaleoTask> orderByComparator) throws NoSuchTaskException {
        KaleoTask kaleoTask = this.findByPrimaryKey(kaleoTaskId);
        Session session = null;
        try {
            session = this.openSession();
            KaleoTask[] array = new KaleoTaskImpl[]{this.getByKaleoDefinitionVersionId_PrevAndNext(session, kaleoTask, kaleoDefinitionVersionId, orderByComparator, true), kaleoTask, this.getByKaleoDefinitionVersionId_PrevAndNext(session, kaleoTask, kaleoDefinitionVersionId, orderByComparator, false)};
            KaleoTask[] kaleoTaskArray = array;
            return kaleoTaskArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoTask getByKaleoDefinitionVersionId_PrevAndNext(Session session, KaleoTask kaleoTask, long kaleoDefinitionVersionId, OrderByComparator<KaleoTask> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_KALEOTASK_WHERE);
        query.append(_FINDER_COLUMN_KALEODEFINITIONVERSIONID_KALEODEFINITIONVERSIONID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY kaleoTask.kaleoTaskId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(kaleoDefinitionVersionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kaleoTask)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (KaleoTask)list.get(1);
        }
        return null;
    }

    public void removeByKaleoDefinitionVersionId(long kaleoDefinitionVersionId) {
        for (KaleoTask kaleoTask : this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, -1, -1, null)) {
            this.remove((BaseModel)kaleoTask);
        }
    }

    public int countByKaleoDefinitionVersionId(long kaleoDefinitionVersionId) {
        FinderPath finderPath = this._finderPathCountByKaleoDefinitionVersionId;
        Object[] finderArgs = new Object[]{kaleoDefinitionVersionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_KALEOTASK_WHERE);
            query.append(_FINDER_COLUMN_KALEODEFINITIONVERSIONID_KALEODEFINITIONVERSIONID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoDefinitionVersionId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public KaleoTask findByKaleoNodeId(long kaleoNodeId) throws NoSuchTaskException {
        KaleoTask kaleoTask = this.fetchByKaleoNodeId(kaleoNodeId);
        if (kaleoTask == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("kaleoNodeId=");
            msg.append(kaleoNodeId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchTaskException(msg.toString());
        }
        return kaleoTask;
    }

    public KaleoTask fetchByKaleoNodeId(long kaleoNodeId) {
        return this.fetchByKaleoNodeId(kaleoNodeId, true);
    }

    public KaleoTask fetchByKaleoNodeId(long kaleoNodeId, boolean retrieveFromCache) {
        KaleoTask kaleoTask;
        Object[] finderArgs = new Object[]{kaleoNodeId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(this._finderPathFetchByKaleoNodeId, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof KaleoTask && kaleoNodeId != (kaleoTask = (KaleoTask)result).getKaleoNodeId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_KALEOTASK_WHERE);
            query.append(_FINDER_COLUMN_KALEONODEID_KALEONODEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoNodeId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(this._finderPathFetchByKaleoNodeId, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("KaleoTaskPersistenceImpl.fetchByKaleoNodeId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    KaleoTask kaleoTask2 = (KaleoTask)list.get(0);
                    result = kaleoTask2;
                    this.cacheResult(kaleoTask2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathFetchByKaleoNodeId, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (KaleoTask)result;
    }

    public KaleoTask removeByKaleoNodeId(long kaleoNodeId) throws NoSuchTaskException {
        KaleoTask kaleoTask = this.findByKaleoNodeId(kaleoNodeId);
        return (KaleoTask)this.remove((BaseModel)kaleoTask);
    }

    public int countByKaleoNodeId(long kaleoNodeId) {
        FinderPath finderPath = this._finderPathCountByKaleoNodeId;
        Object[] finderArgs = new Object[]{kaleoNodeId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_KALEOTASK_WHERE);
            query.append(_FINDER_COLUMN_KALEONODEID_KALEONODEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoNodeId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public KaleoTaskPersistenceImpl() {
        this.setModelClass(KaleoTask.class);
        this.setModelImplClass(KaleoTaskImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED);
    }

    public void cacheResult(KaleoTask kaleoTask) {
        this.entityCache.putResult(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskImpl.class, (Serializable)Long.valueOf(kaleoTask.getPrimaryKey()), (Serializable)kaleoTask);
        this.finderCache.putResult(this._finderPathFetchByKaleoNodeId, new Object[]{kaleoTask.getKaleoNodeId()}, (Object)kaleoTask);
        kaleoTask.resetOriginalValues();
    }

    public void cacheResult(List<KaleoTask> kaleoTasks) {
        for (KaleoTask kaleoTask : kaleoTasks) {
            if (this.entityCache.getResult(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskImpl.class, (Serializable)Long.valueOf(kaleoTask.getPrimaryKey())) == null) {
                this.cacheResult(kaleoTask);
                continue;
            }
            kaleoTask.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(KaleoTaskImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(KaleoTask kaleoTask) {
        this.entityCache.removeResult(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskImpl.class, (Serializable)Long.valueOf(kaleoTask.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((KaleoTaskModelImpl)kaleoTask, true);
    }

    public void clearCache(List<KaleoTask> kaleoTasks) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (KaleoTask kaleoTask : kaleoTasks) {
            this.entityCache.removeResult(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskImpl.class, (Serializable)Long.valueOf(kaleoTask.getPrimaryKey()));
            this.clearUniqueFindersCache((KaleoTaskModelImpl)kaleoTask, true);
        }
    }

    protected void cacheUniqueFindersCache(KaleoTaskModelImpl kaleoTaskModelImpl) {
        Object[] args = new Object[]{kaleoTaskModelImpl.getKaleoNodeId()};
        this.finderCache.putResult(this._finderPathCountByKaleoNodeId, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByKaleoNodeId, args, (Object)kaleoTaskModelImpl, false);
    }

    protected void clearUniqueFindersCache(KaleoTaskModelImpl kaleoTaskModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{kaleoTaskModelImpl.getKaleoNodeId()};
            this.finderCache.removeResult(this._finderPathCountByKaleoNodeId, args);
            this.finderCache.removeResult(this._finderPathFetchByKaleoNodeId, args);
        }
        if ((kaleoTaskModelImpl.getColumnBitmask() & this._finderPathFetchByKaleoNodeId.getColumnBitmask()) != 0L) {
            args = new Object[]{kaleoTaskModelImpl.getOriginalKaleoNodeId()};
            this.finderCache.removeResult(this._finderPathCountByKaleoNodeId, args);
            this.finderCache.removeResult(this._finderPathFetchByKaleoNodeId, args);
        }
    }

    public KaleoTask create(long kaleoTaskId) {
        KaleoTaskImpl kaleoTask = new KaleoTaskImpl();
        kaleoTask.setNew(true);
        kaleoTask.setPrimaryKey(kaleoTaskId);
        kaleoTask.setCompanyId(this.companyProvider.getCompanyId());
        return kaleoTask;
    }

    public KaleoTask remove(long kaleoTaskId) throws NoSuchTaskException {
        return this.remove(Long.valueOf(kaleoTaskId));
    }

    public KaleoTask remove(Serializable primaryKey) throws NoSuchTaskException {
        Session session = null;
        try {
            session = this.openSession();
            KaleoTask kaleoTask = (KaleoTask)session.get(KaleoTaskImpl.class, primaryKey);
            if (kaleoTask == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchTaskException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            KaleoTask kaleoTask2 = (KaleoTask)this.remove((BaseModel)kaleoTask);
            return kaleoTask2;
        }
        catch (NoSuchTaskException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoTask removeImpl(KaleoTask kaleoTask) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)kaleoTask)) {
                kaleoTask = (KaleoTask)session.get(KaleoTaskImpl.class, kaleoTask.getPrimaryKeyObj());
            }
            if (kaleoTask != null) {
                session.delete((Object)kaleoTask);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (kaleoTask != null) {
            this.clearCache(kaleoTask);
        }
        return kaleoTask;
    }

    public KaleoTask updateImpl(KaleoTask kaleoTask) {
        boolean isNew = kaleoTask.isNew();
        if (!(kaleoTask instanceof KaleoTaskModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(kaleoTask.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)kaleoTask);
                throw new IllegalArgumentException("Implement ModelWrapper in kaleoTask proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom KaleoTask implementation " + kaleoTask.getClass());
        }
        KaleoTaskModelImpl kaleoTaskModelImpl = (KaleoTaskModelImpl)kaleoTask;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && kaleoTask.getCreateDate() == null) {
            if (serviceContext == null) {
                kaleoTask.setCreateDate(now);
            } else {
                kaleoTask.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!kaleoTaskModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                kaleoTask.setModifiedDate(now);
            } else {
                kaleoTask.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (kaleoTask.isNew()) {
                session.save((Object)kaleoTask);
                kaleoTask.setNew(false);
            } else {
                kaleoTask = (KaleoTask)session.merge((Object)kaleoTask);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!KaleoTaskModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{kaleoTaskModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{kaleoTaskModelImpl.getKaleoDefinitionVersionId()};
            this.finderCache.removeResult(this._finderPathCountByKaleoDefinitionVersionId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((kaleoTaskModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{kaleoTaskModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{kaleoTaskModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((kaleoTaskModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId.getColumnBitmask()) != 0L) {
                args = new Object[]{kaleoTaskModelImpl.getOriginalKaleoDefinitionVersionId()};
                this.finderCache.removeResult(this._finderPathCountByKaleoDefinitionVersionId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId, args);
                args = new Object[]{kaleoTaskModelImpl.getKaleoDefinitionVersionId()};
                this.finderCache.removeResult(this._finderPathCountByKaleoDefinitionVersionId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId, args);
            }
        }
        this.entityCache.putResult(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskImpl.class, (Serializable)Long.valueOf(kaleoTask.getPrimaryKey()), (Serializable)kaleoTask, false);
        this.clearUniqueFindersCache(kaleoTaskModelImpl, false);
        this.cacheUniqueFindersCache(kaleoTaskModelImpl);
        kaleoTask.resetOriginalValues();
        return kaleoTask;
    }

    public KaleoTask findByPrimaryKey(Serializable primaryKey) throws NoSuchTaskException {
        KaleoTask kaleoTask = (KaleoTask)this.fetchByPrimaryKey(primaryKey);
        if (kaleoTask == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchTaskException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return kaleoTask;
    }

    public KaleoTask findByPrimaryKey(long kaleoTaskId) throws NoSuchTaskException {
        return this.findByPrimaryKey(Long.valueOf(kaleoTaskId));
    }

    public KaleoTask fetchByPrimaryKey(long kaleoTaskId) {
        return (KaleoTask)this.fetchByPrimaryKey(Long.valueOf(kaleoTaskId));
    }

    public List<KaleoTask> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<KaleoTask> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<KaleoTask> findAll(int start, int end, OrderByComparator<KaleoTask> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<KaleoTask> findAll(int start, int end, OrderByComparator<KaleoTask> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_KALEOTASK);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_KALEOTASK;
                if (pagination) {
                    sql = sql.concat(" ORDER BY kaleoTask.kaleoTaskId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (KaleoTask kaleoTask : this.findAll()) {
            this.remove((BaseModel)kaleoTask);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_KALEOTASK);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "kaleoTaskId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_KALEOTASK;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return KaleoTaskModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, KaleoTaskImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, KaleoTaskImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, KaleoTaskImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, KaleoTaskImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByCompanyId = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByKaleoDefinitionVersionId = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, KaleoTaskImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByKaleoDefinitionVersionId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, KaleoTaskImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByKaleoDefinitionVersionId", new String[]{Long.class.getName()}, 2L);
        this._finderPathCountByKaleoDefinitionVersionId = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByKaleoDefinitionVersionId", new String[]{Long.class.getName()});
        this._finderPathFetchByKaleoNodeId = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, KaleoTaskImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByKaleoNodeId", new String[]{Long.class.getName()}, 4L);
        this._finderPathCountByKaleoNodeId = new FinderPath(KaleoTaskModelImpl.ENTITY_CACHE_ENABLED, KaleoTaskModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByKaleoNodeId", new String[]{Long.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(KaleoTaskImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

