/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.impl.KaleoTaskInstanceTokenModelImpl;
import com.liferay.portal.workflow.kaleo.runtime.util.RoleUtil;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTaskInstanceTokenFinder;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTaskInstanceTokenQuery;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTaskInstanceTokenUtil;
import com.liferay.portal.workflow.kaleo.service.persistence.impl.KaleoTaskInstanceTokenFinderBaseImpl;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class KaleoTaskInstanceTokenFinderImpl
extends KaleoTaskInstanceTokenFinderBaseImpl
implements KaleoTaskInstanceTokenFinder {
    public static final String COUNT_BY_C_KTAI = KaleoTaskInstanceTokenFinder.class.getName() + ".countByC_KTAI";
    public static final String FIND_BY_C_KTAI = KaleoTaskInstanceTokenFinder.class.getName() + ".findByC_KTAI";
    protected static final String FIRST_DUE_DATE_GT = "(KaleoTaskInstanceToken.dueDate >= ? [$AND_OR_NULL_CHECK$])";
    protected static final String FIRST_DUE_DATE_LT = "(KaleoTaskInstanceToken.dueDate <= ? [$AND_OR_NULL_CHECK$])";
    protected static final String NOT_FIRST_DUE_DATE_GT = "[$AND_OR_CONNECTOR$] (KaleoTaskInstanceToken.dueDate >= ? [$AND_OR_NULL_CHECK$])";
    protected static final String NOT_FIRST_DUE_DATE_LT = "[$AND_OR_CONNECTOR$] (KaleoTaskInstanceToken.dueDate <= ? [$AND_OR_NULL_CHECK$])";
    private static final String _ORDER_BY_ENTITY_ALIAS = "KaleoTaskInstanceToken.";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countKaleoTaskInstanceTokens(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            SQLQuery q = this.buildKaleoTaskInstanceTokenQuerySQL(kaleoTaskInstanceTokenQuery, true, session);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<KaleoTaskInstanceToken> findKaleoTaskInstanceTokens(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = this.buildKaleoTaskInstanceTokenQuerySQL(kaleoTaskInstanceTokenQuery, false, session);
            ArrayList<KaleoTaskInstanceToken> kaleoTaskInstanceTokens = new ArrayList<KaleoTaskInstanceToken>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)kaleoTaskInstanceTokenQuery.getStart(), (int)kaleoTaskInstanceTokenQuery.getEnd());
            while (itr.hasNext()) {
                long kaleoTaskInstanceTokenId = (Long)itr.next();
                KaleoTaskInstanceToken kaleoTaskInstanceToken = KaleoTaskInstanceTokenUtil.findByPrimaryKey((long)kaleoTaskInstanceTokenId);
                kaleoTaskInstanceTokens.add(kaleoTaskInstanceToken);
            }
            ArrayList<KaleoTaskInstanceToken> arrayList = kaleoTaskInstanceTokens;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected boolean appendSearchCriteria(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        if (ArrayUtil.isNotEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys())) {
            return true;
        }
        if (ArrayUtil.isNotEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetTypes())) {
            return true;
        }
        if (kaleoTaskInstanceTokenQuery.getDueDateGT() != null) {
            return true;
        }
        if (kaleoTaskInstanceTokenQuery.getDueDateLT() != null) {
            return true;
        }
        if (Validator.isNotNull((String)kaleoTaskInstanceTokenQuery.getTaskName())) {
            return true;
        }
        return Validator.isNotNull((String)kaleoTaskInstanceTokenQuery.getAssetTitle());
    }

    protected SQLQuery buildKaleoTaskInstanceTokenQuerySQL(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery, boolean count, Session session) throws Exception {
        OrderByComparator obc;
        String sql = null;
        sql = count ? this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_C_KTAI) : this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_C_KTAI);
        sql = this._customSQL.appendCriteria(sql, this.getAssigneeClassName(kaleoTaskInstanceTokenQuery));
        sql = this._customSQL.appendCriteria(sql, this.getAssigneeClassPK(kaleoTaskInstanceTokenQuery));
        sql = this._customSQL.appendCriteria(sql, this.getCompleted(kaleoTaskInstanceTokenQuery));
        sql = this._customSQL.appendCriteria(sql, this.getKaleoInstanceId(kaleoTaskInstanceTokenQuery));
        sql = this._customSQL.appendCriteria(sql, this.getRoleIds(kaleoTaskInstanceTokenQuery));
        sql = this._customSQL.appendCriteria(sql, this.getSearchByUserRoles(kaleoTaskInstanceTokenQuery));
        if (this.appendSearchCriteria(kaleoTaskInstanceTokenQuery)) {
            sql = this._customSQL.appendCriteria(sql, " AND (");
            if (ArrayUtil.isNotEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys()) || ArrayUtil.isNotEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetTypes())) {
                sql = this._customSQL.appendCriteria(sql, " (");
            }
            sql = this._customSQL.appendCriteria(sql, this.getAssetPrimaryKey(kaleoTaskInstanceTokenQuery));
            sql = this._customSQL.appendCriteria(sql, this.getAssetTypes(kaleoTaskInstanceTokenQuery, ArrayUtil.isEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys())));
            if (ArrayUtil.isNotEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys()) || ArrayUtil.isNotEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetTypes())) {
                sql = this._customSQL.appendCriteria(sql, ") ");
            }
            sql = this._customSQL.appendCriteria(sql, this.getDueDateGT(kaleoTaskInstanceTokenQuery, ArrayUtil.isEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys()) && ArrayUtil.isEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetTypes())));
            sql = this._customSQL.appendCriteria(sql, this.getDueDateLT(kaleoTaskInstanceTokenQuery, ArrayUtil.isEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys()) && ArrayUtil.isEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetTypes()) && kaleoTaskInstanceTokenQuery.getDueDateGT() == null));
            sql = this._customSQL.appendCriteria(sql, this.getTaskName(kaleoTaskInstanceTokenQuery, ArrayUtil.isEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys()) && ArrayUtil.isEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetTypes()) && kaleoTaskInstanceTokenQuery.getDueDateGT() == null && kaleoTaskInstanceTokenQuery.getDueDateLT() == null));
            sql = this._customSQL.appendCriteria(sql, this.getAssetTitle(kaleoTaskInstanceTokenQuery, ArrayUtil.isEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys()) && ArrayUtil.isEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetTypes()) && kaleoTaskInstanceTokenQuery.getDueDateGT() == null && kaleoTaskInstanceTokenQuery.getDueDateLT() == null && Validator.isNull((String)kaleoTaskInstanceTokenQuery.getTaskName())));
            sql = this._customSQL.appendCriteria(sql, ")");
            sql = this._customSQL.replaceAndOperator(sql, kaleoTaskInstanceTokenQuery.isAndOperator());
        }
        if ((obc = kaleoTaskInstanceTokenQuery.getOrderByComparator()) != null) {
            StringBundler sb = new StringBundler(sql);
            this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, obc);
            sql = sb.toString();
            String[] orderByFields = obc.getOrderByFields();
            sb = new StringBundler(orderByFields.length * 3 + 1);
            sb.append("DISTINCT KaleoTaskInstanceToken.kaleoTaskInstanceTokenId");
            for (String orderByField : orderByFields) {
                if (orderByField.equals("kaleoTaskInstanceTokenId")) continue;
                sb.append(", ");
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByField);
            }
            sql = sql.replace("DISTINCT KaleoTaskInstanceToken.kaleoTaskInstanceTokenId", sb.toString());
        }
        SQLQuery q = session.createSynchronizedSQLQuery(sql);
        if (count) {
            q.addScalar("COUNT_VALUE", Type.LONG);
        } else {
            q.addScalar("KaleoTaskInstanceTokenId", Type.LONG);
        }
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(kaleoTaskInstanceTokenQuery.getCompanyId());
        this.setAssigneeClassName(qPos, kaleoTaskInstanceTokenQuery);
        this.setAssigneeClassPK(qPos, kaleoTaskInstanceTokenQuery);
        this.setCompleted(qPos, kaleoTaskInstanceTokenQuery);
        this.setKaleoInstanceId(qPos, kaleoTaskInstanceTokenQuery);
        this.setAssetPrimaryKey(qPos, kaleoTaskInstanceTokenQuery);
        this.setAssetType(qPos, kaleoTaskInstanceTokenQuery);
        this.setDueDateGT(qPos, kaleoTaskInstanceTokenQuery);
        this.setDueDateLT(qPos, kaleoTaskInstanceTokenQuery);
        this.setTaskName(qPos, kaleoTaskInstanceTokenQuery);
        this.setAssetTitle(qPos, kaleoTaskInstanceTokenQuery);
        return q;
    }

    protected String getAssetPrimaryKey(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Object[] assetPrimaryKeys = kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys();
        if (ArrayUtil.isEmpty((Object[])assetPrimaryKeys)) {
            return "";
        }
        StringBundler sb = new StringBundler(assetPrimaryKeys.length + 1);
        sb.append("(");
        for (int i = 0; i < assetPrimaryKeys.length - 1; ++i) {
            sb.append("(KaleoTaskInstanceToken.classPK = ?) OR ");
        }
        sb.append("(KaleoTaskInstanceToken.classPK = ?))");
        return sb.toString();
    }

    protected String getAssetTitle(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery, boolean firstCriteria) {
        String assetTitle = kaleoTaskInstanceTokenQuery.getAssetTitle();
        if (Validator.isNull((String)assetTitle)) {
            return "";
        }
        Object[] assetTitles = this._customSQL.keywords(assetTitle, false);
        if (ArrayUtil.isEmpty((Object[])assetTitles)) {
            return "";
        }
        StringBundler sb = new StringBundler(assetTitles.length * 2 + 1);
        if (!firstCriteria) {
            sb.append("[$AND_OR_CONNECTOR$] (");
        } else {
            sb.append("(");
        }
        for (int i = 0; i < assetTitles.length; ++i) {
            sb.append("(LOWER(AssetEntry.title) LIKE LOWER(?)) ");
            sb.append("OR ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        return sb.toString();
    }

    protected String getAssetTypes(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery, boolean firstCriteria) {
        Object[] assetTypes = kaleoTaskInstanceTokenQuery.getAssetTypes();
        if (ArrayUtil.isEmpty((Object[])assetTypes)) {
            return "";
        }
        assetTypes = this._customSQL.keywords(kaleoTaskInstanceTokenQuery.getAssetTypes());
        if (ArrayUtil.isEmpty((Object[])assetTypes)) {
            return "";
        }
        StringBundler sb = new StringBundler(assetTypes.length + 1);
        if (!firstCriteria) {
            sb.append(" AND (");
        } else {
            sb.append("(");
        }
        for (int i = 0; i < assetTypes.length - 1; ++i) {
            sb.append("(LOWER(KaleoTaskInstanceToken.className) LIKE ?) OR ");
        }
        sb.append("(LOWER(KaleoTaskInstanceToken.className) LIKE ?))");
        return sb.toString();
    }

    protected String getAssigneeClassName(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        String assigneeClassName = kaleoTaskInstanceTokenQuery.getAssigneeClassName();
        if (Validator.isNull((String)assigneeClassName)) {
            return "";
        }
        return "AND (KaleoTaskAssignmentInstance.assigneeClassName = ?)";
    }

    protected String getAssigneeClassPK(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Long assigneeClassPK = kaleoTaskInstanceTokenQuery.getAssigneeClassPK();
        if (assigneeClassPK == null) {
            return "";
        }
        return "AND (KaleoTaskAssignmentInstance.assigneeClassPK = ?)";
    }

    protected String getCompleted(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Boolean completed = kaleoTaskInstanceTokenQuery.isCompleted();
        if (completed == null) {
            return "";
        }
        return "AND (KaleoTaskInstanceToken.completed = ?)";
    }

    protected String getDueDateGT(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery, boolean firstCriteria) {
        Date dueDateGT = kaleoTaskInstanceTokenQuery.getDueDateGT();
        if (dueDateGT == null) {
            return "";
        }
        if (firstCriteria) {
            return FIRST_DUE_DATE_GT;
        }
        return NOT_FIRST_DUE_DATE_GT;
    }

    protected String getDueDateLT(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery, boolean firstCriteria) {
        Date dueDateLT = kaleoTaskInstanceTokenQuery.getDueDateLT();
        if (dueDateLT == null) {
            return "";
        }
        if (firstCriteria) {
            return FIRST_DUE_DATE_LT;
        }
        return NOT_FIRST_DUE_DATE_LT;
    }

    protected String getKaleoInstanceId(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Long kaleoInstanceId = kaleoTaskInstanceTokenQuery.getKaleoInstanceId();
        if (kaleoInstanceId == null) {
            return "";
        }
        return "AND (KaleoTaskInstanceToken.kaleoInstanceId = ?)";
    }

    protected String getRoleIds(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Boolean searchByUserRoles = kaleoTaskInstanceTokenQuery.isSearchByUserRoles();
        if (searchByUserRoles != null) {
            return "";
        }
        List roleIds = kaleoTaskInstanceTokenQuery.getRoleIds();
        if (roleIds == null || roleIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(roleIds.size() * 2 + 1);
        sb.append("AND (KaleoTaskAssignmentInstance.assigneeClassPK IN (");
        Iterator itr = roleIds.iterator();
        while (itr.hasNext()) {
            sb.append(itr.next());
            if (!itr.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("))");
        return sb.toString();
    }

    protected List<Long> getSearchByUserRoleIds(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) throws Exception {
        List roleIds = RoleUtil.getRoleIds((ServiceContext)kaleoTaskInstanceTokenQuery.getServiceContext());
        User user = UserLocalServiceUtil.getUserById((long)kaleoTaskInstanceTokenQuery.getUserId());
        ArrayList groups = new ArrayList();
        groups.addAll(user.getGroups());
        groups.addAll(GroupLocalServiceUtil.getOrganizationsGroups((List)user.getOrganizations()));
        groups.addAll(GroupLocalServiceUtil.getOrganizationsRelatedGroups((List)user.getOrganizations()));
        groups.addAll(GroupLocalServiceUtil.getUserGroupsGroups((List)user.getUserGroups()));
        groups.addAll(GroupLocalServiceUtil.getUserGroupsRelatedGroups((List)user.getUserGroups()));
        for (Group group : groups) {
            List roles = RoleLocalServiceUtil.getGroupRoles((long)group.getGroupId());
            for (Role role : roles) {
                roleIds.add(role.getRoleId());
            }
        }
        return roleIds;
    }

    protected String getSearchByUserRoles(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) throws Exception {
        Boolean searchByUserRoles = kaleoTaskInstanceTokenQuery.isSearchByUserRoles();
        if (searchByUserRoles == null) {
            return "";
        }
        if (searchByUserRoles.booleanValue()) {
            List<Long> roleIds = this.getSearchByUserRoleIds(kaleoTaskInstanceTokenQuery);
            HashMap<Long, Set<Long>> roleIdGroupIdsMap = new HashMap<Long, Set<Long>>();
            List userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)kaleoTaskInstanceTokenQuery.getUserId());
            for (Object userGroupRole : userGroupRoles) {
                this.mapRoleIdGroupId(userGroupRole.getRoleId(), userGroupRole.getGroupId(), roleIdGroupIdsMap);
            }
            List<UserGroupGroupRole> userGroupGroupRoles = this.getUserGroupGroupRoles(kaleoTaskInstanceTokenQuery.getUserId());
            for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                this.mapRoleIdGroupId(userGroupGroupRole.getRoleId(), userGroupGroupRole.getGroupId(), roleIdGroupIdsMap);
            }
            if (roleIds.isEmpty() && roleIdGroupIdsMap.isEmpty()) {
                return "";
            }
            StringBundler sb = new StringBundler();
            sb.append("AND (");
            sb.append("KaleoTaskAssignmentInstance.assigneeClassName = '");
            sb.append(Role.class.getName());
            sb.append("' ");
            if (!roleIds.isEmpty()) {
                sb.append("AND (");
                sb.append("KaleoTaskAssignmentInstance.assigneeClassPK IN (");
                for (int i = 0; i < roleIds.size(); ++i) {
                    sb.append((Object)roleIds.get(i));
                    if (i >= roleIds.size() - 1) continue;
                    sb.append(", ");
                }
            }
            if (roleIdGroupIdsMap.isEmpty()) {
                sb.append(")))");
            } else {
                if (!roleIds.isEmpty()) {
                    sb.append(") OR ");
                } else {
                    sb.append("AND ");
                }
                for (Map.Entry entry : roleIdGroupIdsMap.entrySet()) {
                    sb.append("((KaleoTaskAssignmentInstance.assigneeClassPK = ");
                    sb.append(entry.getKey());
                    sb.append(") AND ");
                    sb.append("(KaleoTaskAssignmentInstance.groupId IN (");
                    Set groupIds = (Set)entry.getValue();
                    Iterator itr = groupIds.iterator();
                    while (itr.hasNext()) {
                        sb.append(itr.next());
                        if (!itr.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("))) ");
                    sb.append("OR ");
                }
                sb.setIndex(sb.index() - 1);
                if (!roleIds.isEmpty()) {
                    sb.append("))");
                } else {
                    sb.append(")");
                }
            }
            return sb.toString();
        }
        StringBundler sb = new StringBundler(6);
        sb.append("AND ((KaleoTaskAssignmentInstance.assigneeClassName = '");
        sb.append(User.class.getName());
        sb.append("') ");
        sb.append("AND (KaleoTaskAssignmentInstance.assigneeClassPK = ");
        sb.append(kaleoTaskInstanceTokenQuery.getUserId());
        sb.append("))");
        return sb.toString();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return KaleoTaskInstanceTokenModelImpl.TABLE_COLUMNS_MAP;
    }

    protected String getTaskName(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery, boolean firstCriteria) {
        String taskName = kaleoTaskInstanceTokenQuery.getTaskName();
        if (Validator.isNull((String)taskName)) {
            return "";
        }
        Object[] taskNames = this._customSQL.keywords(taskName, false);
        if (ArrayUtil.isEmpty((Object[])taskNames)) {
            return "";
        }
        StringBundler sb = new StringBundler(taskNames.length * 2 + 1);
        if (!firstCriteria) {
            sb.append("[$AND_OR_CONNECTOR$] (");
        } else {
            sb.append("(");
        }
        for (int i = 0; i < taskNames.length; ++i) {
            sb.append("(LOWER(KaleoTaskInstanceToken.kaleoTaskName) LIKE LOWER(?))");
            sb.append(" OR ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        return sb.toString();
    }

    protected List<UserGroupGroupRole> getUserGroupGroupRoles(long userId) throws Exception {
        ArrayList<UserGroupGroupRole> userGroupGroupRoles = new ArrayList<UserGroupGroupRole>();
        List userGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)userId);
        for (UserGroup userGroup : userGroups) {
            userGroupGroupRoles.addAll(UserGroupGroupRoleLocalServiceUtil.getUserGroupGroupRoles((long)userGroup.getUserGroupId()));
        }
        return userGroupGroupRoles;
    }

    protected void mapRoleIdGroupId(long roleId, long groupId, Map<Long, Set<Long>> roleIdGroupIdsMap) {
        Set<Long> groupIds = roleIdGroupIdsMap.get(roleId);
        if (groupIds == null) {
            groupIds = new TreeSet<Long>();
            roleIdGroupIdsMap.put(roleId, groupIds);
        }
        groupIds.add(groupId);
    }

    protected void setAssetPrimaryKey(QueryPos qPos, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Object[] assetPrimaryKeys = kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys();
        if (ArrayUtil.isEmpty((Object[])assetPrimaryKeys)) {
            return;
        }
        qPos.add((Long[])assetPrimaryKeys);
    }

    protected void setAssetTitle(QueryPos qPos, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        String assetTitle = kaleoTaskInstanceTokenQuery.getAssetTitle();
        if (Validator.isNull((String)assetTitle)) {
            return;
        }
        String[] assetTitles = this._customSQL.keywords(assetTitle, false);
        qPos.add(assetTitles);
    }

    protected void setAssetType(QueryPos qPos, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Object[] assetTypes = kaleoTaskInstanceTokenQuery.getAssetTypes();
        if (ArrayUtil.isEmpty((Object[])assetTypes)) {
            return;
        }
        assetTypes = this._customSQL.keywords((String[])assetTypes, false);
        qPos.add((String[])assetTypes);
    }

    protected void setAssigneeClassName(QueryPos qPos, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        String assigneeClassName = kaleoTaskInstanceTokenQuery.getAssigneeClassName();
        if (Validator.isNull((String)assigneeClassName)) {
            return;
        }
        qPos.add(assigneeClassName);
    }

    protected void setAssigneeClassPK(QueryPos qPos, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Long assigneeClassPK = kaleoTaskInstanceTokenQuery.getAssigneeClassPK();
        if (assigneeClassPK == null) {
            return;
        }
        qPos.add(assigneeClassPK);
    }

    protected void setCompleted(QueryPos qPos, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Boolean completed = kaleoTaskInstanceTokenQuery.isCompleted();
        if (completed == null) {
            return;
        }
        qPos.add(completed);
    }

    protected void setDueDateGT(QueryPos qPos, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Date dueDateGT = kaleoTaskInstanceTokenQuery.getDueDateGT();
        if (dueDateGT == null) {
            return;
        }
        Timestamp dueDateGT_TS = CalendarUtil.getTimestamp((Date)dueDateGT);
        qPos.add(dueDateGT_TS);
    }

    protected void setDueDateLT(QueryPos qPos, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Date dueDateLT = kaleoTaskInstanceTokenQuery.getDueDateLT();
        if (dueDateLT == null) {
            return;
        }
        Timestamp dueDateLT_TS = CalendarUtil.getTimestamp((Date)dueDateLT);
        qPos.add(dueDateLT_TS);
    }

    protected void setKaleoInstanceId(QueryPos qPos, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Long kaleoInstanceId = kaleoTaskInstanceTokenQuery.getKaleoInstanceId();
        if (kaleoInstanceId == null) {
            return;
        }
        qPos.add(kaleoInstanceId);
    }

    protected void setTaskName(QueryPos qPos, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        String taskName = kaleoTaskInstanceTokenQuery.getTaskName();
        if (Validator.isNull((String)taskName)) {
            return;
        }
        String[] taskNames = this._customSQL.keywords(taskName, false);
        qPos.add(taskNames);
    }
}

