/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.persistence.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.workflow.kaleo.exception.NoSuchNodeException;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.impl.KaleoNodeImpl;
import com.liferay.portal.workflow.kaleo.model.impl.KaleoNodeModelImpl;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoNodePersistence;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class KaleoNodePersistenceImpl
extends BasePersistenceImpl<KaleoNode>
implements KaleoNodePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = KaleoNodeImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "kaleoNode.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByKaleoDefinitionVersionId;
    private FinderPath _finderPathWithoutPaginationFindByKaleoDefinitionVersionId;
    private FinderPath _finderPathCountByKaleoDefinitionVersionId;
    private static final String _FINDER_COLUMN_KALEODEFINITIONVERSIONID_KALEODEFINITIONVERSIONID_2 = "kaleoNode.kaleoDefinitionVersionId = ?";
    private FinderPath _finderPathWithPaginationFindByC_KDVI;
    private FinderPath _finderPathWithoutPaginationFindByC_KDVI;
    private FinderPath _finderPathCountByC_KDVI;
    private static final String _FINDER_COLUMN_C_KDVI_COMPANYID_2 = "kaleoNode.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_KDVI_KALEODEFINITIONVERSIONID_2 = "kaleoNode.kaleoDefinitionVersionId = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_KALEONODE = "SELECT kaleoNode FROM KaleoNode kaleoNode";
    private static final String _SQL_SELECT_KALEONODE_WHERE = "SELECT kaleoNode FROM KaleoNode kaleoNode WHERE ";
    private static final String _SQL_COUNT_KALEONODE = "SELECT COUNT(kaleoNode) FROM KaleoNode kaleoNode";
    private static final String _SQL_COUNT_KALEONODE_WHERE = "SELECT COUNT(kaleoNode) FROM KaleoNode kaleoNode WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "kaleoNode.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No KaleoNode exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No KaleoNode exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(KaleoNodePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"type", "initial"});

    public List<KaleoNode> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<KaleoNode> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<KaleoNode> findByCompanyId(long companyId, int start, int end, OrderByComparator<KaleoNode> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<KaleoNode> findByCompanyId(long companyId, int start, int end, OrderByComparator<KaleoNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<KaleoNode> list = null;
        if (retrieveFromCache && (list = (List<KaleoNode>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (KaleoNode kaleoNode : list) {
                if (companyId == kaleoNode.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_KALEONODE_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY kaleoNode.kaleoNodeId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KaleoNode findByCompanyId_First(long companyId, OrderByComparator<KaleoNode> orderByComparator) throws NoSuchNodeException {
        KaleoNode kaleoNode = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (kaleoNode != null) {
            return kaleoNode;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public KaleoNode fetchByCompanyId_First(long companyId, OrderByComparator<KaleoNode> orderByComparator) {
        List<KaleoNode> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoNode findByCompanyId_Last(long companyId, OrderByComparator<KaleoNode> orderByComparator) throws NoSuchNodeException {
        KaleoNode kaleoNode = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (kaleoNode != null) {
            return kaleoNode;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public KaleoNode fetchByCompanyId_Last(long companyId, OrderByComparator<KaleoNode> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<KaleoNode> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoNode[] findByCompanyId_PrevAndNext(long kaleoNodeId, long companyId, OrderByComparator<KaleoNode> orderByComparator) throws NoSuchNodeException {
        KaleoNode kaleoNode = this.findByPrimaryKey(kaleoNodeId);
        Session session = null;
        try {
            session = this.openSession();
            KaleoNode[] array = new KaleoNodeImpl[]{this.getByCompanyId_PrevAndNext(session, kaleoNode, companyId, orderByComparator, true), kaleoNode, this.getByCompanyId_PrevAndNext(session, kaleoNode, companyId, orderByComparator, false)};
            KaleoNode[] kaleoNodeArray = array;
            return kaleoNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoNode getByCompanyId_PrevAndNext(Session session, KaleoNode kaleoNode, long companyId, OrderByComparator<KaleoNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_KALEONODE_WHERE);
        query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY kaleoNode.kaleoNodeId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kaleoNode)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (KaleoNode)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (KaleoNode kaleoNode : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)kaleoNode);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_KALEONODE_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<KaleoNode> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId) {
        return this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, -1, -1, null);
    }

    public List<KaleoNode> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId, int start, int end) {
        return this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, start, end, null);
    }

    public List<KaleoNode> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId, int start, int end, OrderByComparator<KaleoNode> orderByComparator) {
        return this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, start, end, orderByComparator, true);
    }

    public List<KaleoNode> findByKaleoDefinitionVersionId(long kaleoDefinitionVersionId, int start, int end, OrderByComparator<KaleoNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId;
            finderArgs = new Object[]{kaleoDefinitionVersionId};
        } else {
            finderPath = this._finderPathWithPaginationFindByKaleoDefinitionVersionId;
            finderArgs = new Object[]{kaleoDefinitionVersionId, start, end, orderByComparator};
        }
        List<KaleoNode> list = null;
        if (retrieveFromCache && (list = (List<KaleoNode>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (KaleoNode kaleoNode : list) {
                if (kaleoDefinitionVersionId == kaleoNode.getKaleoDefinitionVersionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_KALEONODE_WHERE);
            query.append("kaleoNode.kaleoDefinitionVersionId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY kaleoNode.kaleoNodeId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoDefinitionVersionId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KaleoNode findByKaleoDefinitionVersionId_First(long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator) throws NoSuchNodeException {
        KaleoNode kaleoNode = this.fetchByKaleoDefinitionVersionId_First(kaleoDefinitionVersionId, orderByComparator);
        if (kaleoNode != null) {
            return kaleoNode;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("kaleoDefinitionVersionId=");
        msg.append(kaleoDefinitionVersionId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public KaleoNode fetchByKaleoDefinitionVersionId_First(long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator) {
        List<KaleoNode> list = this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoNode findByKaleoDefinitionVersionId_Last(long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator) throws NoSuchNodeException {
        KaleoNode kaleoNode = this.fetchByKaleoDefinitionVersionId_Last(kaleoDefinitionVersionId, orderByComparator);
        if (kaleoNode != null) {
            return kaleoNode;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("kaleoDefinitionVersionId=");
        msg.append(kaleoDefinitionVersionId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public KaleoNode fetchByKaleoDefinitionVersionId_Last(long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator) {
        int count = this.countByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        if (count == 0) {
            return null;
        }
        List<KaleoNode> list = this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoNode[] findByKaleoDefinitionVersionId_PrevAndNext(long kaleoNodeId, long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator) throws NoSuchNodeException {
        KaleoNode kaleoNode = this.findByPrimaryKey(kaleoNodeId);
        Session session = null;
        try {
            session = this.openSession();
            KaleoNode[] array = new KaleoNodeImpl[]{this.getByKaleoDefinitionVersionId_PrevAndNext(session, kaleoNode, kaleoDefinitionVersionId, orderByComparator, true), kaleoNode, this.getByKaleoDefinitionVersionId_PrevAndNext(session, kaleoNode, kaleoDefinitionVersionId, orderByComparator, false)};
            KaleoNode[] kaleoNodeArray = array;
            return kaleoNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoNode getByKaleoDefinitionVersionId_PrevAndNext(Session session, KaleoNode kaleoNode, long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_KALEONODE_WHERE);
        query.append("kaleoNode.kaleoDefinitionVersionId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY kaleoNode.kaleoNodeId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(kaleoDefinitionVersionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kaleoNode)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (KaleoNode)list.get(1);
        }
        return null;
    }

    public void removeByKaleoDefinitionVersionId(long kaleoDefinitionVersionId) {
        for (KaleoNode kaleoNode : this.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId, -1, -1, null)) {
            this.remove((BaseModel)kaleoNode);
        }
    }

    public int countByKaleoDefinitionVersionId(long kaleoDefinitionVersionId) {
        FinderPath finderPath = this._finderPathCountByKaleoDefinitionVersionId;
        Object[] finderArgs = new Object[]{kaleoDefinitionVersionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_KALEONODE_WHERE);
            query.append("kaleoNode.kaleoDefinitionVersionId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(kaleoDefinitionVersionId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<KaleoNode> findByC_KDVI(long companyId, long kaleoDefinitionVersionId) {
        return this.findByC_KDVI(companyId, kaleoDefinitionVersionId, -1, -1, null);
    }

    public List<KaleoNode> findByC_KDVI(long companyId, long kaleoDefinitionVersionId, int start, int end) {
        return this.findByC_KDVI(companyId, kaleoDefinitionVersionId, start, end, null);
    }

    public List<KaleoNode> findByC_KDVI(long companyId, long kaleoDefinitionVersionId, int start, int end, OrderByComparator<KaleoNode> orderByComparator) {
        return this.findByC_KDVI(companyId, kaleoDefinitionVersionId, start, end, orderByComparator, true);
    }

    public List<KaleoNode> findByC_KDVI(long companyId, long kaleoDefinitionVersionId, int start, int end, OrderByComparator<KaleoNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByC_KDVI;
            finderArgs = new Object[]{companyId, kaleoDefinitionVersionId};
        } else {
            finderPath = this._finderPathWithPaginationFindByC_KDVI;
            finderArgs = new Object[]{companyId, kaleoDefinitionVersionId, start, end, orderByComparator};
        }
        List<KaleoNode> list = null;
        if (retrieveFromCache && (list = (List<KaleoNode>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (KaleoNode kaleoNode : list) {
                if (companyId == kaleoNode.getCompanyId() && kaleoDefinitionVersionId == kaleoNode.getKaleoDefinitionVersionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_KALEONODE_WHERE);
            query.append(_FINDER_COLUMN_C_KDVI_COMPANYID_2);
            query.append("kaleoNode.kaleoDefinitionVersionId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY kaleoNode.kaleoNodeId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(kaleoDefinitionVersionId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public KaleoNode findByC_KDVI_First(long companyId, long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator) throws NoSuchNodeException {
        KaleoNode kaleoNode = this.fetchByC_KDVI_First(companyId, kaleoDefinitionVersionId, orderByComparator);
        if (kaleoNode != null) {
            return kaleoNode;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", kaleoDefinitionVersionId=");
        msg.append(kaleoDefinitionVersionId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public KaleoNode fetchByC_KDVI_First(long companyId, long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator) {
        List<KaleoNode> list = this.findByC_KDVI(companyId, kaleoDefinitionVersionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoNode findByC_KDVI_Last(long companyId, long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator) throws NoSuchNodeException {
        KaleoNode kaleoNode = this.fetchByC_KDVI_Last(companyId, kaleoDefinitionVersionId, orderByComparator);
        if (kaleoNode != null) {
            return kaleoNode;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", kaleoDefinitionVersionId=");
        msg.append(kaleoDefinitionVersionId);
        msg.append("}");
        throw new NoSuchNodeException(msg.toString());
    }

    public KaleoNode fetchByC_KDVI_Last(long companyId, long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator) {
        int count = this.countByC_KDVI(companyId, kaleoDefinitionVersionId);
        if (count == 0) {
            return null;
        }
        List<KaleoNode> list = this.findByC_KDVI(companyId, kaleoDefinitionVersionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public KaleoNode[] findByC_KDVI_PrevAndNext(long kaleoNodeId, long companyId, long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator) throws NoSuchNodeException {
        KaleoNode kaleoNode = this.findByPrimaryKey(kaleoNodeId);
        Session session = null;
        try {
            session = this.openSession();
            KaleoNode[] array = new KaleoNodeImpl[]{this.getByC_KDVI_PrevAndNext(session, kaleoNode, companyId, kaleoDefinitionVersionId, orderByComparator, true), kaleoNode, this.getByC_KDVI_PrevAndNext(session, kaleoNode, companyId, kaleoDefinitionVersionId, orderByComparator, false)};
            KaleoNode[] kaleoNodeArray = array;
            return kaleoNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoNode getByC_KDVI_PrevAndNext(Session session, KaleoNode kaleoNode, long companyId, long kaleoDefinitionVersionId, OrderByComparator<KaleoNode> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_KALEONODE_WHERE);
        query.append(_FINDER_COLUMN_C_KDVI_COMPANYID_2);
        query.append("kaleoNode.kaleoDefinitionVersionId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY kaleoNode.kaleoNodeId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        qPos.add(kaleoDefinitionVersionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)kaleoNode)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (KaleoNode)list.get(1);
        }
        return null;
    }

    public void removeByC_KDVI(long companyId, long kaleoDefinitionVersionId) {
        for (KaleoNode kaleoNode : this.findByC_KDVI(companyId, kaleoDefinitionVersionId, -1, -1, null)) {
            this.remove((BaseModel)kaleoNode);
        }
    }

    public int countByC_KDVI(long companyId, long kaleoDefinitionVersionId) {
        FinderPath finderPath = this._finderPathCountByC_KDVI;
        Object[] finderArgs = new Object[]{companyId, kaleoDefinitionVersionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_KALEONODE_WHERE);
            query.append(_FINDER_COLUMN_C_KDVI_COMPANYID_2);
            query.append("kaleoNode.kaleoDefinitionVersionId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(kaleoDefinitionVersionId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public KaleoNodePersistenceImpl() {
        this.setModelClass(KaleoNode.class);
        this.setModelImplClass(KaleoNodeImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("type", "type_");
        dbColumnNames.put("initial", "initial_");
        this.setDBColumnNames(dbColumnNames);
    }

    public void cacheResult(KaleoNode kaleoNode) {
        this.entityCache.putResult(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeImpl.class, (Serializable)Long.valueOf(kaleoNode.getPrimaryKey()), (Serializable)kaleoNode);
        kaleoNode.resetOriginalValues();
    }

    public void cacheResult(List<KaleoNode> kaleoNodes) {
        for (KaleoNode kaleoNode : kaleoNodes) {
            if (this.entityCache.getResult(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeImpl.class, (Serializable)Long.valueOf(kaleoNode.getPrimaryKey())) == null) {
                this.cacheResult(kaleoNode);
                continue;
            }
            kaleoNode.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(KaleoNodeImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(KaleoNode kaleoNode) {
        this.entityCache.removeResult(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeImpl.class, (Serializable)Long.valueOf(kaleoNode.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<KaleoNode> kaleoNodes) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (KaleoNode kaleoNode : kaleoNodes) {
            this.entityCache.removeResult(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeImpl.class, (Serializable)Long.valueOf(kaleoNode.getPrimaryKey()));
        }
    }

    public KaleoNode create(long kaleoNodeId) {
        KaleoNodeImpl kaleoNode = new KaleoNodeImpl();
        kaleoNode.setNew(true);
        kaleoNode.setPrimaryKey(kaleoNodeId);
        kaleoNode.setCompanyId(this.companyProvider.getCompanyId());
        return kaleoNode;
    }

    public KaleoNode remove(long kaleoNodeId) throws NoSuchNodeException {
        return this.remove(Long.valueOf(kaleoNodeId));
    }

    public KaleoNode remove(Serializable primaryKey) throws NoSuchNodeException {
        Session session = null;
        try {
            session = this.openSession();
            KaleoNode kaleoNode = (KaleoNode)session.get(KaleoNodeImpl.class, primaryKey);
            if (kaleoNode == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchNodeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            KaleoNode kaleoNode2 = (KaleoNode)this.remove((BaseModel)kaleoNode);
            return kaleoNode2;
        }
        catch (NoSuchNodeException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected KaleoNode removeImpl(KaleoNode kaleoNode) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)kaleoNode)) {
                kaleoNode = (KaleoNode)session.get(KaleoNodeImpl.class, kaleoNode.getPrimaryKeyObj());
            }
            if (kaleoNode != null) {
                session.delete((Object)kaleoNode);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (kaleoNode != null) {
            this.clearCache(kaleoNode);
        }
        return kaleoNode;
    }

    public KaleoNode updateImpl(KaleoNode kaleoNode) {
        boolean isNew = kaleoNode.isNew();
        if (!(kaleoNode instanceof KaleoNodeModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(kaleoNode.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)kaleoNode);
                throw new IllegalArgumentException("Implement ModelWrapper in kaleoNode proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom KaleoNode implementation " + kaleoNode.getClass());
        }
        KaleoNodeModelImpl kaleoNodeModelImpl = (KaleoNodeModelImpl)kaleoNode;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && kaleoNode.getCreateDate() == null) {
            if (serviceContext == null) {
                kaleoNode.setCreateDate(now);
            } else {
                kaleoNode.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!kaleoNodeModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                kaleoNode.setModifiedDate(now);
            } else {
                kaleoNode.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (kaleoNode.isNew()) {
                session.save((Object)kaleoNode);
                kaleoNode.setNew(false);
            } else {
                kaleoNode = (KaleoNode)session.merge((Object)kaleoNode);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!KaleoNodeModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{kaleoNodeModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{kaleoNodeModelImpl.getKaleoDefinitionVersionId()};
            this.finderCache.removeResult(this._finderPathCountByKaleoDefinitionVersionId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId, args);
            args = new Object[]{kaleoNodeModelImpl.getCompanyId(), kaleoNodeModelImpl.getKaleoDefinitionVersionId()};
            this.finderCache.removeResult(this._finderPathCountByC_KDVI, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_KDVI, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((kaleoNodeModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{kaleoNodeModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{kaleoNodeModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((kaleoNodeModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId.getColumnBitmask()) != 0L) {
                args = new Object[]{kaleoNodeModelImpl.getOriginalKaleoDefinitionVersionId()};
                this.finderCache.removeResult(this._finderPathCountByKaleoDefinitionVersionId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId, args);
                args = new Object[]{kaleoNodeModelImpl.getKaleoDefinitionVersionId()};
                this.finderCache.removeResult(this._finderPathCountByKaleoDefinitionVersionId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId, args);
            }
            if ((kaleoNodeModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_KDVI.getColumnBitmask()) != 0L) {
                args = new Object[]{kaleoNodeModelImpl.getOriginalCompanyId(), kaleoNodeModelImpl.getOriginalKaleoDefinitionVersionId()};
                this.finderCache.removeResult(this._finderPathCountByC_KDVI, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_KDVI, args);
                args = new Object[]{kaleoNodeModelImpl.getCompanyId(), kaleoNodeModelImpl.getKaleoDefinitionVersionId()};
                this.finderCache.removeResult(this._finderPathCountByC_KDVI, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_KDVI, args);
            }
        }
        this.entityCache.putResult(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeImpl.class, (Serializable)Long.valueOf(kaleoNode.getPrimaryKey()), (Serializable)kaleoNode, false);
        kaleoNode.resetOriginalValues();
        return kaleoNode;
    }

    public KaleoNode findByPrimaryKey(Serializable primaryKey) throws NoSuchNodeException {
        KaleoNode kaleoNode = (KaleoNode)this.fetchByPrimaryKey(primaryKey);
        if (kaleoNode == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchNodeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return kaleoNode;
    }

    public KaleoNode findByPrimaryKey(long kaleoNodeId) throws NoSuchNodeException {
        return this.findByPrimaryKey(Long.valueOf(kaleoNodeId));
    }

    public KaleoNode fetchByPrimaryKey(long kaleoNodeId) {
        return (KaleoNode)this.fetchByPrimaryKey(Long.valueOf(kaleoNodeId));
    }

    public List<KaleoNode> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<KaleoNode> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<KaleoNode> findAll(int start, int end, OrderByComparator<KaleoNode> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<KaleoNode> findAll(int start, int end, OrderByComparator<KaleoNode> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_KALEONODE);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_KALEONODE;
                if (pagination) {
                    sql = sql.concat(" ORDER BY kaleoNode.kaleoNodeId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (KaleoNode kaleoNode : this.findAll()) {
            this.remove((BaseModel)kaleoNode);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_KALEONODE);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "kaleoNodeId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_KALEONODE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return KaleoNodeModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, KaleoNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, KaleoNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, KaleoNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, KaleoNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByCompanyId = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByKaleoDefinitionVersionId = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, KaleoNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByKaleoDefinitionVersionId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByKaleoDefinitionVersionId = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, KaleoNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByKaleoDefinitionVersionId", new String[]{Long.class.getName()}, 2L);
        this._finderPathCountByKaleoDefinitionVersionId = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByKaleoDefinitionVersionId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByC_KDVI = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, KaleoNodeImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_KDVI", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_KDVI = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, KaleoNodeImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_KDVI", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
        this._finderPathCountByC_KDVI = new FinderPath(KaleoNodeModelImpl.ENTITY_CACHE_ENABLED, KaleoNodeModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_KDVI", new String[]{Long.class.getName(), Long.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(KaleoNodeImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

