/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.Action;
import com.liferay.portal.workflow.kaleo.definition.Assignment;
import com.liferay.portal.workflow.kaleo.definition.DelayDuration;
import com.liferay.portal.workflow.kaleo.definition.DurationScale;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.model.KaleoTimer;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTimerLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class KaleoTimerLocalServiceImpl
extends KaleoTimerLocalServiceBaseImpl {
    public KaleoTimer addKaleoTimer(String kaleoClassName, long kaleoClassPK, long kaleoDefinitionVersionId, Timer timer, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoTimerId = this.counterLocalService.increment();
        KaleoTimer kaleoTimer = this.kaleoTimerPersistence.create(kaleoTimerId);
        kaleoTimer.setCompanyId(user.getCompanyId());
        kaleoTimer.setUserId(user.getUserId());
        kaleoTimer.setUserName(user.getFullName());
        kaleoTimer.setCreateDate(now);
        kaleoTimer.setModifiedDate(now);
        kaleoTimer.setKaleoClassName(kaleoClassName);
        kaleoTimer.setKaleoClassPK(kaleoClassPK);
        kaleoTimer.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoTimer.setName(timer.getName());
        kaleoTimer.setBlocking(timer.isBlocking());
        DelayDuration delayDuration = timer.getDelayDuration();
        kaleoTimer.setDuration(delayDuration.getDuration());
        DurationScale durationScale = delayDuration.getDurationScale();
        kaleoTimer.setScale(durationScale.getValue());
        DelayDuration recurrenceDelayDuration = timer.getRecurrence();
        if (recurrenceDelayDuration != null) {
            kaleoTimer.setRecurrenceDuration(recurrenceDelayDuration.getDuration());
            durationScale = recurrenceDelayDuration.getDurationScale();
            kaleoTimer.setRecurrenceScale(durationScale.getValue());
        }
        this.kaleoTimerPersistence.update((BaseModel)kaleoTimer);
        Set actions = timer.getActions();
        for (Object action : actions) {
            this.kaleoActionLocalService.addKaleoAction(KaleoTimer.class.getName(), kaleoTimerId, kaleoDefinitionVersionId, timer.getName(), (Action)action, serviceContext);
        }
        Set reassignments = timer.getReassignments();
        for (Assignment reassignment : reassignments) {
            this.kaleoTaskAssignmentLocalService.addKaleoTaskAssignment(KaleoTimer.class.getName(), kaleoTimerId, kaleoDefinitionVersionId, reassignment, serviceContext);
        }
        Set notifications = timer.getNotifications();
        for (Notification notification : notifications) {
            this.kaleoNotificationLocalService.addKaleoNotification(KaleoTimer.class.getName(), kaleoTimerId, kaleoDefinitionVersionId, timer.getName(), notification, serviceContext);
        }
        return kaleoTimer;
    }

    public List<KaleoTimer> getKaleoTimers(String kaleoClassName, long kaleoClassPK) {
        return this.kaleoTimerPersistence.findByKCN_KCPK(kaleoClassName, kaleoClassPK);
    }

    public List<KaleoTimer> getKaleoTimers(String kaleoClassName, long kaleoClassPK, boolean blocking) {
        return this.kaleoTimerPersistence.findByKCN_KCPK_Blocking(kaleoClassName, kaleoClassPK, blocking);
    }
}

