/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.workflow.kaleo.definition.DelayDuration;
import com.liferay.portal.workflow.kaleo.definition.DurationScale;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTimer;
import com.liferay.portal.workflow.kaleo.model.KaleoTimerInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.calendar.DueDateCalculator;
import com.liferay.portal.workflow.kaleo.runtime.util.SchedulerUtil;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTimerInstanceTokenLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class KaleoTimerInstanceTokenLocalServiceImpl
extends KaleoTimerInstanceTokenLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(KaleoTimerInstanceTokenLocalServiceImpl.class);
    @ServiceReference(type=DueDateCalculator.class)
    private DueDateCalculator _dueDateCalculator;
    @ServiceReference(type=SchedulerEngineHelper.class)
    private SchedulerEngineHelper _schedulerEngineHelper;
    @ServiceReference(type=TriggerFactory.class)
    private TriggerFactory _triggerFactory;

    public KaleoTimerInstanceToken addKaleoTimerInstanceToken(long kaleoInstanceTokenId, long kaleoTaskInstanceTokenId, long kaleoTimerId, String kaleoTimerName, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.findByPrimaryKey(kaleoInstanceTokenId);
        KaleoTimer kaleoTimer = this.kaleoTimerPersistence.findByPrimaryKey(kaleoTimerId);
        Date now = new Date();
        long kaleoTimerInstanceTokenId = this.counterLocalService.increment();
        KaleoTimerInstanceToken kaleoTimerInstanceToken = this.kaleoTimerInstanceTokenPersistence.create(kaleoTimerInstanceTokenId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoTimerInstanceToken.setGroupId(groupId);
        kaleoTimerInstanceToken.setCompanyId(user.getCompanyId());
        kaleoTimerInstanceToken.setUserId(user.getUserId());
        kaleoTimerInstanceToken.setUserName(user.getFullName());
        kaleoTimerInstanceToken.setCreateDate(now);
        kaleoTimerInstanceToken.setModifiedDate(now);
        kaleoTimerInstanceToken.setKaleoClassName(kaleoTimer.getKaleoClassName());
        kaleoTimerInstanceToken.setKaleoClassPK(kaleoTimer.getKaleoClassPK());
        kaleoTimerInstanceToken.setKaleoDefinitionVersionId(kaleoInstanceToken.getKaleoDefinitionVersionId());
        kaleoTimerInstanceToken.setKaleoInstanceId(kaleoInstanceToken.getKaleoInstanceId());
        kaleoTimerInstanceToken.setKaleoInstanceTokenId(kaleoInstanceTokenId);
        kaleoTimerInstanceToken.setKaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId);
        kaleoTimerInstanceToken.setKaleoTimerId(kaleoTimerId);
        kaleoTimerInstanceToken.setKaleoTimerName(kaleoTimerName);
        kaleoTimerInstanceToken.setBlocking(kaleoTimer.isBlocking());
        kaleoTimerInstanceToken.setCompleted(false);
        kaleoTimerInstanceToken.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoTimerInstanceTokenPersistence.update((BaseModel)kaleoTimerInstanceToken);
        this.scheduleTimer(kaleoTimerInstanceToken, kaleoTimer);
        return kaleoTimerInstanceToken;
    }

    public List<KaleoTimerInstanceToken> addKaleoTimerInstanceTokens(KaleoInstanceToken kaleoInstanceToken, KaleoTaskInstanceToken kaleoTaskInstanceToken, Collection<KaleoTimer> kaleoTimers, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        if (kaleoTimers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KaleoTimerInstanceToken> kaleoTimerInstanceTokens = new ArrayList<KaleoTimerInstanceToken>(kaleoTimers.size());
        long kaleoTaskInstanceTokenId = 0L;
        if (kaleoTaskInstanceToken != null) {
            kaleoTaskInstanceTokenId = kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId();
        }
        for (KaleoTimer kaleoTimer : kaleoTimers) {
            KaleoTimerInstanceToken kaleoTimerInstanceToken = this.addKaleoTimerInstanceToken(kaleoInstanceToken.getKaleoInstanceTokenId(), kaleoTaskInstanceTokenId, kaleoTimer.getKaleoTimerId(), kaleoTimer.getName(), workflowContext, serviceContext);
            kaleoTimerInstanceTokens.add(kaleoTimerInstanceToken);
        }
        return kaleoTimerInstanceTokens;
    }

    public KaleoTimerInstanceToken completeKaleoTimerInstanceToken(long kaleoTimerInstanceTokenId, ServiceContext serviceContext) throws PortalException {
        KaleoTimerInstanceToken kaleoTimerInstanceToken = this.kaleoTimerInstanceTokenPersistence.findByPrimaryKey(kaleoTimerInstanceTokenId);
        kaleoTimerInstanceToken.setCompletionUserId(serviceContext.getUserId());
        kaleoTimerInstanceToken.setCompleted(true);
        kaleoTimerInstanceToken.setCompletionDate(new Date());
        this.kaleoTimerInstanceTokenPersistence.update((BaseModel)kaleoTimerInstanceToken);
        this.deleteScheduledTimer(kaleoTimerInstanceToken);
        return kaleoTimerInstanceToken;
    }

    public void completeKaleoTimerInstanceTokens(List<KaleoTimerInstanceToken> kaleoTimerInstanceTokens, ServiceContext serviceContext) throws PortalException {
        for (KaleoTimerInstanceToken kaleoTimerInstanceToken : kaleoTimerInstanceTokens) {
            this.completeKaleoTimerInstanceToken(kaleoTimerInstanceToken.getKaleoTimerInstanceTokenId(), serviceContext);
        }
    }

    public void completeKaleoTimerInstanceTokens(long kaleoInstanceTokenId, ServiceContext serviceContext) throws PortalException {
        List kaleoTimerInstanceTokens = this.kaleoTimerInstanceTokenPersistence.findByKITI_C(kaleoInstanceTokenId, false);
        this.completeKaleoTimerInstanceTokens(kaleoTimerInstanceTokens, serviceContext);
    }

    public void deleteKaleoTimerInstanceToken(long kaleoInstanceTokenId, long kaleoTimerId) throws PortalException {
        KaleoTimerInstanceToken kaleoTimerInstanceToken = this.getKaleoTimerInstanceToken(kaleoInstanceTokenId, kaleoTimerId);
        this.deleteScheduledTimer(kaleoTimerInstanceToken);
        this.kaleoTimerInstanceTokenPersistence.remove((BaseModel)kaleoTimerInstanceToken);
    }

    public void deleteKaleoTimerInstanceTokens(long kaleoInstanceId) {
        List kaleoTimerInstanceTokens = this.kaleoTimerInstanceTokenPersistence.findByKaleoInstanceId(kaleoInstanceId);
        for (KaleoTimerInstanceToken kaleoTimerInstanceToken : kaleoTimerInstanceTokens) {
            block3: {
                if (kaleoTimerInstanceToken.isCompleted()) continue;
                try {
                    this.deleteScheduledTimer(kaleoTimerInstanceToken);
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to unschedule " + kaleoTimerInstanceToken), (Throwable)pe);
                }
            }
            this.kaleoTimerInstanceTokenPersistence.remove((BaseModel)kaleoTimerInstanceToken);
        }
    }

    public KaleoTimerInstanceToken getKaleoTimerInstanceToken(long kaleoInstanceTokenId, long kaleoTimerId) throws PortalException {
        return this.kaleoTimerInstanceTokenPersistence.findByKITI_KTI(kaleoInstanceTokenId, kaleoTimerId);
    }

    public List<KaleoTimerInstanceToken> getKaleoTimerInstanceTokens(long kaleoInstanceTokenId, boolean blocking, boolean completed, ServiceContext serviceContext) {
        return this.kaleoTimerInstanceTokenPersistence.findByKITI_B_C(kaleoInstanceTokenId, blocking, completed);
    }

    public int getKaleoTimerInstanceTokensCount(long kaleoInstanceTokenId, boolean blocking, boolean completed, ServiceContext serviceContext) {
        return this.kaleoTimerInstanceTokenPersistence.countByKITI_B_C(kaleoInstanceTokenId, blocking, completed);
    }

    protected void deleteScheduledTimer(KaleoTimerInstanceToken kaleoTimerInstanceToken) throws PortalException {
        String groupName = this.getSchedulerGroupName(kaleoTimerInstanceToken);
        this._schedulerEngineHelper.delete(groupName, StorageType.PERSISTED);
    }

    protected String getSchedulerGroupName(KaleoTimerInstanceToken kaleoTimerInstanceToken) {
        return SchedulerUtil.getGroupName((long)kaleoTimerInstanceToken.getKaleoTimerInstanceTokenId());
    }

    protected void scheduleTimer(KaleoTimerInstanceToken kaleoTimerInstanceToken, KaleoTimer kaleoTimer) throws PortalException {
        this.deleteScheduledTimer(kaleoTimerInstanceToken);
        String groupName = this.getSchedulerGroupName(kaleoTimerInstanceToken);
        DelayDuration delayDuration = new DelayDuration(kaleoTimer.getDuration(), DurationScale.valueOf((String)StringUtil.toUpperCase((String)kaleoTimer.getScale())));
        Date dueDate = this._dueDateCalculator.getDueDate(new Date(), delayDuration);
        int interval = 0;
        TimeUnit timeUnit = TimeUnit.SECOND;
        if (kaleoTimer.isRecurring()) {
            DelayDuration recurrenceDelayDuration = new DelayDuration(kaleoTimer.getRecurrenceDuration(), DurationScale.valueOf((String)StringUtil.toUpperCase((String)kaleoTimer.getRecurrenceScale())));
            interval = (int)recurrenceDelayDuration.getDuration();
            DurationScale durationScale = recurrenceDelayDuration.getDurationScale();
            timeUnit = TimeUnit.valueOf((String)StringUtil.toUpperCase((String)durationScale.getValue()));
        }
        Trigger trigger = TriggerFactoryUtil.createTrigger((String)groupName, (String)groupName, (Date)dueDate, (int)interval, (TimeUnit)timeUnit);
        Message message = new Message();
        message.put("kaleoTimerInstanceTokenId", (Object)kaleoTimerInstanceToken.getKaleoTimerInstanceTokenId());
        this._schedulerEngineHelper.schedule(trigger, StorageType.PERSISTED, null, "destination.workflow_timer", message, 0);
    }
}

