/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.Assignment;
import com.liferay.portal.workflow.kaleo.definition.Task;
import com.liferay.portal.workflow.kaleo.definition.TaskForm;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskLocalServiceBaseImpl;
import java.util.Date;
import java.util.Set;

public class KaleoTaskLocalServiceImpl
extends KaleoTaskLocalServiceBaseImpl {
    public KaleoTask addKaleoTask(long kaleoDefinitionVersionId, long kaleoNodeId, Task task, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoTaskId = this.counterLocalService.increment();
        KaleoTask kaleoTask = this.kaleoTaskPersistence.create(kaleoTaskId);
        kaleoTask.setCompanyId(user.getCompanyId());
        kaleoTask.setUserId(user.getUserId());
        kaleoTask.setUserName(user.getFullName());
        kaleoTask.setCreateDate(now);
        kaleoTask.setModifiedDate(now);
        kaleoTask.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoTask.setKaleoNodeId(kaleoNodeId);
        kaleoTask.setName(task.getName());
        kaleoTask.setDescription(task.getDescription());
        this.kaleoTaskPersistence.update((BaseModel)kaleoTask);
        Set assignments = task.getAssignments();
        for (Assignment assignment : assignments) {
            this.kaleoTaskAssignmentLocalService.addKaleoTaskAssignment(KaleoTask.class.getName(), kaleoTaskId, kaleoDefinitionVersionId, assignment, serviceContext);
        }
        Set taskForms = task.getTaskForms();
        for (TaskForm taskForm : taskForms) {
            this.kaleoTaskFormLocalService.addKaleoTaskForm(kaleoDefinitionVersionId, kaleoNodeId, kaleoTask, taskForm, serviceContext);
        }
        return kaleoTask;
    }

    public void deleteCompanyKaleoTasks(long companyId) {
        this.kaleoTaskPersistence.removeByCompanyId(companyId);
        this.kaleoTaskAssignmentLocalService.deleteCompanyKaleoTaskAssignments(companyId);
        this.kaleoTaskFormLocalService.deleteCompanyKaleoTaskForms(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTasks(long kaleoDefinitionVersionId) {
        this.kaleoTaskPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        this.kaleoTaskAssignmentLocalService.deleteKaleoDefinitionVersionKaleoTaskAssignments(kaleoDefinitionVersionId);
        this.kaleoTaskFormLocalService.deleteKaleoDefinitionVersionKaleoTaskForms(kaleoDefinitionVersionId);
    }

    public KaleoTask getKaleoNodeKaleoTask(long kaleoNodeId) throws PortalException {
        return this.kaleoTaskPersistence.findByKaleoNodeId(kaleoNodeId);
    }
}

