/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskInstanceTokenLocalServiceBaseImpl;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTaskInstanceTokenQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class KaleoTaskInstanceTokenLocalServiceImpl
extends KaleoTaskInstanceTokenLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(KaleoTaskInstanceTokenLocalServiceImpl.class);
    private static final Map<String, String> _fieldNameOrderByCols = new HashMap<String, String>(){
        {
            this.put("completed", KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("completed", "String"));
            this.put("completionDate", KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("completionDate", "Number"));
            this.put("createDate", KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("createDate", "Number"));
            this.put("dueDate", KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("dueDate", "Number"));
            this.put("kaleoTaskId", KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("kaleoTaskId", "Number"));
            this.put("kaleoTaskInstanceTokenId", KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("kaleoTaskInstanceTokenId", "Number"));
            this.put("modifiedDate", KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("modified", "Number"));
            this.put("name", KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("taskName", "String"));
            this.put("userId", KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("userId", "Number"));
        }
    };
    private static final Map<String, Integer> _fieldNameSortTypes = new HashMap<String, Integer>(){
        {
            this.put("createDate", 6);
            this.put("modified", 6);
            this.put("completionDate", 6);
            this.put("dueDate", 6);
        }
    };

    @Indexable(type=IndexableType.REINDEX)
    public KaleoTaskInstanceToken addKaleoTaskInstanceToken(long kaleoInstanceTokenId, long kaleoTaskId, String kaleoTaskName, Collection<KaleoTaskAssignment> kaleoTaskAssignments, Date dueDate, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.findByPrimaryKey(kaleoInstanceTokenId);
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoTaskInstanceTokenId = this.counterLocalService.increment();
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.create(kaleoTaskInstanceTokenId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoTaskInstanceToken.setGroupId(groupId);
        kaleoTaskInstanceToken.setCompanyId(user.getCompanyId());
        kaleoTaskInstanceToken.setUserId(user.getUserId());
        kaleoTaskInstanceToken.setUserName(user.getFullName());
        kaleoTaskInstanceToken.setCreateDate(now);
        kaleoTaskInstanceToken.setModifiedDate(now);
        kaleoTaskInstanceToken.setKaleoDefinitionVersionId(kaleoInstanceToken.getKaleoDefinitionVersionId());
        kaleoTaskInstanceToken.setKaleoInstanceId(kaleoInstanceToken.getKaleoInstanceId());
        kaleoTaskInstanceToken.setKaleoInstanceTokenId(kaleoInstanceTokenId);
        kaleoTaskInstanceToken.setDueDate(dueDate);
        kaleoTaskInstanceToken.setKaleoTaskId(kaleoTaskId);
        kaleoTaskInstanceToken.setKaleoTaskName(kaleoTaskName);
        if (workflowContext != null) {
            kaleoTaskInstanceToken.setClassName((String)((Object)workflowContext.get("entryClassName")));
            if (workflowContext.containsKey("entryClassPK")) {
                kaleoTaskInstanceToken.setClassPK(GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK")))));
            }
        }
        kaleoTaskInstanceToken.setCompleted(false);
        kaleoTaskInstanceToken.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstanceToken);
        this.kaleoTaskAssignmentInstanceLocalService.addTaskAssignmentInstances(kaleoTaskInstanceToken, kaleoTaskAssignments, workflowContext, serviceContext);
        return kaleoTaskInstanceToken;
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoTaskInstanceToken assignKaleoTaskInstanceToken(long kaleoTaskInstanceTokenId, String assigneeClassName, long assigneeClassPK, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        kaleoTaskInstanceToken.setModifiedDate(new Date());
        kaleoTaskInstanceToken.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstanceToken);
        this.kaleoTaskAssignmentInstanceLocalService.assignKaleoTaskAssignmentInstance(kaleoTaskInstanceToken, assigneeClassName, assigneeClassPK, serviceContext);
        return kaleoTaskInstanceToken;
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoTaskInstanceToken completeKaleoTaskInstanceToken(long kaleoTaskInstanceTokenId, ServiceContext serviceContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        kaleoTaskInstanceToken.setCompletionUserId(serviceContext.getUserId());
        kaleoTaskInstanceToken.setCompleted(true);
        kaleoTaskInstanceToken.setCompletionDate(new Date());
        this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstanceToken);
        this.kaleoTaskAssignmentInstanceLocalService.completeKaleoTaskInstanceToken(kaleoTaskInstanceTokenId, serviceContext);
        this.kaleoTimerInstanceTokenLocalService.completeKaleoTimerInstanceTokens(kaleoTaskInstanceToken.getKaleoInstanceTokenId(), serviceContext);
        return kaleoTaskInstanceToken;
    }

    public void deleteCompanyKaleoTaskInstanceTokens(long companyId) {
        for (KaleoTaskInstanceToken kaleoTaskInstanceToken : this.kaleoTaskInstanceTokenPersistence.findByCompanyId(companyId)) {
            this.kaleoTaskInstanceTokenLocalService.deleteKaleoTaskInstanceToken(kaleoTaskInstanceToken);
        }
        this.kaleoTaskAssignmentInstanceLocalService.deleteCompanyKaleoTaskAssignmentInstances(companyId);
        this.kaleoTaskFormInstanceLocalService.deleteCompanyKaleoTaskFormInstances(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTaskInstanceTokens(long kaleoDefinitionVersionId) {
        for (KaleoTaskInstanceToken kaleoTaskInstanceToken : this.kaleoTaskInstanceTokenPersistence.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId)) {
            this.kaleoTaskInstanceTokenLocalService.deleteKaleoTaskInstanceToken(kaleoTaskInstanceToken);
        }
        this.kaleoTaskAssignmentInstanceLocalService.deleteKaleoDefinitionVersionKaleoTaskAssignmentInstances(kaleoDefinitionVersionId);
        this.kaleoTaskFormInstanceLocalService.deleteKaleoDefinitionVersionKaleoTaskFormInstances(kaleoDefinitionVersionId);
    }

    public void deleteKaleoInstanceKaleoTaskInstanceTokens(long kaleoInstanceId) {
        for (KaleoTaskInstanceToken kaleoTaskInstanceToken : this.kaleoTaskInstanceTokenPersistence.findByKaleoInstanceId(kaleoInstanceId)) {
            this.kaleoTaskInstanceTokenLocalService.deleteKaleoTaskInstanceToken(kaleoTaskInstanceToken);
        }
        this.kaleoTaskAssignmentInstanceLocalService.deleteKaleoInstanceKaleoTaskAssignmentInstances(kaleoInstanceId);
        this.kaleoTaskFormInstanceLocalService.deleteKaleoInstanceKaleoTaskFormInstances(kaleoInstanceId);
    }

    public List<KaleoTaskInstanceToken> getCompanyKaleoTaskInstanceTokens(long companyId, int start, int end) {
        return this.kaleoTaskInstanceTokenPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyKaleoTaskInstanceTokensCount(long companyId) {
        return this.kaleoTaskInstanceTokenPersistence.countByCompanyId(companyId);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(completed, serviceContext);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(List<Long> roleIds, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setRoleIds(roleIds);
        kaleoTaskInstanceTokenQuery.setStart(start);
        return this.kaleoTaskInstanceTokenFinder.findKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(long kaleoInstanceId, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        long userId = serviceContext.getUserId();
        if (userId == 0L) {
            DynamicQuery dynamicQuery = this.buildDynamicQuery(kaleoInstanceId, completed, serviceContext);
            return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
        }
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(User.class.getName());
        kaleoTaskInstanceTokenQuery.setAssigneeClassPK(Long.valueOf(serviceContext.getUserId()));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setKaleoInstanceId(Long.valueOf(kaleoInstanceId));
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setStart(start);
        return this.kaleoTaskInstanceTokenFinder.findKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public KaleoTaskInstanceToken getKaleoTaskInstanceTokens(long kaleoInstanceId, long kaleoTaskId) throws PortalException {
        return this.kaleoTaskInstanceTokenPersistence.findByKII_KTI(kaleoInstanceId, kaleoTaskId);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(String assigneeClassName, long assigneeClassPK, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(assigneeClassName);
        kaleoTaskInstanceTokenQuery.setAssigneeClassPK(Long.valueOf(assigneeClassPK));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setStart(start);
        return this.kaleoTaskInstanceTokenFinder.findKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public int getKaleoTaskInstanceTokensCount(Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(completed, serviceContext);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public int getKaleoTaskInstanceTokensCount(List<Long> roleIds, Boolean completed, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(Role.class.getName());
        kaleoTaskInstanceTokenQuery.setRoleIds(roleIds);
        return this.kaleoTaskInstanceTokenFinder.countKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public int getKaleoTaskInstanceTokensCount(long kaleoInstanceId, Boolean completed, ServiceContext serviceContext) {
        long userId = serviceContext.getUserId();
        if (userId == 0L) {
            DynamicQuery dynamicQuery = this.buildDynamicQuery(kaleoInstanceId, completed, serviceContext);
            return (int)this.dynamicQueryCount(dynamicQuery);
        }
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(User.class.getName());
        kaleoTaskInstanceTokenQuery.setAssigneeClassPK(Long.valueOf(serviceContext.getUserId()));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setKaleoInstanceId(Long.valueOf(kaleoInstanceId));
        return this.kaleoTaskInstanceTokenFinder.countKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public int getKaleoTaskInstanceTokensCount(String assigneeClassName, long assigneeClassPK, Boolean completed, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(assigneeClassName);
        kaleoTaskInstanceTokenQuery.setAssigneeClassPK(Long.valueOf(assigneeClassPK));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        return this.kaleoTaskInstanceTokenFinder.countKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public List<KaleoTaskInstanceToken> getSubmittingUserKaleoTaskInstanceTokens(long userId, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoTaskInstanceToken.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        Property workflowContextProperty = PropertyFactoryUtil.forName((String)"workflowContext");
        dynamicQuery.add(workflowContextProperty.like((Object)("%\"userId\":\"" + userId + "\"%")));
        this.addCompletedCriterion(dynamicQuery, completed);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public int getSubmittingUserKaleoTaskInstanceTokensCount(long userId, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoTaskInstanceToken.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        Property workflowContextProperty = PropertyFactoryUtil.forName((String)"workflowContext");
        dynamicQuery.add(workflowContextProperty.like((Object)("%\"userId\":\"" + userId + "\"%")));
        this.addCompletedCriterion(dynamicQuery, completed);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public boolean hasPendingKaleoTaskForms(long kaleoTaskInstanceTokenId) throws PortalException {
        int kaleoTaskFormInstancesCount;
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        int kaleoTaskFormsCount = this.kaleoTaskFormPersistence.countByKaleoTaskId(kaleoTaskInstanceToken.getKaleoTaskId());
        return kaleoTaskFormsCount > (kaleoTaskFormInstancesCount = this.kaleoTaskFormInstancePersistence.countByKaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId));
    }

    public List<KaleoTaskInstanceToken> search(String keywords, Boolean completed, Boolean searchByUserRoles, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(keywords, keywords, null, null, null, completed, searchByUserRoles, false, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoTaskInstanceToken> search(String taskName, String assetType, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(null, taskName, this.getAssetTypes(assetType), assetPrimaryKeys, dueDateGT, dueDateLT, completed, searchByUserRoles, andOperator, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoTaskInstanceToken> search(String assetTitle, String taskName, String[] assetTypes, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAndOperator(andOperator);
        kaleoTaskInstanceTokenQuery.setAssetTitle(assetTitle);
        kaleoTaskInstanceTokenQuery.setAssetTypes(assetTypes);
        kaleoTaskInstanceTokenQuery.setAssetPrimaryKeys(assetPrimaryKeys);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setDueDateGT(dueDateGT);
        kaleoTaskInstanceTokenQuery.setDueDateLT(dueDateLT);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setSearchByUserRoles(searchByUserRoles);
        kaleoTaskInstanceTokenQuery.setStart(start);
        kaleoTaskInstanceTokenQuery.setTaskName(taskName);
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)KaleoTaskInstanceToken.class.getName());
            SearchContext searchContext = this.buildSearchContext(kaleoTaskInstanceTokenQuery, start, end, orderByComparator);
            ArrayList<KaleoTaskInstanceToken> kaleoTaskInstanceTokens = new ArrayList<KaleoTaskInstanceToken>();
            Hits hits = indexer.search(searchContext);
            for (Document document : hits.getDocs()) {
                long kaleoTaskInstanceTokenId = GetterUtil.getLong((String)document.get("entryClassPK"));
                kaleoTaskInstanceTokens.add(this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId));
            }
            return kaleoTaskInstanceTokens;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return Collections.emptyList();
        }
    }

    public List<KaleoTaskInstanceToken> search(String keywords, String[] assetTypes, Boolean completed, Boolean searchByUserRoles, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(keywords, keywords, assetTypes, null, null, null, completed, searchByUserRoles, false, start, end, orderByComparator, serviceContext);
    }

    public int searchCount(long kaleoInstanceId, Boolean completed, Boolean searchByUserRoles, ServiceContext serviceContext) {
        return this.searchCount(kaleoInstanceId, null, null, null, null, null, null, completed, searchByUserRoles, false, serviceContext);
    }

    public int searchCount(Long kaleoInstanceId, String assetTitle, String taskName, String[] assetTypes, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAndOperator(andOperator);
        kaleoTaskInstanceTokenQuery.setAssetTitle(assetTitle);
        kaleoTaskInstanceTokenQuery.setAssetTypes(assetTypes);
        kaleoTaskInstanceTokenQuery.setAssetPrimaryKeys(assetPrimaryKeys);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setDueDateGT(dueDateGT);
        kaleoTaskInstanceTokenQuery.setDueDateLT(dueDateLT);
        kaleoTaskInstanceTokenQuery.setKaleoInstanceId(kaleoInstanceId);
        kaleoTaskInstanceTokenQuery.setSearchByUserRoles(searchByUserRoles);
        kaleoTaskInstanceTokenQuery.setTaskName(taskName);
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)KaleoTaskInstanceToken.class.getName());
            SearchContext searchContext = this.buildSearchContext(kaleoTaskInstanceTokenQuery, -1, -1, null);
            return (int)indexer.searchCount(searchContext);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return 0;
        }
    }

    public int searchCount(String keywords, Boolean completed, Boolean searchByUserRoles, ServiceContext serviceContext) {
        return this.searchCount(keywords, keywords, null, null, null, completed, searchByUserRoles, false, serviceContext);
    }

    public int searchCount(String taskName, String assetType, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, ServiceContext serviceContext) {
        return this.searchCount(null, null, taskName, this.getAssetTypes(assetType), assetPrimaryKeys, dueDateGT, dueDateLT, completed, searchByUserRoles, andOperator, serviceContext);
    }

    public int searchCount(String keywords, String[] assetTypes, Boolean completed, Boolean searchByUserRoles, ServiceContext serviceContext) {
        return this.searchCount(null, keywords, keywords, assetTypes, null, null, null, completed, searchByUserRoles, false, serviceContext);
    }

    public KaleoTaskInstanceToken updateDueDate(long kaleoTaskInstanceTokenId, Date dueDate, ServiceContext serviceContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        kaleoTaskInstanceToken.setModifiedDate(new Date());
        if (dueDate != null) {
            Calendar cal = CalendarFactoryUtil.getCalendar((Locale)LocaleUtil.getDefault());
            cal.setTime(dueDate);
            kaleoTaskInstanceToken.setDueDate(cal.getTime());
        }
        return this.kaleoTaskInstanceTokenLocalService.updateKaleoTaskInstanceToken(kaleoTaskInstanceToken);
    }

    protected void addCompletedCriterion(DynamicQuery dynamicQuery, Boolean completed) {
        if (completed == null) {
            return;
        }
        Property property = PropertyFactoryUtil.forName((String)"completed");
        dynamicQuery.add(property.eq((Object)completed));
    }

    protected DynamicQuery buildDynamicQuery(Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoTaskInstanceToken.class, (ClassLoader)this.getClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(property.eq((Object)serviceContext.getCompanyId()));
        this.addCompletedCriterion(dynamicQuery, completed);
        return dynamicQuery;
    }

    protected DynamicQuery buildDynamicQuery(long kaleoInstanceId, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoTaskInstanceToken.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        Property kaleoInstanceIdProperty = PropertyFactoryUtil.forName((String)"kaleoInstanceId");
        dynamicQuery.add(kaleoInstanceIdProperty.eq((Object)kaleoInstanceId));
        this.addCompletedCriterion(dynamicQuery, completed);
        return dynamicQuery;
    }

    protected SearchContext buildSearchContext(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("kaleoTaskInstanceTokenQuery", (Serializable)kaleoTaskInstanceTokenQuery);
        searchContext.setCompanyId(kaleoTaskInstanceTokenQuery.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setStart(start);
        if (orderByComparator != null) {
            searchContext.setSorts(this.getSortsFromComparator(orderByComparator));
        }
        searchContext.setUserId(kaleoTaskInstanceTokenQuery.getUserId());
        return searchContext;
    }

    protected String[] getAssetTypes(String assetType) {
        if (Validator.isNull((String)assetType)) {
            return null;
        }
        return new String[]{assetType};
    }

    protected Sort[] getSortsFromComparator(OrderByComparator<KaleoTaskInstanceToken> orderByComparator) {
        Stream<String> stream = Arrays.stream(orderByComparator.getOrderByFields());
        return (Sort[])stream.map(orderByFieldName -> {
            String fieldName = _fieldNameOrderByCols.getOrDefault(orderByFieldName, (String)orderByFieldName);
            int sortType = _fieldNameSortTypes.getOrDefault(fieldName, 3);
            boolean ascending = orderByComparator.isAscending();
            if (Objects.equals(orderByFieldName, "completed")) {
                ascending = true;
            }
            return new Sort(fieldName, sortType, !ascending);
        }).toArray(Sort[]::new);
    }

    private static String _getSortableFieldName(String name, String type) {
        return Field.getSortableFieldName((String)StringBundler.concat((String[])new String[]{name, "_", type}));
    }
}

