/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskForm;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskFormInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.form.FormValueProcessor;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskFormInstanceLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class KaleoTaskFormInstanceLocalServiceImpl
extends KaleoTaskFormInstanceLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(KaleoTaskFormInstanceLocalServiceImpl.class);
    private static final ServiceTracker<FormValueProcessor, FormValueProcessor> _serviceTracker = ServiceTrackerFactory.open((Bundle)FrameworkUtil.getBundle(KaleoTaskFormInstanceLocalServiceImpl.class), FormValueProcessor.class);

    public KaleoTaskFormInstance addKaleoTaskFormInstance(long groupId, long kaleoTaskFormId, String formValues, KaleoTaskInstanceToken kaleoTaskInstanceToken, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoTaskFormInstanceId = this.counterLocalService.increment();
        KaleoTaskFormInstance kaleoTaskFormInstance = this.kaleoTaskFormInstancePersistence.create(kaleoTaskFormInstanceId);
        kaleoTaskFormInstance.setGroupId(groupId);
        kaleoTaskFormInstance.setCompanyId(user.getCompanyId());
        kaleoTaskFormInstance.setUserId(user.getUserId());
        kaleoTaskFormInstance.setUserName(user.getFullName());
        kaleoTaskFormInstance.setCreateDate(now);
        kaleoTaskFormInstance.setModifiedDate(now);
        kaleoTaskFormInstance.setKaleoDefinitionVersionId(kaleoTaskInstanceToken.getKaleoDefinitionVersionId());
        kaleoTaskFormInstance.setKaleoInstanceId(kaleoTaskInstanceToken.getKaleoInstanceId());
        kaleoTaskFormInstance.setKaleoTaskId(kaleoTaskInstanceToken.getKaleoTaskId());
        kaleoTaskFormInstance.setKaleoTaskInstanceTokenId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        kaleoTaskFormInstance.setKaleoTaskFormId(kaleoTaskFormId);
        KaleoTaskForm kaleoTaskForm = this.kaleoTaskFormLocalService.getKaleoTaskForm(kaleoTaskFormId);
        if (Validator.isNotNull((String)kaleoTaskForm.getFormDefinition())) {
            kaleoTaskFormInstance.setFormValues(formValues);
        } else {
            FormValueProcessor formValueProcessor = this.getFormValueProcessor();
            if (formValueProcessor != null) {
                kaleoTaskFormInstance = formValueProcessor.processFormValues(kaleoTaskForm, kaleoTaskFormInstance, formValues, serviceContext);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"No form value processor defined to for form: ", kaleoTaskForm.getKaleoTaskFormId(), " and values: ", formValues}));
            }
        }
        this.kaleoTaskFormInstancePersistence.update((BaseModel)kaleoTaskFormInstance);
        return kaleoTaskFormInstance;
    }

    public int countKaleoTaskFormInstanceByKaleoTaskId(long kaleoTaskId) {
        return this.kaleoTaskFormInstancePersistence.countByKaleoTaskId(kaleoTaskId);
    }

    public void deleteCompanyKaleoTaskFormInstances(long companyId) {
        this.kaleoTaskFormInstancePersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTaskFormInstances(long kaleoDefinitionVersionId) {
        this.kaleoTaskFormInstancePersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    public void deleteKaleoInstanceKaleoTaskFormInstances(long kaleoInstanceId) {
        this.kaleoTaskFormInstancePersistence.removeByKaleoInstanceId(kaleoInstanceId);
    }

    public KaleoTaskFormInstance fetchKaleoTaskFormKaleoTaskFormInstance(long kaleoTaskFormId) {
        return this.kaleoTaskFormInstancePersistence.fetchByKaleoTaskFormId(kaleoTaskFormId);
    }

    public KaleoTaskFormInstance getKaleoTaskFormKaleoTaskFormInstance(long kaleoTaskFormId) throws PortalException {
        return this.kaleoTaskFormInstancePersistence.findByKaleoTaskFormId(kaleoTaskFormId);
    }

    public List<KaleoTaskFormInstance> getKaleoTaskKaleoTaskFormInstances(long kaleoTaskId) {
        return this.kaleoTaskFormInstancePersistence.findByKaleoTaskId(kaleoTaskId);
    }

    protected FormValueProcessor getFormValueProcessor() {
        return (FormValueProcessor)_serviceTracker.getService();
    }
}

