/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.NotificationType;
import com.liferay.portal.workflow.kaleo.definition.Recipient;
import com.liferay.portal.workflow.kaleo.definition.TemplateLanguage;
import com.liferay.portal.workflow.kaleo.model.KaleoNotification;
import com.liferay.portal.workflow.kaleo.service.base.KaleoNotificationLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KaleoNotificationLocalServiceImpl
extends KaleoNotificationLocalServiceBaseImpl {
    public KaleoNotification addKaleoNotification(String kaleoClassName, long kaleoClassPK, long kaleoDefinitionVersionId, String kaleoNodeName, Notification notification, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoNotificationId = this.counterLocalService.increment();
        KaleoNotification kaleoNotification = this.kaleoNotificationPersistence.create(kaleoNotificationId);
        kaleoNotification.setCompanyId(user.getCompanyId());
        kaleoNotification.setUserId(user.getUserId());
        kaleoNotification.setUserName(user.getFullName());
        kaleoNotification.setCreateDate(now);
        kaleoNotification.setModifiedDate(now);
        kaleoNotification.setKaleoClassName(kaleoClassName);
        kaleoNotification.setKaleoClassPK(kaleoClassPK);
        kaleoNotification.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoNotification.setKaleoNodeName(kaleoNodeName);
        kaleoNotification.setName(notification.getName());
        kaleoNotification.setDescription(notification.getDescription());
        ExecutionType executionType = notification.getExecutionType();
        kaleoNotification.setExecutionType(executionType.getValue());
        kaleoNotification.setTemplate(notification.getTemplate());
        TemplateLanguage templateLanguage = notification.getTemplateLanguage();
        kaleoNotification.setTemplateLanguage(templateLanguage.getValue());
        Set notificationTypes = notification.getNotificationTypes();
        if (!notificationTypes.isEmpty()) {
            StringBundler sb = new StringBundler(notificationTypes.size() * 2);
            for (NotificationType notificationType : notificationTypes) {
                sb.append(notificationType.getValue());
                sb.append(",");
            }
            sb.setIndex(sb.index() - 1);
            kaleoNotification.setNotificationTypes(sb.toString());
        }
        this.kaleoNotificationPersistence.update((BaseModel)kaleoNotification);
        Map recipientsMap = notification.getRecipientsMap();
        for (Set recipients : recipientsMap.values()) {
            for (Recipient recipient : recipients) {
                this.kaleoNotificationRecipientLocalService.addKaleoNotificationRecipient(kaleoDefinitionVersionId, kaleoNotificationId, recipient, serviceContext);
            }
        }
        return kaleoNotification;
    }

    public void deleteCompanyKaleoNotifications(long companyId) {
        this.kaleoNotificationPersistence.removeByCompanyId(companyId);
        this.kaleoNotificationRecipientLocalService.deleteCompanyKaleoNotificationRecipients(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoNotifications(long kaleoDefinitionVersionId) {
        this.kaleoNotificationPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        this.kaleoNotificationRecipientLocalService.deleteKaleoDefinitionVersionKaleoNotificationRecipients(kaleoDefinitionVersionId);
    }

    public List<KaleoNotification> getKaleoNotifications(String kaleoClassName, long kaleoClassPK) {
        return this.kaleoNotificationPersistence.findByKCN_KCPK(kaleoClassName, kaleoClassPK);
    }

    public List<KaleoNotification> getKaleoNotifications(String kaleoClassName, long kaleoClassPK, String executionType) {
        return this.kaleoNotificationPersistence.findByKCN_KCPK_ET(kaleoClassName, kaleoClassPK, executionType);
    }
}

