/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.Action;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.State;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.service.base.KaleoNodeLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class KaleoNodeLocalServiceImpl
extends KaleoNodeLocalServiceBaseImpl {
    public KaleoNode addKaleoNode(long kaleoDefinitionVersionId, Node node, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoNodeId = this.counterLocalService.increment();
        KaleoNode kaleoNode = this.kaleoNodePersistence.create(kaleoNodeId);
        kaleoNode.setCompanyId(user.getCompanyId());
        kaleoNode.setUserId(user.getUserId());
        kaleoNode.setUserName(user.getFullName());
        kaleoNode.setCreateDate(now);
        kaleoNode.setModifiedDate(now);
        kaleoNode.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoNode.setName(node.getName());
        kaleoNode.setMetadata(node.getMetadata());
        kaleoNode.setDescription(node.getDescription());
        NodeType nodeType = node.getNodeType();
        kaleoNode.setType(nodeType.name());
        boolean initial = false;
        boolean terminal = false;
        if (nodeType.equals((Object)NodeType.STATE)) {
            State state = (State)node;
            initial = state.isInitial();
            terminal = state.isTerminal();
        }
        kaleoNode.setInitial(initial);
        kaleoNode.setTerminal(terminal);
        this.kaleoNodePersistence.update((BaseModel)kaleoNode);
        Set actions = node.getActions();
        for (Object action : actions) {
            this.kaleoActionLocalService.addKaleoAction(KaleoNode.class.getName(), kaleoNodeId, kaleoDefinitionVersionId, node.getName(), (Action)action, serviceContext);
        }
        Set notifications = node.getNotifications();
        for (Notification notification : notifications) {
            this.kaleoNotificationLocalService.addKaleoNotification(KaleoNode.class.getName(), kaleoNodeId, kaleoDefinitionVersionId, node.getName(), notification, serviceContext);
        }
        Set timers = node.getTimers();
        for (Timer timer : timers) {
            this.kaleoTimerLocalService.addKaleoTimer(KaleoNode.class.getName(), kaleoNodeId, kaleoDefinitionVersionId, timer, serviceContext);
        }
        return kaleoNode;
    }

    public void deleteCompanyKaleoNodes(long companyId) {
        this.kaleoNodePersistence.removeByCompanyId(companyId);
        this.kaleoActionLocalService.deleteCompanyKaleoActions(companyId);
        this.kaleoNotificationLocalService.deleteCompanyKaleoNotifications(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoNodes(long kaleoDefinitionVersionId) {
        this.kaleoNodePersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        this.kaleoActionLocalService.deleteKaleoDefinitionVersionKaleoActions(kaleoDefinitionVersionId);
        this.kaleoNotificationLocalService.deleteKaleoDefinitionVersionKaleoNotifications(kaleoDefinitionVersionId);
    }

    public List<KaleoNode> getKaleoDefinitionVersionKaleoNodes(long kaleoDefinitionVersionId) {
        return this.kaleoNodePersistence.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }
}

