/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.LogType;
import com.liferay.portal.workflow.kaleo.definition.util.KaleoLogUtil;
import com.liferay.portal.workflow.kaleo.exception.NoSuchLogException;
import com.liferay.portal.workflow.kaleo.model.KaleoAction;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoLog;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.base.KaleoLogLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class KaleoLogLocalServiceImpl
extends KaleoLogLocalServiceBaseImpl {
    public KaleoLog addActionExecutionKaleoLog(KaleoInstanceToken kaleoInstanceToken, KaleoAction kaleoAction, long startTime, long endTime, String comment, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.ACTION_EXECUTION, serviceContext);
        kaleoLog.setKaleoClassName(kaleoAction.getKaleoClassName());
        kaleoLog.setKaleoClassPK(kaleoAction.getKaleoClassPK());
        kaleoLog.setKaleoDefinitionVersionId(kaleoAction.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoNodeName(kaleoAction.getKaleoNodeName());
        kaleoLog.setComment(comment);
        kaleoLog.setStartDate(new Date(startTime));
        kaleoLog.setEndDate(new Date(endTime));
        kaleoLog.setDuration(endTime - startTime);
        this.kaleoLogPersistence.update((BaseModel)kaleoLog);
        return kaleoLog;
    }

    public KaleoLog addNodeEntryKaleoLog(KaleoInstanceToken kaleoInstanceToken, KaleoNode sourceKaleoNode, KaleoNode targetKaleoNode, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.NODE_ENTRY, serviceContext);
        kaleoLog.setKaleoClassName(KaleoNode.class.getName());
        kaleoLog.setKaleoClassPK(targetKaleoNode.getKaleoNodeId());
        kaleoLog.setKaleoDefinitionVersionId(targetKaleoNode.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoNodeName(targetKaleoNode.getName());
        kaleoLog.setTerminalKaleoNode(targetKaleoNode.isTerminal());
        if (sourceKaleoNode != null) {
            kaleoLog.setPreviousKaleoNodeId(sourceKaleoNode.getKaleoNodeId());
            kaleoLog.setPreviousKaleoNodeName(sourceKaleoNode.getName());
        }
        kaleoLog.setStartDate(kaleoLog.getCreateDate());
        this.kaleoLogPersistence.update((BaseModel)kaleoLog);
        return kaleoLog;
    }

    public KaleoLog addNodeExitKaleoLog(KaleoInstanceToken kaleoInstanceToken, KaleoNode departingKaleoNode, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.NODE_EXIT, serviceContext);
        kaleoLog.setKaleoClassName(KaleoNode.class.getName());
        kaleoLog.setKaleoClassPK(departingKaleoNode.getKaleoNodeId());
        kaleoLog.setKaleoDefinitionVersionId(departingKaleoNode.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoNodeName(departingKaleoNode.getName());
        kaleoLog.setEndDate(kaleoLog.getCreateDate());
        try {
            KaleoLog previousKaleoLog = this.getPreviousLog(kaleoLog.getKaleoInstanceTokenId(), kaleoLog.getKaleoClassPK(), LogType.WORKFLOW_INSTANCE_START);
            Date startDate = previousKaleoLog.getStartDate();
            Date endDate = kaleoLog.getEndDate();
            kaleoLog.setDuration(endDate.getTime() - startDate.getTime());
        }
        catch (NoSuchLogException noSuchLogException) {
            // empty catch block
        }
        this.kaleoLogPersistence.update((BaseModel)kaleoLog);
        return kaleoLog;
    }

    public KaleoLog addTaskAssignmentKaleoLog(List<KaleoTaskAssignmentInstance> previousKaleoTaskAssignmentInstances, KaleoTaskInstanceToken kaleoTaskInstanceToken, String comment, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        List kaleoTaskAssignmentInstances;
        KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.TASK_ASSIGNMENT, serviceContext);
        kaleoLog.setKaleoTaskInstanceTokenId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        KaleoNode currentKaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
        kaleoLog.setKaleoClassName(KaleoNode.class.getName());
        kaleoLog.setKaleoClassPK(currentKaleoNode.getKaleoNodeId());
        kaleoLog.setKaleoDefinitionVersionId(currentKaleoNode.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoNodeName(currentKaleoNode.getName());
        if (previousKaleoTaskAssignmentInstances != null && previousKaleoTaskAssignmentInstances.size() == 1) {
            KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = previousKaleoTaskAssignmentInstances.get(0);
            kaleoLog.setPreviousAssigneeClassName(kaleoTaskAssignmentInstance.getAssigneeClassName());
            kaleoLog.setPreviousAssigneeClassPK(kaleoTaskAssignmentInstance.getAssigneeClassPK());
        }
        if (!(kaleoTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances()).isEmpty()) {
            KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = (KaleoTaskAssignmentInstance)kaleoTaskAssignmentInstances.get(0);
            kaleoLog.setCurrentAssigneeClassName(kaleoTaskAssignmentInstance.getAssigneeClassName());
            kaleoLog.setCurrentAssigneeClassPK(kaleoTaskAssignmentInstance.getAssigneeClassPK());
        }
        kaleoLog.setComment(comment);
        kaleoLog.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoLogPersistence.update((BaseModel)kaleoLog);
        return kaleoLog;
    }

    public KaleoLog addTaskCompletionKaleoLog(KaleoTaskInstanceToken kaleoTaskInstanceToken, String comment, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.TASK_COMPLETION, serviceContext);
        kaleoLog.setKaleoTaskInstanceTokenId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        KaleoNode currentKaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
        kaleoLog.setKaleoClassName(KaleoNode.class.getName());
        kaleoLog.setKaleoClassPK(currentKaleoNode.getKaleoNodeId());
        kaleoLog.setKaleoDefinitionVersionId(currentKaleoNode.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoNodeName(currentKaleoNode.getName());
        List kaleoTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
        if (!kaleoTaskAssignmentInstances.isEmpty()) {
            KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = (KaleoTaskAssignmentInstance)kaleoTaskAssignmentInstances.get(0);
            kaleoLog.setCurrentAssigneeClassName(kaleoTaskAssignmentInstance.getAssigneeClassName());
            kaleoLog.setCurrentAssigneeClassPK(kaleoTaskAssignmentInstance.getAssigneeClassPK());
        }
        kaleoLog.setComment(comment);
        kaleoLog.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoLogPersistence.update((BaseModel)kaleoLog);
        return kaleoLog;
    }

    public KaleoLog addTaskUpdateKaleoLog(KaleoTaskInstanceToken kaleoTaskInstanceToken, String comment, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.TASK_UPDATE, serviceContext);
        List kaleoTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
        if (!kaleoTaskAssignmentInstances.isEmpty()) {
            KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = (KaleoTaskAssignmentInstance)kaleoTaskAssignmentInstances.get(0);
            kaleoLog.setCurrentAssigneeClassName(kaleoTaskAssignmentInstance.getAssigneeClassName());
            kaleoLog.setCurrentAssigneeClassPK(kaleoTaskAssignmentInstance.getAssigneeClassPK());
        }
        kaleoLog.setComment(comment);
        kaleoLog.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoLogPersistence.update((BaseModel)kaleoLog);
        return kaleoLog;
    }

    public KaleoLog addWorkflowInstanceEndKaleoLog(KaleoInstanceToken kaleoInstanceToken, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.WORKFLOW_INSTANCE_END, serviceContext);
        kaleoLog.setEndDate(kaleoLog.getCreateDate());
        try {
            KaleoLog previousKaleoLog = this.getPreviousLog(kaleoLog.getKaleoInstanceTokenId(), 0L, LogType.WORKFLOW_INSTANCE_START);
            Date startDate = previousKaleoLog.getStartDate();
            Date endDate = kaleoLog.getEndDate();
            kaleoLog.setDuration(endDate.getTime() - startDate.getTime());
        }
        catch (NoSuchLogException noSuchLogException) {
            // empty catch block
        }
        this.kaleoLogPersistence.update((BaseModel)kaleoLog);
        return kaleoLog;
    }

    public KaleoLog addWorkflowInstanceStartKaleoLog(KaleoInstanceToken kaleoInstanceToken, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.WORKFLOW_INSTANCE_START, serviceContext);
        kaleoLog.setStartDate(kaleoLog.getCreateDate());
        KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
        kaleoLog.setWorkflowContext(kaleoInstance.getWorkflowContext());
        this.kaleoLogPersistence.update((BaseModel)kaleoLog);
        return kaleoLog;
    }

    public void deleteCompanyKaleoLogs(long companyId) {
        this.kaleoLogPersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoLogs(long kaleoDefinitionVersionId) {
        this.kaleoLogPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    public void deleteKaleoInstanceKaleoLogs(long kaleoInstanceId) {
        this.kaleoLogPersistence.removeByKaleoInstanceId(kaleoInstanceId);
    }

    public List<KaleoLog> getKaleoInstanceKaleoLogs(long kaleoInstanceId, List<Integer> logTypes, int start, int end, OrderByComparator<KaleoLog> orderByComparator) {
        if (logTypes == null || logTypes.isEmpty()) {
            return this.kaleoLogPersistence.findByKaleoInstanceId(kaleoInstanceId, start, end, orderByComparator);
        }
        DynamicQuery dynamicQuery = this.buildKaleoInstanceDynamicQuery(kaleoInstanceId, logTypes);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public int getKaleoInstanceKaleoLogsCount(long kaleoInstanceId, List<Integer> logTypes) {
        if (logTypes == null || logTypes.isEmpty()) {
            return this.kaleoLogPersistence.countByKaleoInstanceId(kaleoInstanceId);
        }
        DynamicQuery dynamicQuery = this.buildKaleoInstanceDynamicQuery(kaleoInstanceId, logTypes);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public List<KaleoLog> getKaleoTaskInstanceTokenKaleoLogs(long kaleoTaskInstanceTokenId, List<Integer> logTypes, int start, int end, OrderByComparator<KaleoLog> orderByComparator) {
        if (logTypes == null || logTypes.isEmpty()) {
            return this.kaleoLogPersistence.findByKaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId, start, end, orderByComparator);
        }
        DynamicQuery dynamicQuery = this.buildKaleoTaskInstanceTokenDynamicQuery(kaleoTaskInstanceTokenId, logTypes);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public int getKaleoTaskInstanceTokenKaleoLogsCount(long kaleoTaskInstanceTokenId, List<Integer> logTypes) {
        if (logTypes == null || logTypes.isEmpty()) {
            return this.kaleoLogPersistence.countByKaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId);
        }
        DynamicQuery dynamicQuery = this.buildKaleoTaskInstanceTokenDynamicQuery(kaleoTaskInstanceTokenId, logTypes);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    protected void addLogTypesJunction(DynamicQuery dynamicQuery, List<Integer> logTypes) {
        Disjunction junction = RestrictionsFactoryUtil.disjunction();
        for (Integer logType : logTypes) {
            String logTypeString = KaleoLogUtil.convert((int)logType);
            if (Validator.isNull((String)logTypeString)) continue;
            Property property = PropertyFactoryUtil.forName((String)"type");
            junction.add(property.eq((Object)logTypeString));
        }
        dynamicQuery.add((Criterion)junction);
    }

    protected DynamicQuery buildKaleoInstanceDynamicQuery(long kaleoInstanceId, List<Integer> logTypes) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoLog.class, (ClassLoader)this.getClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"kaleoInstanceId");
        dynamicQuery.add(property.eq((Object)kaleoInstanceId));
        this.addLogTypesJunction(dynamicQuery, logTypes);
        return dynamicQuery;
    }

    protected DynamicQuery buildKaleoTaskInstanceTokenDynamicQuery(long kaleoTaskId, List<Integer> logTypes) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoLog.class, (ClassLoader)this.getClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"kaleoTaskInstanceTokenId");
        dynamicQuery.add(property.eq((Object)kaleoTaskId));
        this.addLogTypesJunction(dynamicQuery, logTypes);
        return dynamicQuery;
    }

    protected KaleoLog createKaleoLog(KaleoInstanceToken kaleoInstanceToken, LogType logType, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoLogId = this.counterLocalService.increment();
        KaleoLog kaleoLog = this.kaleoLogPersistence.create(kaleoLogId);
        kaleoLog.setCompanyId(user.getCompanyId());
        kaleoLog.setUserId(user.getUserId());
        kaleoLog.setUserName(user.getFullName());
        kaleoLog.setCreateDate(now);
        kaleoLog.setModifiedDate(now);
        kaleoLog.setKaleoDefinitionVersionId(kaleoInstanceToken.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoInstanceId(kaleoInstanceToken.getKaleoInstanceId());
        kaleoLog.setKaleoInstanceTokenId(kaleoInstanceToken.getKaleoInstanceTokenId());
        kaleoLog.setType(logType.name());
        return kaleoLog;
    }

    protected KaleoLog getPreviousLog(long kaleoInstanceTokenId, long kaleoNodeId, LogType logType) throws PortalException {
        List kaleoLogEntries = null;
        kaleoLogEntries = kaleoNodeId > 0L ? this.kaleoLogPersistence.findByKCN_KCPK_KITI_T(KaleoNode.class.getName(), kaleoNodeId, kaleoInstanceTokenId, logType.name()) : this.kaleoLogPersistence.findByKITI_T(kaleoInstanceTokenId, logType.name());
        if (!kaleoLogEntries.isEmpty()) {
            return (KaleoLog)kaleoLogEntries.get(0);
        }
        throw new NoSuchLogException();
    }
}

