/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.service.base.KaleoInstanceTokenLocalServiceBaseImpl;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoInstanceTokenQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class KaleoInstanceTokenLocalServiceImpl
extends KaleoInstanceTokenLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstanceToken addKaleoInstanceToken(long currentKaleoNodeId, long kaleoDefinitionVersionId, long kaleoInstanceId, long parentKaleoInstanceTokenId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoInstanceTokenId = this.counterLocalService.increment();
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.create(kaleoInstanceTokenId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoInstanceToken.setGroupId(groupId);
        kaleoInstanceToken.setCompanyId(user.getCompanyId());
        kaleoInstanceToken.setUserId(user.getUserId());
        kaleoInstanceToken.setUserName(user.getFullName());
        kaleoInstanceToken.setCreateDate(now);
        kaleoInstanceToken.setModifiedDate(now);
        kaleoInstanceToken.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoInstanceToken.setKaleoInstanceId(kaleoInstanceId);
        kaleoInstanceToken.setParentKaleoInstanceTokenId(parentKaleoInstanceTokenId);
        if (currentKaleoNodeId > 0L) {
            this.setCurrentKaleoNode(kaleoInstanceToken, currentKaleoNodeId);
        }
        kaleoInstanceToken.setClassName((String)((Object)workflowContext.get("entryClassName")));
        if (workflowContext.containsKey("entryClassPK")) {
            kaleoInstanceToken.setClassPK(GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK")))));
        }
        kaleoInstanceToken.setCompleted(false);
        this.kaleoInstanceTokenPersistence.update((BaseModel)kaleoInstanceToken);
        return kaleoInstanceToken;
    }

    public KaleoInstanceToken addKaleoInstanceToken(long parentKaleoInstanceTokenId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstanceToken parentKaleoInstanceToken = this.kaleoInstanceTokenPersistence.findByPrimaryKey(parentKaleoInstanceTokenId);
        return this.kaleoInstanceTokenLocalService.addKaleoInstanceToken(parentKaleoInstanceToken.getCurrentKaleoNodeId(), parentKaleoInstanceToken.getKaleoDefinitionVersionId(), parentKaleoInstanceToken.getKaleoInstanceId(), parentKaleoInstanceToken.getKaleoInstanceTokenId(), workflowContext, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstanceToken completeKaleoInstanceToken(long kaleoInstanceTokenId) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.findByPrimaryKey(kaleoInstanceTokenId);
        kaleoInstanceToken.setCompleted(true);
        kaleoInstanceToken.setCompletionDate(new Date());
        this.kaleoInstanceTokenPersistence.update((BaseModel)kaleoInstanceToken);
        return kaleoInstanceToken;
    }

    public void deleteCompanyKaleoInstanceTokens(long companyId) {
        for (KaleoInstanceToken kaleoInstanceToken : this.kaleoInstanceTokenPersistence.findByCompanyId(companyId)) {
            this.kaleoInstanceTokenLocalService.deleteKaleoInstanceToken(kaleoInstanceToken);
        }
    }

    public void deleteKaleoDefinitionVersionKaleoInstanceTokens(long kaleoDefinitionVersionId) {
        for (KaleoInstanceToken kaleoInstanceToken : this.kaleoInstanceTokenPersistence.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId)) {
            this.kaleoInstanceTokenLocalService.deleteKaleoInstanceToken(kaleoInstanceToken);
        }
    }

    public void deleteKaleoInstanceKaleoInstanceTokens(long kaleoInstanceId) {
        for (KaleoInstanceToken kaleoInstanceToken : this.kaleoInstanceTokenPersistence.findByKaleoInstanceId(kaleoInstanceId)) {
            this.kaleoInstanceTokenLocalService.deleteKaleoInstanceToken(kaleoInstanceToken);
        }
    }

    public List<KaleoInstanceToken> getKaleoInstanceTokens(long parentKaleoInstanceTokenId, Date completionDate, ServiceContext serviceContext) {
        return this.kaleoInstanceTokenPersistence.findByC_PKITI_CD(serviceContext.getCompanyId(), parentKaleoInstanceTokenId, completionDate);
    }

    public List<KaleoInstanceToken> getKaleoInstanceTokens(long parentKaleoInstanceTokenId, ServiceContext serviceContext) {
        return this.kaleoInstanceTokenPersistence.findByC_PKITI(serviceContext.getCompanyId(), parentKaleoInstanceTokenId);
    }

    public int getKaleoInstanceTokensCount(long parentKaleoInstanceTokenId, Date completionDate, ServiceContext serviceContext) {
        return this.kaleoInstanceTokenPersistence.countByC_PKITI_CD(serviceContext.getCompanyId(), parentKaleoInstanceTokenId, completionDate);
    }

    public int getKaleoInstanceTokensCount(long parentKaleoInstanceTokenId, ServiceContext serviceContext) {
        return this.kaleoInstanceTokenPersistence.countByC_PKITI(serviceContext.getCompanyId(), parentKaleoInstanceTokenId);
    }

    public KaleoInstanceToken getRootKaleoInstanceToken(long kaleoInstanceId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        long rootKaleoInstanceTokenId = kaleoInstance.getRootKaleoInstanceTokenId();
        if (rootKaleoInstanceTokenId > 0L) {
            return this.kaleoInstanceTokenPersistence.findByPrimaryKey(rootKaleoInstanceTokenId);
        }
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenLocalService.addKaleoInstanceToken(0L, kaleoInstance.getKaleoDefinitionVersionId(), kaleoInstance.getKaleoInstanceId(), 0L, workflowContext, serviceContext);
        this.kaleoInstanceLocalService.updateKaleoInstance(kaleoInstanceId, kaleoInstanceToken.getKaleoInstanceTokenId());
        return kaleoInstanceToken;
    }

    public Hits search(Long userId, String assetClassName, String assetTitle, String assetDescription, String currentKaleoNodeName, String kaleoDefinitionName, Boolean completed, int start, int end, Sort[] sorts, ServiceContext serviceContext) {
        try {
            KaleoInstanceTokenQuery kaleoInstanceTokenQuery = new KaleoInstanceTokenQuery(serviceContext);
            kaleoInstanceTokenQuery.setAssetDescription(assetDescription);
            kaleoInstanceTokenQuery.setAssetTitle(assetTitle);
            kaleoInstanceTokenQuery.setClassName(assetClassName);
            kaleoInstanceTokenQuery.setCompleted(completed);
            kaleoInstanceTokenQuery.setCurrentKaleoNodeName(currentKaleoNodeName);
            kaleoInstanceTokenQuery.setKaleoDefinitionName(kaleoDefinitionName);
            kaleoInstanceTokenQuery.setUserId(userId);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(KaleoInstanceToken.class);
            SearchContext searchContext = this.buildSearchContext(kaleoInstanceTokenQuery, start, end, sorts, serviceContext);
            return indexer.search(searchContext);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
    }

    public int searchCount(Long userId, String assetClassName, String assetTitle, String assetDescription, String currentKaleoNodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) {
        KaleoInstanceTokenQuery kaleoInstanceTokenQuery = new KaleoInstanceTokenQuery(serviceContext);
        kaleoInstanceTokenQuery.setAssetDescription(assetDescription);
        kaleoInstanceTokenQuery.setAssetTitle(assetTitle);
        kaleoInstanceTokenQuery.setClassName(assetClassName);
        kaleoInstanceTokenQuery.setCurrentKaleoNodeName(currentKaleoNodeName);
        kaleoInstanceTokenQuery.setCompleted(completed);
        kaleoInstanceTokenQuery.setKaleoDefinitionName(kaleoDefinitionName);
        kaleoInstanceTokenQuery.setUserId(userId);
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(KaleoInstanceToken.class);
            SearchContext searchContext = this.buildSearchContext(kaleoInstanceTokenQuery, -1, -1, null, serviceContext);
            return (int)indexer.searchCount(searchContext);
        }
        catch (SearchException se) {
            throw new SystemException((Throwable)se);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstanceToken updateKaleoInstanceToken(long kaleoInstanceTokenId, long currentKaleoNodeId) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.findByPrimaryKey(kaleoInstanceTokenId);
        this.setCurrentKaleoNode(kaleoInstanceToken, currentKaleoNodeId);
        return (KaleoInstanceToken)this.kaleoInstanceTokenPersistence.update((BaseModel)kaleoInstanceToken);
    }

    protected SearchContext buildSearchContext(KaleoInstanceTokenQuery kaleoInstanceTokenQuery, int start, int end, Sort[] sorts, ServiceContext serviceContext) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("kaleoInstanceTokenQuery", (Serializable)kaleoInstanceTokenQuery);
        searchContext.setCompanyId(kaleoInstanceTokenQuery.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setStart(start);
        if (sorts != null) {
            searchContext.setSorts(sorts);
        }
        searchContext.setUserId(serviceContext.getUserId());
        return searchContext;
    }

    protected void setCurrentKaleoNode(KaleoInstanceToken kaleoInstanceToken, long currentKaleoNodeId) throws PortalException {
        kaleoInstanceToken.setCurrentKaleoNodeId(currentKaleoNodeId);
        KaleoNode currentKaleoNode = this.kaleoNodeLocalService.getKaleoNode(currentKaleoNodeId);
        kaleoInstanceToken.setCurrentKaleoNodeName(currentKaleoNode.getName());
    }
}

