/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.exception.NoSuchInstanceException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.base.KaleoInstanceLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class KaleoInstanceLocalServiceImpl
extends KaleoInstanceLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(KaleoInstanceLocalServiceImpl.class);
    private static final Map<String, String> _fieldNameOrderByCols = new HashMap<String, String>(){
        {
            this.put("completed", KaleoInstanceLocalServiceImpl._getSortableFieldName("completed", "String"));
            this.put("completionDate", KaleoInstanceLocalServiceImpl._getSortableFieldName("completionDate", "Number"));
            this.put("createDate", KaleoInstanceLocalServiceImpl._getSortableFieldName("createDate", "Number"));
            this.put("kaleoInstanceId", KaleoInstanceLocalServiceImpl._getSortableFieldName("kaleoInstanceId", "Number"));
            this.put("modifiedDate", KaleoInstanceLocalServiceImpl._getSortableFieldName("modified", "Number"));
            this.put("state", KaleoInstanceLocalServiceImpl._getSortableFieldName("currentKaleoNodeName", "String"));
        }
    };
    private static final Map<String, Integer> _fieldNameSortTypes = new HashMap<String, Integer>(){
        {
            this.put("createDate", 6);
            this.put("modified", 6);
            this.put("completionDate", 6);
        }
    };

    public KaleoInstance addKaleoInstance(long kaleoDefinitionVersionId, String kaleoDefinitionName, int kaleoDefinitionVersion, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.fetchUser(serviceContext.getUserId());
        if (user == null) {
            user = this.userLocalService.getDefaultUser(serviceContext.getCompanyId());
        }
        Date now = new Date();
        long kaleoInstanceId = this.counterLocalService.increment();
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.create(kaleoInstanceId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoInstance.setGroupId(groupId);
        kaleoInstance.setCompanyId(user.getCompanyId());
        kaleoInstance.setUserId(user.getUserId());
        kaleoInstance.setUserName(user.getFullName());
        kaleoInstance.setCreateDate(now);
        kaleoInstance.setModifiedDate(now);
        kaleoInstance.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoInstance.setKaleoDefinitionName(kaleoDefinitionName);
        kaleoInstance.setKaleoDefinitionVersion(kaleoDefinitionVersion);
        kaleoInstance.setClassName((String)((Object)workflowContext.get("entryClassName")));
        if (workflowContext.containsKey("entryClassPK")) {
            kaleoInstance.setClassPK(GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK")))));
        }
        kaleoInstance.setCompleted(false);
        kaleoInstance.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
        return kaleoInstance;
    }

    public KaleoInstance completeKaleoInstance(long kaleoInstanceId) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setCompleted(true);
        kaleoInstance.setCompletionDate(new Date());
        this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
        return kaleoInstance;
    }

    public void deleteCompanyKaleoInstances(long companyId) {
        for (KaleoInstance kaleoInstance : this.kaleoInstancePersistence.findByCompanyId(companyId)) {
            this.kaleoInstanceLocalService.deleteKaleoInstance(kaleoInstance);
        }
        this.kaleoInstanceTokenLocalService.deleteCompanyKaleoInstanceTokens(companyId);
        this.kaleoLogLocalService.deleteCompanyKaleoLogs(companyId);
        this.kaleoTaskInstanceTokenLocalService.deleteCompanyKaleoTaskInstanceTokens(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoInstances(long kaleoDefinitionVersionId) {
        for (KaleoInstance kaleoInstance : this.kaleoInstancePersistence.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId)) {
            this.kaleoInstanceLocalService.deleteKaleoInstance(kaleoInstance);
        }
        this.kaleoInstanceTokenLocalService.deleteKaleoDefinitionVersionKaleoInstanceTokens(kaleoDefinitionVersionId);
        this.kaleoLogLocalService.deleteKaleoDefinitionVersionKaleoLogs(kaleoDefinitionVersionId);
        this.kaleoTaskInstanceTokenLocalService.deleteKaleoDefinitionVersionKaleoTaskInstanceTokens(kaleoDefinitionVersionId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public KaleoInstance deleteKaleoInstance(long kaleoInstanceId) {
        KaleoInstance kaleoInstance = null;
        try {
            kaleoInstance = this.kaleoInstancePersistence.remove(kaleoInstanceId);
        }
        catch (NoSuchInstanceException nsie) {
            return null;
        }
        this.kaleoInstanceTokenLocalService.deleteKaleoInstanceKaleoInstanceTokens(kaleoInstanceId);
        this.kaleoLogLocalService.deleteKaleoInstanceKaleoLogs(kaleoInstanceId);
        this.kaleoTaskInstanceTokenLocalService.deleteKaleoInstanceKaleoTaskInstanceTokens(kaleoInstanceId);
        this.kaleoTimerInstanceTokenLocalService.deleteKaleoTimerInstanceTokens(kaleoInstanceId);
        return kaleoInstance;
    }

    public List<KaleoInstance> getKaleoInstances(Long userId, String assetClassName, Long assetClassPK, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(userId, assetClassName, assetClassPK, completed, serviceContext);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public List<KaleoInstance> getKaleoInstances(Long userId, String[] assetClassNames, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(userId, assetClassNames, null, completed, serviceContext);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public List<KaleoInstance> getKaleoInstances(String kaleoDefinitionName, int kaleoDefinitionVersion, boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(kaleoDefinitionName, kaleoDefinitionVersion, completed, serviceContext);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public int getKaleoInstancesCount(long kaleoDefinitionVersionId, boolean completed) {
        return this.kaleoInstancePersistence.countByKDVI_C(kaleoDefinitionVersionId, completed);
    }

    public int getKaleoInstancesCount(Long userId, String assetClassName, Long assetClassPK, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(userId, assetClassName, assetClassPK, completed, serviceContext);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public int getKaleoInstancesCount(Long userId, String[] assetClassNames, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(userId, assetClassNames, null, completed, serviceContext);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public int getKaleoInstancesCount(String kaleoDefinitionName, int kaleoDefinitionVersion, boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(kaleoDefinitionName, kaleoDefinitionVersion, completed, serviceContext);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    @Deprecated
    public List<KaleoInstance> search(Long userId, String assetClassName, String nodeName, String kaleoDefinitionName, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        return this.search(userId, assetClassName, null, null, nodeName, kaleoDefinitionName, completed, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoInstance> search(Long userId, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        try {
            ArrayList<KaleoInstance> kaleoInstances = new ArrayList<KaleoInstance>();
            Hits hits = this.kaleoInstanceTokenLocalService.search(userId, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, start, end, this.getSortsFromComparator(orderByComparator), serviceContext);
            for (Document document : hits.getDocs()) {
                long kaleoInstanceId = GetterUtil.getLong((String)document.get("kaleoInstanceId"));
                kaleoInstances.add(this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId));
            }
            return kaleoInstances;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return Collections.emptyList();
        }
    }

    @Deprecated
    public int searchCount(Long userId, String assetClassName, String nodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) {
        return this.searchCount(userId, assetClassName, null, null, nodeName, kaleoDefinitionName, completed, serviceContext);
    }

    public int searchCount(Long userId, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) {
        return this.kaleoInstanceTokenLocalService.searchCount(userId, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, serviceContext);
    }

    public KaleoInstance updateKaleoInstance(long kaleoInstanceId, long rootKaleoInstanceTokenId) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setRootKaleoInstanceTokenId(rootKaleoInstanceTokenId);
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    public KaleoInstance updateKaleoInstance(long kaleoInstanceId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    protected DynamicQuery buildDynamicQuery(Long userId, String assetClassName, Long assetClassPK, Boolean completed, ServiceContext serviceContext) {
        String[] assetClassNames = null;
        if (Validator.isNotNull((String)assetClassName)) {
            assetClassNames = new String[]{assetClassName};
        }
        Long[] assetClassPKs = null;
        if (Validator.isNotNull((Long)assetClassPK)) {
            assetClassPKs = new Long[]{assetClassPK};
        }
        return this.buildDynamicQuery(userId, assetClassNames, assetClassPKs, completed, serviceContext);
    }

    protected DynamicQuery buildDynamicQuery(Long userId, String[] assetClassNames, Long[] assetClassPKs, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoInstance.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        if (userId != null) {
            Property userIdProperty = PropertyFactoryUtil.forName((String)"userId");
            dynamicQuery.add(userIdProperty.eq((Object)userId));
        }
        if (ArrayUtil.isNotEmpty((Object[])assetClassNames)) {
            dynamicQuery.add(this.getAssetClassNames(assetClassNames));
        }
        if (ArrayUtil.isNotEmpty((Object[])assetClassPKs)) {
            dynamicQuery.add(this.getAssetClassPKs(assetClassPKs));
        }
        if (completed != null) {
            Property completionDateProperty;
            if (completed.booleanValue()) {
                completionDateProperty = PropertyFactoryUtil.forName((String)"completionDate");
                dynamicQuery.add(completionDateProperty.isNotNull());
            } else {
                completionDateProperty = PropertyFactoryUtil.forName((String)"completionDate");
                dynamicQuery.add(completionDateProperty.isNull());
            }
        }
        return dynamicQuery;
    }

    protected DynamicQuery buildDynamicQuery(String kaleoDefinitionName, int kaleoDefinitionVersion, boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoInstance.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        Property kaleoDefinitionNameProperty = PropertyFactoryUtil.forName((String)"kaleoDefinitionName");
        dynamicQuery.add(kaleoDefinitionNameProperty.eq((Object)kaleoDefinitionName));
        Property kaleoDefinitionVersionProperty = PropertyFactoryUtil.forName((String)"kaleoDefinitionVersion");
        dynamicQuery.add(kaleoDefinitionVersionProperty.eq((Object)kaleoDefinitionVersion));
        if (completed) {
            Property completionDateProperty = PropertyFactoryUtil.forName((String)"completionDate");
            dynamicQuery.add(completionDateProperty.isNotNull());
        } else {
            Property completionDateProperty = PropertyFactoryUtil.forName((String)"completionDate");
            dynamicQuery.add(completionDateProperty.isNull());
        }
        return dynamicQuery;
    }

    protected Criterion getAssetClassNames(String[] assetClassNames) {
        Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
        for (String assetClassName : assetClassNames) {
            Property classNameProperty = PropertyFactoryUtil.forName((String)"className");
            disjunction.add(classNameProperty.like((Object)assetClassName));
        }
        return disjunction;
    }

    protected Criterion getAssetClassPKs(Long[] assetClassPKs) {
        Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
        for (Long assetClassPK : assetClassPKs) {
            Property classPKProperty = PropertyFactoryUtil.forName((String)"classPK");
            disjunction.add(classPKProperty.eq((Object)assetClassPK));
        }
        return disjunction;
    }

    protected Sort[] getSortsFromComparator(OrderByComparator<KaleoInstance> orderByComparator) {
        Stream<String> stream = Arrays.stream(orderByComparator.getOrderByFields());
        return (Sort[])stream.map(orderByFieldName -> {
            String fieldName = _fieldNameOrderByCols.getOrDefault(orderByFieldName, (String)orderByFieldName);
            int sortType = _fieldNameSortTypes.getOrDefault(fieldName, 3);
            boolean ascending = orderByComparator.isAscending();
            if (Objects.equals(orderByFieldName, "completed")) {
                ascending = true;
            }
            return new Sort(fieldName, sortType, !ascending);
        }).toArray(Sort[]::new);
    }

    private static String _getSortableFieldName(String name, String type) {
        return Field.getSortableFieldName((String)StringBundler.concat((String[])new String[]{name, "_", type}));
    }
}

