/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.service.base.KaleoDefinitionVersionLocalServiceBaseImpl;
import com.liferay.portal.workflow.kaleo.util.comparator.KaleoDefinitionVersionIdComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class KaleoDefinitionVersionLocalServiceImpl
extends KaleoDefinitionVersionLocalServiceBaseImpl {
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public KaleoDefinitionVersion addKaleoDefinitionVersion(String name, String title, String description, String content, String version, ServiceContext serviceContext) throws PortalException {
        Date createDate = serviceContext.getCreateDate(new Date());
        Date modifiedDate = serviceContext.getModifiedDate(new Date());
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        long kaleoDefinitionVersionId = this.counterLocalService.increment();
        KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionPersistence.create(kaleoDefinitionVersionId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoDefinitionVersion.setGroupId(groupId);
        kaleoDefinitionVersion.setCompanyId(user.getCompanyId());
        kaleoDefinitionVersion.setUserId(user.getUserId());
        kaleoDefinitionVersion.setUserName(user.getFullName());
        kaleoDefinitionVersion.setCreateDate(createDate);
        kaleoDefinitionVersion.setModifiedDate(modifiedDate);
        kaleoDefinitionVersion.setName(name);
        kaleoDefinitionVersion.setTitle(title);
        kaleoDefinitionVersion.setDescription(description);
        kaleoDefinitionVersion.setContent(content);
        kaleoDefinitionVersion.setVersion(version);
        int status = GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0);
        kaleoDefinitionVersion.setStatus(status);
        kaleoDefinitionVersion.setStatusByUserId(user.getUserId());
        kaleoDefinitionVersion.setStatusByUserName(user.getFullName());
        kaleoDefinitionVersion.setStatusDate(modifiedDate);
        this.kaleoDefinitionVersionPersistence.update((BaseModel)kaleoDefinitionVersion);
        return kaleoDefinitionVersion;
    }

    @Override
    public KaleoDefinitionVersion deleteKaleoDefinitionVersion(KaleoDefinitionVersion kaleoDefinitionVersion) throws PortalException {
        if (kaleoDefinitionVersion.hasIncompleteKaleoInstances()) {
            throw new WorkflowException("Cannot delete incomplete workflow definition version" + kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        }
        this.kaleoDefinitionVersionPersistence.remove((BaseModel)kaleoDefinitionVersion);
        this.kaleoConditionLocalService.deleteKaleoDefinitionVersionKaleoCondition(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        this.kaleoInstanceLocalService.deleteKaleoDefinitionVersionKaleoInstances(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        this.kaleoNodeLocalService.deleteKaleoDefinitionVersionKaleoNodes(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        this.kaleoTaskLocalService.deleteKaleoDefinitionVersionKaleoTasks(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        this.kaleoTransitionLocalService.deleteKaleoDefinitionVersionKaleoTransitions(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        return kaleoDefinitionVersion;
    }

    public void deleteKaleoDefinitionVersion(long companyId, String name, String version) throws PortalException {
        KaleoDefinitionVersion kaleoDefinitionVersion = this.getKaleoDefinitionVersion(companyId, name, version);
        this.deleteKaleoDefinitionVersion(kaleoDefinitionVersion);
    }

    public void deleteKaleoDefinitionVersions(List<KaleoDefinitionVersion> kaleoDefinitionVersions) throws PortalException {
        for (KaleoDefinitionVersion kaleoDefinitionVersion : kaleoDefinitionVersions) {
            this.deleteKaleoDefinitionVersion(kaleoDefinitionVersion);
        }
    }

    public void deleteKaleoDefinitionVersions(long companyId, String name) throws PortalException {
        List<KaleoDefinitionVersion> kaleoDefinitionVersions = this.getKaleoDefinitionVersions(companyId, name);
        this.deleteKaleoDefinitionVersions(kaleoDefinitionVersions);
    }

    public KaleoDefinitionVersion fetchKaleoDefinitionVersion(long companyId, String name, String version) {
        return this.kaleoDefinitionVersionPersistence.fetchByC_N_V(companyId, name, version);
    }

    public KaleoDefinitionVersion fetchLatestKaleoDefinitionVersion(long companyId, String name) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.fetchByC_N_First(companyId, name, (OrderByComparator)new KaleoDefinitionVersionIdComparator(false));
    }

    public KaleoDefinitionVersion fetchLatestKaleoDefinitionVersion(long companyId, String name, OrderByComparator<KaleoDefinitionVersion> orderByComparator) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.fetchByC_N_Last(companyId, name, orderByComparator);
    }

    public KaleoDefinitionVersion getFirstKaleoDefinitionVersion(long companyId, String name) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.findByC_N_First(companyId, name, (OrderByComparator)new KaleoDefinitionVersionIdComparator(true));
    }

    public KaleoDefinitionVersion getKaleoDefinitionVersion(long companyId, String name, String version) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.findByC_N_V(companyId, name, version);
    }

    public List<KaleoDefinitionVersion> getKaleoDefinitionVersions(long companyId, int start, int end, OrderByComparator<KaleoDefinitionVersion> orderByComparator) {
        return this.kaleoDefinitionVersionPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public List<KaleoDefinitionVersion> getKaleoDefinitionVersions(long companyId, String name) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.findByC_N(companyId, name);
    }

    public List<KaleoDefinitionVersion> getKaleoDefinitionVersions(long companyId, String name, int start, int end, OrderByComparator<KaleoDefinitionVersion> orderByComparator) {
        return this.kaleoDefinitionVersionPersistence.findByC_N(companyId, name, start, end, orderByComparator);
    }

    public int getKaleoDefinitionVersionsCount(long companyId) {
        return this.kaleoDefinitionVersionPersistence.countByCompanyId(companyId);
    }

    public int getKaleoDefinitionVersionsCount(long companyId, String name) {
        return this.kaleoDefinitionVersionPersistence.countByC_N(companyId, name);
    }

    public KaleoDefinitionVersion[] getKaleoDefinitionVersionsPrevAndNext(long companyId, String name, String version) throws PortalException {
        KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionPersistence.findByC_N_V(companyId, name, version);
        return this.kaleoDefinitionVersionPersistence.findByC_N_PrevAndNext(kaleoDefinitionVersion.getKaleoDefinitionVersionId(), companyId, name, (OrderByComparator)new KaleoDefinitionVersionIdComparator(true));
    }

    public KaleoDefinitionVersion getLatestKaleoDefinitionVersion(long companyId, String name) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.findByC_N_First(companyId, name, (OrderByComparator)new KaleoDefinitionVersionIdComparator(false));
    }

    public List<KaleoDefinitionVersion> getLatestKaleoDefinitionVersions(long companyId, int start, int end, OrderByComparator<KaleoDefinitionVersion> orderByComparator) {
        return this.getLatestKaleoDefinitionVersions(companyId, null, -1, start, end, orderByComparator);
    }

    public List<KaleoDefinitionVersion> getLatestKaleoDefinitionVersions(long companyId, String keywords, int status, int start, int end, OrderByComparator<KaleoDefinitionVersion> orderByComparator) {
        List<Long> kaleoDefinitionVersionIds = this.getKaleoDefinitionVersionIds(companyId, keywords, status);
        if (kaleoDefinitionVersionIds.isEmpty()) {
            return Collections.emptyList();
        }
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoDefinitionVersion.class, (ClassLoader)this.getClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"kaleoDefinitionVersionId");
        dynamicQuery.add(property.in(kaleoDefinitionVersionIds));
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public int getLatestKaleoDefinitionVersionsCount(long companyId, String keywords, int status) {
        List<Long> kaleoDefinitionVersionIds = this.getKaleoDefinitionVersionIds(companyId, keywords, status);
        return kaleoDefinitionVersionIds.size();
    }

    protected void addKeywordsCriterion(DynamicQuery dynamicQuery, String keywords) {
        if (Validator.isNull((String)keywords)) {
            return;
        }
        Disjunction junction = RestrictionsFactoryUtil.disjunction();
        for (String keyword : this._customSQL.keywords(keywords)) {
            junction.add(RestrictionsFactoryUtil.ilike((String)"name", (Object)keyword));
            junction.add(RestrictionsFactoryUtil.ilike((String)"title", (Object)keyword));
        }
        dynamicQuery.add((Criterion)junction);
    }

    protected void addStatusCriterion(DynamicQuery dynamicQuery, int status) {
        if (status != -1) {
            Disjunction junction = RestrictionsFactoryUtil.disjunction();
            junction.add(RestrictionsFactoryUtil.eq((String)"status", (Object)status));
            dynamicQuery.add((Criterion)junction);
        }
    }

    protected List<Long> getKaleoDefinitionVersionIds(long companyId, String keywords, int status) {
        ArrayList<Long> kaleoDefinitionVersionIds = new ArrayList<Long>();
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoDefinitionVersion.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        this.addKeywordsCriterion(dynamicQuery, keywords);
        this.addStatusCriterion(dynamicQuery, status);
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(ProjectionFactoryUtil.max((String)"kaleoDefinitionVersionId"));
        projectionList.add(ProjectionFactoryUtil.groupProperty((String)"name"));
        dynamicQuery.setProjection((Projection)projectionList);
        List results = this.dynamicQuery(dynamicQuery);
        for (Object[] result : results) {
            kaleoDefinitionVersionIds.add((Long)result[0]);
        }
        return kaleoDefinitionVersionIds;
    }
}

