/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.service.base.KaleoDefinitionLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class KaleoDefinitionLocalServiceImpl
extends KaleoDefinitionLocalServiceBaseImpl {
    public void activateKaleoDefinition(long kaleoDefinitionId, long kaleoDefinitionVersionId, long startKaleoNodeId, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.findByPrimaryKey(kaleoDefinitionId);
        kaleoDefinition.setModifiedDate(new Date());
        kaleoDefinition.setActive(true);
        this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
        KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionPersistence.findByPrimaryKey(kaleoDefinitionVersionId);
        kaleoDefinitionVersion.setModifiedDate(new Date());
        kaleoDefinitionVersion.setStartKaleoNodeId(startKaleoNodeId);
        this.kaleoDefinitionVersionPersistence.update((BaseModel)kaleoDefinitionVersion);
    }

    public void activateKaleoDefinition(long kaleoDefinitionId, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.findByPrimaryKey(kaleoDefinitionId);
        kaleoDefinition.setModifiedDate(new Date());
        kaleoDefinition.setActive(true);
        this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
    }

    public void activateKaleoDefinition(String name, int version, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.findByC_N_V(serviceContext.getCompanyId(), name, version);
        kaleoDefinition.setModifiedDate(new Date());
        kaleoDefinition.setActive(true);
        this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
    }

    public KaleoDefinition addKaleoDefinition(String name, String title, String description, String content, int version, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoDefinitionId = this.counterLocalService.increment();
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.create(kaleoDefinitionId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoDefinition.setGroupId(groupId);
        kaleoDefinition.setCompanyId(user.getCompanyId());
        kaleoDefinition.setUserId(user.getUserId());
        kaleoDefinition.setUserName(user.getFullName());
        kaleoDefinition.setCreateDate(now);
        kaleoDefinition.setModifiedDate(now);
        kaleoDefinition.setName(name);
        kaleoDefinition.setTitle(title);
        kaleoDefinition.setDescription(description);
        kaleoDefinition.setContent(content);
        kaleoDefinition.setVersion(version);
        kaleoDefinition.setActive(false);
        this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
        this.kaleoDefinitionVersionLocalService.addKaleoDefinitionVersion(name, title, description, content, this.getVersion(version), serviceContext);
        return kaleoDefinition;
    }

    public void deactivateKaleoDefinition(String name, int version, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.findByC_N_V(serviceContext.getCompanyId(), name, version);
        kaleoDefinition.setModifiedDate(new Date());
        kaleoDefinition.setActive(false);
        this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
    }

    public void deleteCompanyKaleoDefinitions(long companyId) {
        this.kaleoDefinitionPersistence.removeByCompanyId(companyId);
        this.kaleoDefinitionVersionPersistence.removeByCompanyId(companyId);
        this.kaleoConditionLocalService.deleteCompanyKaleoConditions(companyId);
        this.kaleoInstanceLocalService.deleteCompanyKaleoInstances(companyId);
        this.kaleoNodeLocalService.deleteCompanyKaleoNodes(companyId);
        this.kaleoTaskLocalService.deleteCompanyKaleoTasks(companyId);
        this.kaleoTransitionLocalService.deleteCompanyKaleoTransitions(companyId);
    }

    public void deleteKaleoDefinition(String name, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this.getKaleoDefinition(name, serviceContext);
        if (kaleoDefinition.isActive()) {
            throw new WorkflowException("Cannot delete active workflow definition " + kaleoDefinition.getKaleoDefinitionId());
        }
        this.kaleoDefinitionPersistence.remove((BaseModel)kaleoDefinition);
        this.kaleoDefinitionVersionLocalService.deleteKaleoDefinitionVersions(kaleoDefinition.getKaleoDefinitionVersions());
    }

    public KaleoDefinition fetchKaleoDefinition(String name, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.fetchByC_N(serviceContext.getCompanyId(), name);
    }

    public KaleoDefinition getKaleoDefinition(String name, ServiceContext serviceContext) throws PortalException {
        return this.kaleoDefinitionPersistence.findByC_N(serviceContext.getCompanyId(), name);
    }

    public List<KaleoDefinition> getKaleoDefinitions(boolean active, int start, int end, OrderByComparator<KaleoDefinition> orderByComparator, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.findByC_A(serviceContext.getCompanyId(), active, start, end, orderByComparator);
    }

    public List<KaleoDefinition> getKaleoDefinitions(int start, int end, OrderByComparator<KaleoDefinition> orderByComparator, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.findByCompanyId(serviceContext.getCompanyId(), start, end, orderByComparator);
    }

    public int getKaleoDefinitionsCount(boolean active, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.countByC_A(serviceContext.getCompanyId(), active);
    }

    public int getKaleoDefinitionsCount(ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.countByCompanyId(serviceContext.getCompanyId());
    }

    public int getKaleoDefinitionsCount(String name, boolean active, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.countByC_N_A(serviceContext.getCompanyId(), name, active);
    }

    public int getKaleoDefinitionsCount(String name, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.countByC_N(serviceContext.getCompanyId(), name);
    }

    public KaleoDefinition updatedKaleoDefinition(long kaleoDefinitionId, String title, String description, String content, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.findByPrimaryKey(kaleoDefinitionId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoDefinition.setGroupId(groupId);
        kaleoDefinition.setUserId(user.getUserId());
        kaleoDefinition.setUserName(user.getFullName());
        kaleoDefinition.setCreateDate(now);
        kaleoDefinition.setModifiedDate(now);
        kaleoDefinition.setTitle(title);
        kaleoDefinition.setDescription(description);
        kaleoDefinition.setContent(content);
        int nextVersion = kaleoDefinition.getVersion() + 1;
        kaleoDefinition.setVersion(nextVersion);
        kaleoDefinition.setActive(false);
        this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
        this.kaleoDefinitionVersionLocalService.addKaleoDefinitionVersion(kaleoDefinition.getName(), title, description, content, this.getVersion(nextVersion), serviceContext);
        return kaleoDefinition;
    }

    protected String getVersion(int version) {
        return version + "." + 0;
    }
}

