/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v1_3_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WorkflowContextUpgradeHelper {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowContextUpgradeHelper.class);
    private static final Map<String, String> _classNamesMap = new HashMap<String, String>(){
        {
            this.put("com.liferay.portal.model.Company", "com.liferay.portal.kernel.model.Company");
            this.put("com.liferay.portal.model.Group", "com.liferay.portal.kernel.model.Group");
            this.put("com.liferay.portal.model.LayoutRevision", "com.liferay.portal.kernel.model.LayoutRevision");
            this.put("com.liferay.portal.model.Role", "com.liferay.portal.kernel.model.Role");
            this.put("com.liferay.portal.model.User", "com.liferay.portal.kernel.model.User");
            this.put("com.liferay.portal.model.UserGroup", "com.liferay.portal.kernel.model.UserGroup");
            this.put("com.liferay.portlet.blogs.model.BlogsEntry", "com.liferay.blogs.kernel.model.BlogsEntry");
            this.put("com.liferay.portlet.documentlibrary.model.DLFileEntry", "com.liferay.document.library.kernel.model.DLFileEntry");
            this.put("com.liferay.portlet.dynamicdatalists.model.DDLRecord", "com.liferay.dynamic.data.lists.model.DDLRecord");
            this.put("com.liferay.portlet.journal.model.JournalArticle", "com.liferay.journal.model.JournalArticle");
            this.put("com.liferay.portlet.messageboards.model.MBDiscussion", "com.liferay.message.boards.kernel.model.MBDiscussion");
            this.put("com.liferay.portlet.messageboards.model.MBMessage", "com.liferay.message.boards.kernel.model.MBMessage");
            this.put("com.liferay.portlet.wiki.model.WikiPage", "com.liferay.wiki.model.WikiPage");
        }
    };
    private static final Pattern _javaClassPattern = Pattern.compile("\"javaClass\":\"(com.liferay.portal.[^\"]+)\"");

    public Set<Map.Entry<String, String>> getRenamedClassNamesEntrySet() {
        return _classNamesMap.entrySet();
    }

    public Map<String, Serializable> renameEntryClassName(Map<String, Serializable> workflowContext) {
        HashMap<String, Serializable> newWorkflowContext = new HashMap<String, Serializable>(workflowContext);
        String oldEntryClassName = (String)((Object)workflowContext.get("entryClassName"));
        String newEntryClassName = _classNamesMap.get(oldEntryClassName);
        if (newEntryClassName != null) {
            newWorkflowContext.put("entryClassName", (Serializable)((Object)newEntryClassName));
        }
        return newWorkflowContext;
    }

    public String renamePortalClassNames(String workflowContextJSON) {
        Matcher matcher = _javaClassPattern.matcher(workflowContextJSON);
        TreeSet<String> oldSubs = new TreeSet<String>();
        TreeSet<String> newSubs = new TreeSet<String>();
        while (matcher.find()) {
            String oldPortalJavaClassName = matcher.group(1);
            if (oldPortalJavaClassName.contains(".impl") || oldPortalJavaClassName.contains(".kernel") || oldSubs.contains(oldPortalJavaClassName)) continue;
            oldSubs.add("\"javaClass\":\"" + oldPortalJavaClassName + "\"");
            String newPortalJavaClassName = StringUtil.replace((String)oldPortalJavaClassName, (String)"com.liferay.portal", (String)"com.liferay.portal.kernel");
            newSubs.add("\"javaClass\":\"" + newPortalJavaClassName + "\"");
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)String.format("Workflow context Java class name renamed from \"%s\" to \"%s\"", oldPortalJavaClassName, newPortalJavaClassName));
        }
        if (oldSubs.isEmpty()) {
            return workflowContextJSON;
        }
        return StringUtil.replace((String)workflowContextJSON, (String[])ArrayUtil.toStringArray(oldSubs), (String[])ArrayUtil.toStringArray(newSubs));
    }

    protected boolean isEntryClassNameRenamed(Map<String, Serializable> workflowContext) {
        String oldEntryClassName = (String)((Object)workflowContext.get("entryClassName"));
        return _classNamesMap.get(oldEntryClassName) != null;
    }
}

