/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.filter.DateRangeFilterBuilder;
import com.liferay.portal.search.filter.FilterBuilders;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTaskInstanceTokenQuery;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken"}, service={ModelPreFilterContributor.class})
public class KaleoTaskInstanceTokenModelPreFilterContributor
implements ModelPreFilterContributor {
    @Reference
    protected FilterBuilders filterBuilders;
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected Portal portal;
    @Reference
    protected RoleLocalService roleLocalService;
    @Reference
    protected UserGroupGroupRoleLocalService userGroupGroupRoleLocalService;
    @Reference
    protected UserGroupLocalService userGroupLocalService;
    @Reference
    protected UserGroupRoleLocalService userGroupRoleLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(KaleoTaskInstanceTokenModelPreFilterContributor.class);

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = (KaleoTaskInstanceTokenQuery)searchContext.getAttribute("kaleoTaskInstanceTokenQuery");
        if (kaleoTaskInstanceTokenQuery == null) {
            return;
        }
        this.appendAssigneeClassIdsNameTerm(booleanFilter, kaleoTaskInstanceTokenQuery);
        this.appendAssigneeClassPKsTerm(booleanFilter, kaleoTaskInstanceTokenQuery);
        this.appendCompletedTerm(booleanFilter, kaleoTaskInstanceTokenQuery);
        this.appendKaleoInstanceIdTerm(booleanFilter, kaleoTaskInstanceTokenQuery);
        this.appendRoleIdsTerm(booleanFilter, kaleoTaskInstanceTokenQuery);
        this.appendSearchByUserRolesTerm(booleanFilter, kaleoTaskInstanceTokenQuery);
        if (this.appendSearchCriteria(kaleoTaskInstanceTokenQuery)) {
            this.appendAssetPrimaryKeyTerm(booleanFilter, kaleoTaskInstanceTokenQuery);
            this.appendAssetTypeTerm(booleanFilter, kaleoTaskInstanceTokenQuery);
            this.appendDueDateRangeTerm(booleanFilter, kaleoTaskInstanceTokenQuery);
        }
    }

    protected void appendAssetPrimaryKeyTerm(BooleanFilter booleanFilter, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Object[] assetPrimaryKeys = kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys();
        if (ArrayUtil.isEmpty((Object[])assetPrimaryKeys)) {
            return;
        }
        for (Object assetPrimaryKey : assetPrimaryKeys) {
            booleanFilter.addTerm("classPK", (Long)assetPrimaryKey);
        }
    }

    protected void appendAssetTypeTerm(BooleanFilter booleanFilter, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Object[] assetTypes = kaleoTaskInstanceTokenQuery.getAssetTypes();
        if (ArrayUtil.isEmpty((Object[])assetTypes)) {
            return;
        }
        for (Object assetType : assetTypes) {
            booleanFilter.addTerm("className", (String)assetType);
        }
    }

    protected void appendAssigneeClassIdsNameTerm(BooleanFilter booleanFilter, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        String assigneeClassName = kaleoTaskInstanceTokenQuery.getAssigneeClassName();
        if (Validator.isNull((String)assigneeClassName)) {
            return;
        }
        TermFilter assigneeClassNameIdsTermFilter = new TermFilter("assigneeClassNameIds", String.valueOf(this.portal.getClassNameId(assigneeClassName)));
        booleanFilter.add((Filter)assigneeClassNameIdsTermFilter, BooleanClauseOccur.MUST);
    }

    protected void appendAssigneeClassPKsTerm(BooleanFilter booleanFilter, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Long assigneeClassPK = kaleoTaskInstanceTokenQuery.getAssigneeClassPK();
        if (assigneeClassPK == null) {
            return;
        }
        TermFilter assigneeClassPKsTermFilter = new TermFilter("assigneeClassPKs", String.valueOf(assigneeClassPK));
        booleanFilter.add((Filter)assigneeClassPKsTermFilter, BooleanClauseOccur.MUST);
    }

    protected void appendCompletedTerm(BooleanFilter booleanFilter, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Boolean completed = kaleoTaskInstanceTokenQuery.isCompleted();
        if (completed == null) {
            return;
        }
        booleanFilter.addRequiredTerm("completed", completed);
    }

    protected void appendDueDateRangeTerm(BooleanFilter booleanFilter, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Date dueDateGT = kaleoTaskInstanceTokenQuery.getDueDateGT();
        Date dueDateLT = kaleoTaskInstanceTokenQuery.getDueDateLT();
        if (dueDateGT == null && dueDateLT == null) {
            return;
        }
        String formatPattern = PropsUtil.get((String)"index.date.format.pattern");
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)formatPattern);
        DateRangeFilterBuilder dueDateRangeFilterBuilder = this.filterBuilders.dateRangeFilterBuilder();
        dueDateRangeFilterBuilder.setFieldName("dueDate");
        if (dueDateGT != null) {
            dueDateRangeFilterBuilder.setFrom(dateFormat.format(dueDateGT));
        }
        if (dueDateLT != null) {
            dueDateRangeFilterBuilder.setTo(dateFormat.format(dueDateLT));
        }
        booleanFilter.add((Filter)dueDateRangeFilterBuilder.build(), BooleanClauseOccur.MUST);
    }

    protected void appendKaleoInstanceIdTerm(BooleanFilter booleanFilter, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Long kaleoInstanceId = kaleoTaskInstanceTokenQuery.getKaleoInstanceId();
        if (kaleoInstanceId == null) {
            return;
        }
        booleanFilter.addRequiredTerm("kaleoInstanceId", kaleoInstanceId);
    }

    protected void appendRoleIdsTerm(BooleanFilter booleanFilter, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Boolean searchByUserRoles = kaleoTaskInstanceTokenQuery.isSearchByUserRoles();
        if (searchByUserRoles != null) {
            return;
        }
        List roleIds = kaleoTaskInstanceTokenQuery.getRoleIds();
        if (ListUtil.isEmpty((List)roleIds)) {
            return;
        }
        BooleanFilter roleIdsBooleanFilter = new BooleanFilter();
        for (Long roleId : roleIds) {
            roleIdsBooleanFilter.add((Filter)new TermFilter("assigneeClassPKs", roleId.toString()), BooleanClauseOccur.SHOULD);
        }
        booleanFilter.add((Filter)roleIdsBooleanFilter, BooleanClauseOccur.MUST);
    }

    protected void appendSearchByUserRolesTerm(BooleanFilter booleanFilter, KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        Boolean searchByUserRoles = kaleoTaskInstanceTokenQuery.isSearchByUserRoles();
        if (searchByUserRoles == null) {
            return;
        }
        if (searchByUserRoles.booleanValue()) {
            List<Long> roleIds = this.getSearchByUserRoleIds(kaleoTaskInstanceTokenQuery.getUserId());
            Map<Long, Set<Long>> roleIdGroupIdsMap = this.getRoleIdGroupIdsMap(kaleoTaskInstanceTokenQuery);
            if (roleIds.isEmpty() && roleIdGroupIdsMap.isEmpty()) {
                return;
            }
            BooleanFilter searchByRolesBooleanFilter = new BooleanFilter();
            TermFilter rolesClassNameIdTermFilter = new TermFilter("assigneeClassNameIds", String.valueOf(this.portal.getClassNameId(Role.class)));
            searchByRolesBooleanFilter.add((Filter)rolesClassNameIdTermFilter, BooleanClauseOccur.MUST);
            BooleanFilter innerSearchByRolesBooleanFilter = new BooleanFilter();
            searchByRolesBooleanFilter.add((Filter)innerSearchByRolesBooleanFilter, BooleanClauseOccur.MUST);
            innerSearchByRolesBooleanFilter.add((Filter)this.createRoleAssigneeClassPKBooleanFilter(roleIds));
            if (!roleIdGroupIdsMap.isEmpty()) {
                BooleanFilter roleIdGroupIdsMapBooleanFilter = this.createRoleIdGroupIdsMapBooleanFilter(roleIdGroupIdsMap);
                BooleanClauseOccur roleIdGroupIdsMapBooleanClauseOccur = BooleanClauseOccur.SHOULD;
                if (roleIds.isEmpty()) {
                    roleIdGroupIdsMapBooleanClauseOccur = BooleanClauseOccur.MUST;
                }
                innerSearchByRolesBooleanFilter.add((Filter)roleIdGroupIdsMapBooleanFilter, roleIdGroupIdsMapBooleanClauseOccur);
            }
            booleanFilter.add((Filter)searchByRolesBooleanFilter, BooleanClauseOccur.MUST);
        } else {
            TermFilter assigneeClassNameIdsTermFilter = new TermFilter("assigneeClassNameIds", String.valueOf(this.portal.getClassNameId(User.class)));
            booleanFilter.add((Filter)assigneeClassNameIdsTermFilter, BooleanClauseOccur.MUST);
            TermFilter assigneeClassPKsTermFilter = new TermFilter("assigneeClassPKs", String.valueOf(kaleoTaskInstanceTokenQuery.getUserId()));
            booleanFilter.add((Filter)assigneeClassPKsTermFilter, BooleanClauseOccur.MUST);
        }
    }

    protected boolean appendSearchCriteria(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        if (ArrayUtil.isNotEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetPrimaryKeys())) {
            return true;
        }
        if (ArrayUtil.isNotEmpty((Object[])kaleoTaskInstanceTokenQuery.getAssetTypes())) {
            return true;
        }
        if (kaleoTaskInstanceTokenQuery.getDueDateGT() != null) {
            return true;
        }
        return kaleoTaskInstanceTokenQuery.getDueDateLT() != null;
    }

    protected BooleanFilter createRoleAssigneeClassPKBooleanFilter(List<Long> roleIds) {
        BooleanFilter roleClassPKBooleanFilter = new BooleanFilter();
        for (Long roleId : roleIds) {
            roleClassPKBooleanFilter.add((Filter)new TermFilter("assigneeClassPKs", String.valueOf(roleId)));
        }
        return roleClassPKBooleanFilter;
    }

    protected BooleanFilter createRoleIdGroupIdsMapBooleanFilter(Map<Long, Set<Long>> roleIdGroupIdsMap) {
        BooleanFilter roleIdGroupIdsMapBooleanFilter = new BooleanFilter();
        for (Map.Entry<Long, Set<Long>> entry : roleIdGroupIdsMap.entrySet()) {
            BooleanFilter roleIdGroupIdsBooleanFilter = new BooleanFilter();
            roleIdGroupIdsBooleanFilter.add((Filter)new TermFilter("assigneeClassPKs", String.valueOf(entry.getKey())), BooleanClauseOccur.MUST);
            BooleanFilter assigneeGroupIdsBooleanFilter = new BooleanFilter();
            for (Long assigneeGroupId : entry.getValue()) {
                assigneeGroupIdsBooleanFilter.add((Filter)new TermFilter("assigneeGroupIds", String.valueOf(assigneeGroupId)));
            }
            roleIdGroupIdsBooleanFilter.add((Filter)assigneeGroupIdsBooleanFilter, BooleanClauseOccur.MUST);
            roleIdGroupIdsMapBooleanFilter.add((Filter)roleIdGroupIdsBooleanFilter, BooleanClauseOccur.SHOULD);
        }
        return roleIdGroupIdsMapBooleanFilter;
    }

    protected Map<Long, Set<Long>> getRoleIdGroupIdsMap(KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery) {
        HashMap<Long, Set<Long>> roleIdGroupIdsMap = new HashMap<Long, Set<Long>>();
        List userGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(kaleoTaskInstanceTokenQuery.getUserId());
        for (UserGroupRole userGroupRole : userGroupRoles) {
            this.mapRoleIdGroupId(userGroupRole.getRoleId(), userGroupRole.getGroupId(), roleIdGroupIdsMap);
        }
        List<UserGroupGroupRole> userGroupGroupRoles = this.getUserGroupGroupRoles(kaleoTaskInstanceTokenQuery.getUserId());
        for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
            this.mapRoleIdGroupId(userGroupGroupRole.getRoleId(), userGroupGroupRole.getGroupId(), roleIdGroupIdsMap);
        }
        this.mapSiteMemberRoleIdGroupId(kaleoTaskInstanceTokenQuery.getCompanyId(), kaleoTaskInstanceTokenQuery.getUserId(), roleIdGroupIdsMap);
        return roleIdGroupIdsMap;
    }

    protected List<Long> getSearchByUserRoleIds(long userId) {
        try {
            List roles = this.roleLocalService.getUserRoles(userId);
            ArrayList groups = new ArrayList();
            User user = this.userLocalService.getUserById(userId);
            groups.addAll(user.getGroups());
            groups.addAll(this.groupLocalService.getOrganizationsGroups(user.getOrganizations()));
            groups.addAll(this.groupLocalService.getOrganizationsRelatedGroups(user.getOrganizations()));
            groups.addAll(this.groupLocalService.getUserGroupsGroups(user.getUserGroups()));
            groups.addAll(this.groupLocalService.getUserGroupsRelatedGroups(user.getUserGroups()));
            for (Group group : groups) {
                roles.addAll(this.roleLocalService.getGroupRoles(group.getGroupId()));
            }
            Stream stream = roles.parallelStream();
            return stream.map(RoleModel::getRoleId).collect(Collectors.toList());
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return Collections.emptyList();
        }
    }

    protected List<UserGroupGroupRole> getUserGroupGroupRoles(long userId) {
        ArrayList<UserGroupGroupRole> userGroupGroupRoles = new ArrayList<UserGroupGroupRole>();
        List userGroups = this.userGroupLocalService.getUserUserGroups(userId);
        for (UserGroup userGroup : userGroups) {
            userGroupGroupRoles.addAll(this.userGroupGroupRoleLocalService.getUserGroupGroupRoles(userGroup.getUserGroupId()));
        }
        return userGroupGroupRoles;
    }

    protected void mapRoleIdGroupId(long roleId, long groupId, Map<Long, Set<Long>> roleIdGroupIdsMap) {
        Set<Long> groupIds = roleIdGroupIdsMap.get(roleId);
        if (groupIds == null) {
            groupIds = new TreeSet<Long>();
            roleIdGroupIdsMap.put(roleId, groupIds);
        }
        groupIds.add(groupId);
    }

    protected void mapSiteMemberRoleIdGroupId(long companyId, long userId, Map<Long, Set<Long>> roleIdGroupIdsMap) {
        block3: {
            try {
                Role siteMemberRole = this.roleLocalService.getRole(companyId, "Site Member");
                User user = this.userLocalService.getUserById(userId);
                long[] lArray = user.getGroupIds();
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long groupId = lArray[i];
                    this.mapRoleIdGroupId(siteMemberRole.getRoleId(), groupId, roleIdGroupIdsMap);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }
}

