/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTaskInstanceTokenQuery;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken"}, service={KeywordQueryContributor.class})
public class KaleoTaskInstanceTokenKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    protected QueryHelper queryHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = this.getKaleoTaskInstanceTokenQuery(keywordQueryContributorHelper);
        if (kaleoTaskInstanceTokenQuery == null) {
            return;
        }
        this.appendAssetTitleTerm(booleanQuery, kaleoTaskInstanceTokenQuery.getAssetTitle(), keywordQueryContributorHelper);
        this.appendTaskNameTerm(booleanQuery, kaleoTaskInstanceTokenQuery.getTaskName(), keywordQueryContributorHelper);
    }

    protected void appendAssetTitleTerm(BooleanQuery booleanQuery, String assetTitle, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        if (Validator.isNull((String)assetTitle)) {
            return;
        }
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        String assetTitleLocalizedName = LocalizationUtil.getLocalizedName((String)"assetTitle", (String)searchContext.getLanguageId());
        searchContext.setAttribute(assetTitleLocalizedName, (Serializable)((Object)assetTitle));
        this.queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "assetTitle", false);
    }

    protected void appendTaskNameTerm(BooleanQuery booleanQuery, String taskName, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        if (Validator.isNull((String)taskName)) {
            return;
        }
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        searchContext.setAttribute("taskName", (Serializable)((Object)taskName));
        this.queryHelper.addSearchTerm(booleanQuery, keywordQueryContributorHelper.getSearchContext(), "taskName", false);
    }

    protected KaleoTaskInstanceTokenQuery getKaleoTaskInstanceTokenQuery(KeywordQueryContributorHelper keywordQueryContributorHelper) {
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        return (KaleoTaskInstanceTokenQuery)searchContext.getAttribute("kaleoTaskInstanceTokenQuery");
    }
}

