/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken"}, service={ModelDocumentContributor.class})
public class KaleoTaskInstanceTokenModelDocumentContributor
implements ModelDocumentContributor<KaleoTaskInstanceToken> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(KaleoTaskInstanceTokenModelDocumentContributor.class);

    public void contribute(Document document, KaleoTaskInstanceToken kaleoTaskInstanceToken) {
        String[] descriptionLanguageIds;
        String[] titleLanguageIds;
        List kaleoTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
        HashSet<Long> assigneeClassNameIds = new HashSet<Long>();
        HashSet<Long> assigneeClassPKs = new HashSet<Long>();
        HashSet<Long> assigneeGroupIds = new HashSet<Long>();
        for (KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance : kaleoTaskAssignmentInstances) {
            assigneeClassNameIds.add(this.portal.getClassNameId(kaleoTaskAssignmentInstance.getAssigneeClassName()));
            assigneeClassPKs.add(kaleoTaskAssignmentInstance.getAssigneeClassPK());
            assigneeGroupIds.add(kaleoTaskAssignmentInstance.getGroupId());
        }
        document.addKeyword("assigneeClassNameIds", assigneeClassNameIds.toArray(new Long[0]));
        document.addKeyword("assigneeClassPKs", assigneeClassPKs.toArray(new Long[0]));
        document.addKeyword("assigneeGroupIds", assigneeGroupIds.toArray(new Long[0]));
        document.addKeyword("className", kaleoTaskInstanceToken.getClassName());
        document.addKeyword("classPK", kaleoTaskInstanceToken.getClassPK());
        document.addKeywordSortable("completed", Boolean.valueOf(kaleoTaskInstanceToken.isCompleted()));
        document.addDateSortable("completionDate", kaleoTaskInstanceToken.getCompletionDate());
        document.addDateSortable("createDate", kaleoTaskInstanceToken.getCreateDate());
        document.addDateSortable("dueDate", kaleoTaskInstanceToken.getDueDate());
        document.addKeyword("kaleoInstanceId", kaleoTaskInstanceToken.getKaleoInstanceId());
        document.addNumberSortable("kaleoTaskId", Long.valueOf(kaleoTaskInstanceToken.getKaleoTaskId()));
        document.addNumberSortable("kaleoTaskInstanceTokenId", Long.valueOf(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId()));
        document.addDateSortable("modified", kaleoTaskInstanceToken.getModifiedDate());
        document.addKeywordSortable("taskName", kaleoTaskInstanceToken.getKaleoTaskName());
        document.addNumberSortable("userId", Long.valueOf(kaleoTaskInstanceToken.getUserId()));
        AssetEntry assetEntry = this.getAssetEntry(kaleoTaskInstanceToken);
        if (assetEntry == null) {
            return;
        }
        document.addKeyword("assetClassNameId", assetEntry.getClassNameId());
        document.addKeyword("assetClassPK", assetEntry.getClassPK());
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String siteDefaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        for (String titleLanguageId : titleLanguageIds = this.getLanguageIds(siteDefaultLanguageId, assetEntry.getTitle())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"assetTitle", (String)titleLanguageId), assetEntry.getTitle(titleLanguageId));
        }
        for (String descriptionLanguageId : descriptionLanguageIds = this.getLanguageIds(siteDefaultLanguageId, assetEntry.getDescription())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"assetDescription", (String)descriptionLanguageId), assetEntry.getDescription(descriptionLanguageId));
        }
    }

    protected AssetEntry getAssetEntry(KaleoTaskInstanceToken kaleoTaskInstanceToken) {
        try {
            AssetRendererFactory<?> assetRendererFactory = this.getAssetRendererFactory(kaleoTaskInstanceToken.getClassName());
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(kaleoTaskInstanceToken.getClassPK());
            return this.assetEntryLocalService.getEntry(assetRenderer.getClassName(), assetRenderer.getClassPK());
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }

    protected AssetRendererFactory<?> getAssetRendererFactory(String className) {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

