/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken"}, service={ModelDocumentContributor.class})
public class KaleoInstanceTokenModelDocumentContributor
implements ModelDocumentContributor<KaleoInstanceToken> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(KaleoInstanceTokenModelDocumentContributor.class);

    public void contribute(Document document, KaleoInstanceToken kaleoInstanceToken) {
        String[] descriptionLanguageIds;
        String[] titleLanguageIds;
        block5: {
            document.addKeyword("className", kaleoInstanceToken.getClassName());
            document.addKeyword("classPK", kaleoInstanceToken.getClassPK());
            document.addKeywordSortable("completed", Boolean.valueOf(kaleoInstanceToken.isCompleted()));
            document.addDateSortable("completionDate", kaleoInstanceToken.getCompletionDate());
            document.addDateSortable("createDate", kaleoInstanceToken.getCreateDate());
            document.addKeywordSortable("currentKaleoNodeName", kaleoInstanceToken.getCurrentKaleoNodeName());
            document.addNumberSortable("kaleoInstanceId", Long.valueOf(kaleoInstanceToken.getKaleoInstanceId()));
            document.addKeyword("kaleoInstanceTokenId", kaleoInstanceToken.getKaleoInstanceTokenId());
            document.addDateSortable("modified", kaleoInstanceToken.getModifiedDate());
            document.addKeyword("parentKaleoInstanceTokenId", kaleoInstanceToken.getParentKaleoInstanceTokenId());
            try {
                KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
                document.addKeyword("kaleoDefinitionName", kaleoInstance.getKaleoDefinitionName());
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)pe, (Throwable)pe);
            }
        }
        AssetEntry assetEntry = this.getAssetEntry(kaleoInstanceToken);
        if (assetEntry == null) {
            return;
        }
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String siteDefaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        for (String titleLanguageId : titleLanguageIds = this.getLanguageIds(siteDefaultLanguageId, assetEntry.getTitle())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"assetTitle", (String)titleLanguageId), assetEntry.getTitle(titleLanguageId));
        }
        for (String descriptionLanguageId : descriptionLanguageIds = this.getLanguageIds(siteDefaultLanguageId, assetEntry.getDescription())) {
            document.addText(LocalizationUtil.getLocalizedName((String)"assetDescription", (String)descriptionLanguageId), assetEntry.getDescription(descriptionLanguageId));
        }
    }

    protected AssetEntry getAssetEntry(KaleoInstanceToken kaleoInstanceToken) {
        try {
            AssetRendererFactory<?> assetRendererFactory = this.getAssetRendererFactory(kaleoInstanceToken.getClassName());
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(kaleoInstanceToken.getClassPK());
            return this.assetEntryLocalService.getEntry(assetRenderer.getClassName(), assetRenderer.getClassPK());
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }

    protected AssetRendererFactory<?> getAssetRendererFactory(String className) {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

