/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.model.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ServiceComponent;
import com.liferay.portal.kernel.upgrade.util.BaseUpgradeTableListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class BaseKaleoUpgradeTableListener
extends BaseUpgradeTableListener {
    private static final Log _log = LogFactoryUtil.getLog(BaseKaleoUpgradeTableListener.class);

    protected Map<Long, Long> getKeyValueMap(String tableName, String keyColumnName, String valueColumnName) {
        HashMap<Long, Long> keyValueMap = new HashMap<Long, Long>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(StringBundler.concat((String[])new String[]{"select ", keyColumnName, ", ", valueColumnName, " from ", tableName}));
            rs = ps.executeQuery();
            while (rs.next()) {
                long key = rs.getLong(keyColumnName);
                long value = rs.getLong(valueColumnName);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"{", keyColumnName, "=", key, ", ", valueColumnName, "=", value, "}"}));
                }
                keyValueMap.put(key, value);
            }
        }
        catch (Exception e) {
            try {
                throw new SystemException((Throwable)e);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return keyValueMap;
    }

    protected boolean isFixAutoUpgrade(ServiceComponent previousServiceComponent) {
        return previousServiceComponent.getBuildNumber() < 4L;
    }

    protected void updateKeyValueMap(Map<Long, Long> keyValueMap, String kaleoClassName, String tableName, String keyColumnName) throws Exception {
        for (Map.Entry<Long, Long> entry : keyValueMap.entrySet()) {
            StringBundler sb = new StringBundler(10);
            sb.append("update ");
            sb.append(tableName);
            sb.append(" set kaleoClassName = '");
            sb.append(kaleoClassName);
            sb.append("', kaleoClassPK = ");
            sb.append((Object)entry.getValue());
            sb.append(" where ");
            sb.append(keyColumnName);
            sb.append(" = ");
            sb.append((Object)entry.getKey());
            this.runSQL(sb.toString());
        }
    }
}

