/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.model.listener;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class RoleModelListener
extends BaseModelListener<Role> {
    private KaleoTaskAssignmentLocalService _kaleoTaskAssignmentLocalService;

    public void onBeforeRemove(Role role) throws ModelListenerException {
        try {
            this._deleteKaleoTaskAssignmentByRole(role.getRoleId());
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    @Reference(unbind="-")
    protected void setKaleoTaskAssignmentLocalService(KaleoTaskAssignmentLocalService kaleoTaskAssignmentLocalService) {
        this._kaleoTaskAssignmentLocalService = kaleoTaskAssignmentLocalService;
    }

    private void _deleteKaleoTaskAssignmentByRole(long roleId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoTaskAssignmentLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property assigneeClassNameProperty = PropertyFactoryUtil.forName((String)"assigneeClassName");
            dynamicQuery.add(assigneeClassNameProperty.like((Object)Role.class.getName()));
            Property assigneeClassPKProperty = PropertyFactoryUtil.forName((String)"assigneeClassPK");
            dynamicQuery.add(assigneeClassPKProperty.eq((Object)roleId));
        });
        actionableDynamicQuery.setPerformActionMethod(kaleoTaskAssignment -> this._kaleoTaskAssignmentLocalService.deleteKaleoTaskAssignment(kaleoTaskAssignment));
        actionableDynamicQuery.performActions();
    }
}

