/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ModelListener.class})
public class KaleoDefinitionModelListener
extends BaseModelListener<KaleoDefinition> {
    public void onAfterCreate(KaleoDefinition kaleoDefinition) throws ModelListenerException {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.put("command", (Object)"create");
            message.put("name", (Object)kaleoDefinition.getName());
            message.put("serviceContext", (Object)this.getServiceContext(kaleoDefinition));
            message.put("version", (Object)kaleoDefinition.getVersion());
            MessageBusUtil.sendMessage((String)"liferay/kaleo_definition", (Message)message);
            return null;
        });
    }

    public void onAfterRemove(KaleoDefinition kaleoDefinition) throws ModelListenerException {
        if (kaleoDefinition == null) {
            return;
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            try {
                Message message = new Message();
                message.put("command", (Object)"delete");
                message.put("name", (Object)kaleoDefinition.getName());
                message.put("serviceContext", (Object)this.getServiceContext(kaleoDefinition));
                message.put("version", (Object)kaleoDefinition.getVersion());
                MessageBusUtil.sendMessage((String)"liferay/kaleo_definition", (Message)message);
            }
            catch (Exception e) {
                throw new ModelListenerException((Throwable)e);
            }
            return null;
        });
    }

    protected ServiceContext getServiceContext(KaleoDefinition kaleoDefinition) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCompanyId(kaleoDefinition.getCompanyId());
        serviceContext.setScopeGroupId(kaleoDefinition.getGroupId());
        serviceContext.setUserId(kaleoDefinition.getUserId());
        return serviceContext;
    }
}

