/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskInstanceTokenLocalServiceBaseImpl;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTaskInstanceTokenQuery;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class KaleoTaskInstanceTokenLocalServiceImpl
extends KaleoTaskInstanceTokenLocalServiceBaseImpl {
    public KaleoTaskInstanceToken addKaleoTaskInstanceToken(long kaleoInstanceTokenId, long kaleoTaskId, String kaleoTaskName, Collection<KaleoTaskAssignment> kaleoTaskAssignments, Date dueDate, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.findByPrimaryKey(kaleoInstanceTokenId);
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoTaskInstanceTokenId = this.counterLocalService.increment();
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.create(kaleoTaskInstanceTokenId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoTaskInstanceToken.setGroupId(groupId);
        kaleoTaskInstanceToken.setCompanyId(user.getCompanyId());
        kaleoTaskInstanceToken.setUserId(user.getUserId());
        kaleoTaskInstanceToken.setUserName(user.getFullName());
        kaleoTaskInstanceToken.setCreateDate(now);
        kaleoTaskInstanceToken.setModifiedDate(now);
        kaleoTaskInstanceToken.setKaleoDefinitionVersionId(kaleoInstanceToken.getKaleoDefinitionVersionId());
        kaleoTaskInstanceToken.setKaleoInstanceId(kaleoInstanceToken.getKaleoInstanceId());
        kaleoTaskInstanceToken.setKaleoInstanceTokenId(kaleoInstanceTokenId);
        kaleoTaskInstanceToken.setDueDate(dueDate);
        kaleoTaskInstanceToken.setKaleoTaskId(kaleoTaskId);
        kaleoTaskInstanceToken.setKaleoTaskName(kaleoTaskName);
        if (workflowContext != null) {
            kaleoTaskInstanceToken.setClassName((String)((Object)workflowContext.get("entryClassName")));
            if (workflowContext.containsKey("entryClassPK")) {
                kaleoTaskInstanceToken.setClassPK(GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK")))));
            }
        }
        kaleoTaskInstanceToken.setCompleted(false);
        kaleoTaskInstanceToken.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstanceToken);
        this.kaleoTaskAssignmentInstanceLocalService.addTaskAssignmentInstances(kaleoTaskInstanceToken, kaleoTaskAssignments, workflowContext, serviceContext);
        return kaleoTaskInstanceToken;
    }

    public KaleoTaskInstanceToken assignKaleoTaskInstanceToken(long kaleoTaskInstanceTokenId, String assigneeClassName, long assigneeClassPK, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        kaleoTaskInstanceToken.setModifiedDate(new Date());
        kaleoTaskInstanceToken.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstanceToken);
        this.kaleoTaskAssignmentInstanceLocalService.assignKaleoTaskAssignmentInstance(kaleoTaskInstanceToken, assigneeClassName, assigneeClassPK, serviceContext);
        return kaleoTaskInstanceToken;
    }

    public KaleoTaskInstanceToken completeKaleoTaskInstanceToken(long kaleoTaskInstanceTokenId, ServiceContext serviceContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        kaleoTaskInstanceToken.setCompletionUserId(serviceContext.getUserId());
        kaleoTaskInstanceToken.setCompleted(true);
        kaleoTaskInstanceToken.setCompletionDate(new Date());
        this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstanceToken);
        this.kaleoTaskAssignmentInstanceLocalService.completeKaleoTaskInstanceToken(kaleoTaskInstanceTokenId, serviceContext);
        this.kaleoTimerInstanceTokenLocalService.completeKaleoTimerInstanceTokens(kaleoTaskInstanceToken.getKaleoInstanceTokenId(), serviceContext);
        return kaleoTaskInstanceToken;
    }

    public void deleteCompanyKaleoTaskInstanceTokens(long companyId) {
        this.kaleoTaskInstanceTokenPersistence.removeByCompanyId(companyId);
        this.kaleoTaskAssignmentInstanceLocalService.deleteCompanyKaleoTaskAssignmentInstances(companyId);
        this.kaleoTaskFormInstanceLocalService.deleteCompanyKaleoTaskFormInstances(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTaskInstanceTokens(long kaleoDefinitionVersionId) {
        this.kaleoTaskInstanceTokenPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        this.kaleoTaskAssignmentInstanceLocalService.deleteKaleoDefinitionVersionKaleoTaskAssignmentInstances(kaleoDefinitionVersionId);
        this.kaleoTaskFormInstanceLocalService.deleteKaleoDefinitionVersionKaleoTaskFormInstances(kaleoDefinitionVersionId);
    }

    public void deleteKaleoInstanceKaleoTaskInstanceTokens(long kaleoInstanceId) {
        this.kaleoTaskInstanceTokenPersistence.removeByKaleoInstanceId(kaleoInstanceId);
        this.kaleoTaskAssignmentInstanceLocalService.deleteKaleoInstanceKaleoTaskAssignmentInstances(kaleoInstanceId);
        this.kaleoTaskFormInstanceLocalService.deleteKaleoInstanceKaleoTaskFormInstances(kaleoInstanceId);
    }

    public List<KaleoTaskInstanceToken> getCompanyKaleoTaskInstanceTokens(long companyId, int start, int end) {
        return this.kaleoTaskInstanceTokenPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyKaleoTaskInstanceTokensCount(long companyId) {
        return this.kaleoTaskInstanceTokenPersistence.countByCompanyId(companyId);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(completed, serviceContext);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(List<Long> roleIds, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setRoleIds(roleIds);
        kaleoTaskInstanceTokenQuery.setStart(start);
        return this.kaleoTaskInstanceTokenFinder.findKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(long kaleoInstanceId, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        long userId = serviceContext.getUserId();
        if (userId == 0L) {
            DynamicQuery dynamicQuery = this.buildDynamicQuery(kaleoInstanceId, completed, serviceContext);
            return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
        }
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(User.class.getName());
        kaleoTaskInstanceTokenQuery.setAssigneeClassPK(Long.valueOf(serviceContext.getUserId()));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setKaleoInstanceId(Long.valueOf(kaleoInstanceId));
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setStart(start);
        return this.kaleoTaskInstanceTokenFinder.findKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public KaleoTaskInstanceToken getKaleoTaskInstanceTokens(long kaleoInstanceId, long kaleoTaskId) throws PortalException {
        return this.kaleoTaskInstanceTokenPersistence.findByKII_KTI(kaleoInstanceId, kaleoTaskId);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(String assigneeClassName, long assigneeClassPK, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(assigneeClassName);
        kaleoTaskInstanceTokenQuery.setAssigneeClassPK(Long.valueOf(assigneeClassPK));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setStart(start);
        return this.kaleoTaskInstanceTokenFinder.findKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public int getKaleoTaskInstanceTokensCount(Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(completed, serviceContext);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public int getKaleoTaskInstanceTokensCount(List<Long> roleIds, Boolean completed, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(Role.class.getName());
        kaleoTaskInstanceTokenQuery.setRoleIds(roleIds);
        return this.kaleoTaskInstanceTokenFinder.countKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public int getKaleoTaskInstanceTokensCount(long kaleoInstanceId, Boolean completed, ServiceContext serviceContext) {
        long userId = serviceContext.getUserId();
        if (userId == 0L) {
            DynamicQuery dynamicQuery = this.buildDynamicQuery(kaleoInstanceId, completed, serviceContext);
            return (int)this.dynamicQueryCount(dynamicQuery);
        }
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(User.class.getName());
        kaleoTaskInstanceTokenQuery.setAssigneeClassPK(Long.valueOf(serviceContext.getUserId()));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        return this.kaleoTaskInstanceTokenFinder.countKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public int getKaleoTaskInstanceTokensCount(String assigneeClassName, long assigneeClassPK, Boolean completed, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(assigneeClassName);
        kaleoTaskInstanceTokenQuery.setAssigneeClassPK(Long.valueOf(assigneeClassPK));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        return this.kaleoTaskInstanceTokenFinder.countKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public List<KaleoTaskInstanceToken> getSubmittingUserKaleoTaskInstanceTokens(long userId, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoTaskInstanceToken.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        Property workflowContextProperty = PropertyFactoryUtil.forName((String)"workflowContext");
        dynamicQuery.add(workflowContextProperty.like((Object)("%\"userId\":\"" + userId + "\"%")));
        this.addCompletedCriterion(dynamicQuery, completed);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public int getSubmittingUserKaleoTaskInstanceTokensCount(long userId, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoTaskInstanceToken.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        Property workflowContextProperty = PropertyFactoryUtil.forName((String)"workflowContext");
        dynamicQuery.add(workflowContextProperty.like((Object)("%\"userId\":\"" + userId + "\"%")));
        this.addCompletedCriterion(dynamicQuery, completed);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public boolean hasPendingKaleoTaskForms(long kaleoTaskInstanceTokenId) throws PortalException {
        int kaleoTaskFormInstancesCount;
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        int kaleoTaskFormsCount = this.kaleoTaskFormPersistence.countByKaleoTaskId(kaleoTaskInstanceToken.getKaleoTaskId());
        return kaleoTaskFormsCount > (kaleoTaskFormInstancesCount = this.kaleoTaskFormInstancePersistence.countByKaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId));
    }

    public List<KaleoTaskInstanceToken> search(String keywords, Boolean completed, Boolean searchByUserRoles, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(keywords, keywords, null, null, null, completed, searchByUserRoles, false, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoTaskInstanceToken> search(String taskName, String assetType, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(null, taskName, this.getAssetTypes(assetType), assetPrimaryKeys, dueDateGT, dueDateLT, completed, searchByUserRoles, andOperator, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoTaskInstanceToken> search(String assetTitle, String taskName, String[] assetTypes, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssetTitle(assetTitle);
        kaleoTaskInstanceTokenQuery.setAssetPrimaryKeys(assetPrimaryKeys);
        kaleoTaskInstanceTokenQuery.setAssetTypes(assetTypes);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setDueDateGT(dueDateGT);
        kaleoTaskInstanceTokenQuery.setDueDateLT(dueDateLT);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setSearchByUserRoles(searchByUserRoles);
        kaleoTaskInstanceTokenQuery.setStart(start);
        kaleoTaskInstanceTokenQuery.setTaskName(taskName);
        kaleoTaskInstanceTokenQuery.setAndOperator(andOperator);
        return this.kaleoTaskInstanceTokenFinder.findKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public List<KaleoTaskInstanceToken> search(String keywords, String[] assetTypes, Boolean completed, Boolean searchByUserRoles, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(keywords, keywords, assetTypes, null, null, null, completed, searchByUserRoles, false, start, end, orderByComparator, serviceContext);
    }

    public int searchCount(String keywords, Boolean completed, Boolean searchByUserRoles, ServiceContext serviceContext) {
        return this.searchCount(keywords, keywords, null, null, null, completed, searchByUserRoles, false, serviceContext);
    }

    public int searchCount(String taskName, String assetType, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, ServiceContext serviceContext) {
        return this.searchCount(null, taskName, this.getAssetTypes(assetType), assetPrimaryKeys, dueDateGT, dueDateLT, completed, searchByUserRoles, andOperator, serviceContext);
    }

    public int searchCount(String assetTitle, String taskName, String[] assetTypes, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssetTitle(assetTitle);
        kaleoTaskInstanceTokenQuery.setAssetPrimaryKeys(assetPrimaryKeys);
        kaleoTaskInstanceTokenQuery.setAssetTypes(assetTypes);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setDueDateGT(dueDateGT);
        kaleoTaskInstanceTokenQuery.setDueDateLT(dueDateLT);
        kaleoTaskInstanceTokenQuery.setSearchByUserRoles(searchByUserRoles);
        kaleoTaskInstanceTokenQuery.setTaskName(taskName);
        kaleoTaskInstanceTokenQuery.setAndOperator(andOperator);
        return this.kaleoTaskInstanceTokenFinder.countKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public int searchCount(String keywords, String[] assetTypes, Boolean completed, Boolean searchByUserRoles, ServiceContext serviceContext) {
        return this.searchCount(keywords, keywords, assetTypes, null, null, null, completed, searchByUserRoles, false, serviceContext);
    }

    public KaleoTaskInstanceToken updateDueDate(long kaleoTaskInstanceTokenId, Date dueDate, ServiceContext serviceContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstance = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        kaleoTaskInstance.setModifiedDate(new Date());
        if (dueDate != null) {
            Calendar cal = CalendarFactoryUtil.getCalendar((Locale)LocaleUtil.getDefault());
            cal.setTime(dueDate);
            kaleoTaskInstance.setDueDate(cal.getTime());
        }
        this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstance);
        return kaleoTaskInstance;
    }

    protected void addCompletedCriterion(DynamicQuery dynamicQuery, Boolean completed) {
        if (completed == null) {
            return;
        }
        Property property = PropertyFactoryUtil.forName((String)"completed");
        dynamicQuery.add(property.eq((Object)completed));
    }

    protected DynamicQuery buildDynamicQuery(Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoTaskInstanceToken.class, (ClassLoader)this.getClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(property.eq((Object)serviceContext.getCompanyId()));
        this.addCompletedCriterion(dynamicQuery, completed);
        return dynamicQuery;
    }

    protected DynamicQuery buildDynamicQuery(long kaleoInstanceId, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoTaskInstanceToken.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        Property kaleoInstanceIdProperty = PropertyFactoryUtil.forName((String)"kaleoInstanceId");
        dynamicQuery.add(kaleoInstanceIdProperty.eq((Object)kaleoInstanceId));
        this.addCompletedCriterion(dynamicQuery, completed);
        return dynamicQuery;
    }

    protected String[] getAssetTypes(String assetType) {
        if (Validator.isNull((String)assetType)) {
            return null;
        }
        return new String[]{assetType};
    }
}

