/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.TaskForm;
import com.liferay.portal.workflow.kaleo.definition.TaskFormReference;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskForm;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskFormLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class KaleoTaskFormLocalServiceImpl
extends KaleoTaskFormLocalServiceBaseImpl {
    public KaleoTaskForm addKaleoTaskForm(long kaleoDefinitionVersionId, long kaleoNodeId, KaleoTask kaleoTask, TaskForm taskForm, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoTaskFormId = this.counterLocalService.increment();
        KaleoTaskForm kaleoTaskForm = this.kaleoTaskFormPersistence.create(kaleoTaskFormId);
        kaleoTaskForm.setGroupId(kaleoTask.getGroupId());
        kaleoTaskForm.setCompanyId(user.getCompanyId());
        kaleoTaskForm.setUserId(user.getUserId());
        kaleoTaskForm.setUserName(user.getFullName());
        kaleoTaskForm.setCreateDate(now);
        kaleoTaskForm.setModifiedDate(now);
        kaleoTaskForm.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoTaskForm.setKaleoNodeId(kaleoNodeId);
        kaleoTaskForm.setKaleoTaskId(kaleoTask.getKaleoTaskId());
        kaleoTaskForm.setKaleoTaskName(kaleoTask.getName());
        kaleoTaskForm.setName(taskForm.getName());
        kaleoTaskForm.setDescription(taskForm.getDescription());
        kaleoTaskForm.setFormDefinition(taskForm.getFormDefinition());
        kaleoTaskForm.setMetadata(taskForm.getMetadata());
        kaleoTaskForm.setPriority(taskForm.getPriority());
        TaskFormReference taskFormReference = taskForm.getTaskFormReference();
        kaleoTaskForm.setFormCompanyId(taskFormReference.getCompanyId());
        kaleoTaskForm.setFormGroupId(taskFormReference.getGroupId());
        kaleoTaskForm.setFormId(taskFormReference.getFormId());
        kaleoTaskForm.setFormUuid(taskFormReference.getFormUuid());
        this.kaleoTaskFormPersistence.update((BaseModel)kaleoTaskForm);
        return kaleoTaskForm;
    }

    public void deleteCompanyKaleoTaskForms(long companyId) {
        this.kaleoTaskFormPersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTaskForms(long kaleoDefinitionVersionId) {
        this.kaleoTaskFormPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    @Override
    public KaleoTaskForm fetchKaleoTaskForm(long kaleoTaskFormId) {
        return this.kaleoTaskFormPersistence.fetchByPrimaryKey(kaleoTaskFormId);
    }

    public List<KaleoTaskForm> getKaleoTaskForms(long kaleoTaskId) throws PortalException {
        return this.kaleoTaskFormPersistence.findByKaleoTaskId(kaleoTaskId);
    }
}

