/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.Assignment;
import com.liferay.portal.workflow.kaleo.definition.AssignmentType;
import com.liferay.portal.workflow.kaleo.definition.ResourceActionAssignment;
import com.liferay.portal.workflow.kaleo.definition.RoleAssignment;
import com.liferay.portal.workflow.kaleo.definition.ScriptAssignment;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import com.liferay.portal.workflow.kaleo.definition.UserAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.runtime.util.RoleUtil;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskAssignmentLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class KaleoTaskAssignmentLocalServiceImpl
extends KaleoTaskAssignmentLocalServiceBaseImpl {
    public KaleoTaskAssignment addKaleoTaskAssignment(String kaleoClassName, long kaleoClassPK, long kaleoDefinitionVersionId, Assignment assignment, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoTaskAssignmentId = this.counterLocalService.increment();
        KaleoTaskAssignment kaleoTaskAssignment = this.kaleoTaskAssignmentPersistence.create(kaleoTaskAssignmentId);
        kaleoTaskAssignment.setCompanyId(user.getCompanyId());
        kaleoTaskAssignment.setUserId(user.getUserId());
        kaleoTaskAssignment.setUserName(user.getFullName());
        kaleoTaskAssignment.setCreateDate(now);
        kaleoTaskAssignment.setModifiedDate(now);
        kaleoTaskAssignment.setKaleoClassName(kaleoClassName);
        kaleoTaskAssignment.setKaleoClassPK(kaleoClassPK);
        kaleoTaskAssignment.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoTaskAssignment.setKaleoNodeId(kaleoTaskAssignment.getKaleoNodeId());
        this.setAssignee(kaleoTaskAssignment, assignment, serviceContext);
        this.kaleoTaskAssignmentPersistence.update((BaseModel)kaleoTaskAssignment);
        return kaleoTaskAssignment;
    }

    public void deleteCompanyKaleoTaskAssignments(long companyId) {
        this.kaleoTaskAssignmentPersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTaskAssignments(long kaleoDefinitionVersionId) {
        this.kaleoTaskAssignmentPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    public List<KaleoTaskAssignment> getKaleoTaskAssignments(long kaleoTaskId) {
        return this.kaleoTaskAssignmentPersistence.findByKCN_KCPK(KaleoTask.class.getName(), kaleoTaskId);
    }

    public List<KaleoTaskAssignment> getKaleoTaskAssignments(long kaleoTaskId, String assigneeClassName) {
        return this.kaleoTaskAssignmentPersistence.findByKCN_KCPK_ACN(KaleoTask.class.getName(), kaleoTaskId, assigneeClassName);
    }

    public List<KaleoTaskAssignment> getKaleoTaskAssignments(String kaleoClassName, long kaleoClassPK) {
        return this.kaleoTaskAssignmentPersistence.findByKCN_KCPK(kaleoClassName, kaleoClassPK);
    }

    public int getKaleoTaskAssignmentsCount(long kaleoTaskId) {
        return this.kaleoTaskAssignmentPersistence.countByKCN_KCPK(KaleoTask.class.getName(), kaleoTaskId);
    }

    public int getKaleoTaskAssignmentsCount(long kaleoTaskId, String assigneeClassName) {
        return this.kaleoTaskAssignmentPersistence.countByKCN_KCPK_ACN(KaleoTask.class.getName(), kaleoTaskId, assigneeClassName);
    }

    protected void setAssignee(KaleoTaskAssignment kaleoTaskAssignment, Assignment assignment, ServiceContext serviceContext) throws PortalException {
        AssignmentType assignmentType = assignment.getAssignmentType();
        if (assignmentType.equals((Object)AssignmentType.RESOURCE_ACTION)) {
            kaleoTaskAssignment.setAssigneeClassName(ResourceAction.class.getName());
            ResourceActionAssignment resourceActionAssignment = (ResourceActionAssignment)assignment;
            String actionId = resourceActionAssignment.getActionId();
            kaleoTaskAssignment.setAssigneeActionId(actionId);
        } else if (assignmentType.equals((Object)AssignmentType.ROLE)) {
            kaleoTaskAssignment.setAssigneeClassName(Role.class.getName());
            RoleAssignment roleAssignment = (RoleAssignment)assignment;
            Role role = null;
            if (Validator.isNotNull((String)roleAssignment.getRoleName())) {
                int roleType = RoleUtil.getRoleType((String)roleAssignment.getRoleType());
                role = RoleUtil.getRole((String)roleAssignment.getRoleName(), (int)roleType, (boolean)roleAssignment.isAutoCreate(), (ServiceContext)serviceContext);
            } else {
                role = this.roleLocalService.getRole(roleAssignment.getRoleId());
            }
            kaleoTaskAssignment.setAssigneeClassPK(role.getRoleId());
        } else if (assignmentType.equals((Object)AssignmentType.SCRIPT)) {
            kaleoTaskAssignment.setAssigneeClassName(AssignmentType.SCRIPT.name());
            ScriptAssignment scriptAssignment = (ScriptAssignment)assignment;
            kaleoTaskAssignment.setAssigneeScript(scriptAssignment.getScript());
            ScriptLanguage scriptLanguage = scriptAssignment.getScriptLanguage();
            kaleoTaskAssignment.setAssigneeScriptLanguage(scriptLanguage.getValue());
            kaleoTaskAssignment.setAssigneeScriptRequiredContexts(scriptAssignment.getScriptRequiredContexts());
        } else if (assignmentType.equals((Object)AssignmentType.USER)) {
            kaleoTaskAssignment.setAssigneeClassName(User.class.getName());
            UserAssignment userAssignment = (UserAssignment)assignment;
            User user = null;
            if (userAssignment.getUserId() > 0L) {
                user = this.userLocalService.getUser(userAssignment.getUserId());
            } else if (Validator.isNotNull((String)userAssignment.getEmailAddress())) {
                user = this.userLocalService.getUserByEmailAddress(serviceContext.getCompanyId(), userAssignment.getEmailAddress());
            } else if (Validator.isNotNull((String)userAssignment.getScreenName())) {
                user = this.userLocalService.getUserByScreenName(serviceContext.getCompanyId(), userAssignment.getScreenName());
            }
            if (user != null) {
                kaleoTaskAssignment.setAssigneeClassPK(user.getUserId());
            } else {
                kaleoTaskAssignment.setAssigneeClassPK(0L);
            }
        }
    }
}

