/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskAssignmentInstanceLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class KaleoTaskAssignmentInstanceLocalServiceImpl
extends KaleoTaskAssignmentInstanceLocalServiceBaseImpl {
    public KaleoTaskAssignmentInstance addKaleoTaskAssignmentInstance(long groupId, KaleoTaskInstanceToken kaleoTaskInstanceToken, String assigneeClassName, long assigneeClassPK, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        long kaleoTaskAssignmentInstanceId = this.counterLocalService.increment();
        KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = this.kaleoTaskAssignmentInstancePersistence.create(kaleoTaskAssignmentInstanceId);
        kaleoTaskAssignmentInstance.setGroupId(groupId);
        kaleoTaskAssignmentInstance.setCompanyId(user.getCompanyId());
        kaleoTaskAssignmentInstance.setUserId(user.getUserId());
        kaleoTaskAssignmentInstance.setUserName(user.getFullName());
        kaleoTaskAssignmentInstance.setCreateDate(now);
        kaleoTaskAssignmentInstance.setModifiedDate(now);
        kaleoTaskAssignmentInstance.setKaleoDefinitionVersionId(kaleoTaskInstanceToken.getKaleoDefinitionVersionId());
        kaleoTaskAssignmentInstance.setKaleoInstanceId(kaleoTaskInstanceToken.getKaleoInstanceId());
        kaleoTaskAssignmentInstance.setKaleoInstanceTokenId(kaleoTaskInstanceToken.getKaleoInstanceTokenId());
        kaleoTaskAssignmentInstance.setKaleoTaskInstanceTokenId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        kaleoTaskAssignmentInstance.setKaleoTaskId(kaleoTaskInstanceToken.getKaleoTaskId());
        kaleoTaskAssignmentInstance.setKaleoTaskName(kaleoTaskInstanceToken.getKaleoTaskName());
        kaleoTaskAssignmentInstance.setAssigneeClassName(assigneeClassName);
        if (assigneeClassPK == 0L && assigneeClassName.equals(User.class.getName())) {
            KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoTaskInstanceToken.getKaleoInstanceId());
            kaleoTaskAssignmentInstance.setAssigneeClassPK(kaleoInstance.getUserId());
        } else {
            kaleoTaskAssignmentInstance.setAssigneeClassPK(assigneeClassPK);
        }
        kaleoTaskAssignmentInstance.setCompleted(false);
        this.kaleoTaskAssignmentInstancePersistence.update((BaseModel)kaleoTaskAssignmentInstance);
        return kaleoTaskAssignmentInstance;
    }

    public List<KaleoTaskAssignmentInstance> addTaskAssignmentInstances(KaleoTaskInstanceToken kaleoTaskInstanceToken, Collection<KaleoTaskAssignment> kaleoTaskAssignments, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        ArrayList<KaleoTaskAssignmentInstance> kaleoTaskAssignmentInstances = new ArrayList<KaleoTaskAssignmentInstance>(kaleoTaskAssignments.size());
        for (KaleoTaskAssignment kaleoTaskAssignment : kaleoTaskAssignments) {
            long groupId = kaleoTaskAssignment.getGroupId();
            if (groupId <= 0L) {
                groupId = kaleoTaskInstanceToken.getGroupId();
            }
            KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = this.addKaleoTaskAssignmentInstance(groupId, kaleoTaskInstanceToken, kaleoTaskAssignment.getAssigneeClassName(), kaleoTaskAssignment.getAssigneeClassPK(), serviceContext);
            kaleoTaskAssignmentInstances.add(kaleoTaskAssignmentInstance);
        }
        return kaleoTaskAssignmentInstances;
    }

    public KaleoTaskAssignmentInstance assignKaleoTaskAssignmentInstance(KaleoTaskInstanceToken kaleoTaskInstanceToken, String assigneeClassName, long assigneeClassPK, ServiceContext serviceContext) throws PortalException {
        this.deleteKaleoTaskAssignmentInstances(kaleoTaskInstanceToken);
        KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = this.addKaleoTaskAssignmentInstance(kaleoTaskInstanceToken.getGroupId(), kaleoTaskInstanceToken, assigneeClassName, assigneeClassPK, serviceContext);
        return kaleoTaskAssignmentInstance;
    }

    public KaleoTaskAssignmentInstance completeKaleoTaskInstanceToken(long kaleoTaskInstanceTokenId, ServiceContext serviceContext) throws PortalException {
        List kaleoTaskAssignmentInstances = this.kaleoTaskAssignmentInstancePersistence.findBykaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId);
        if (kaleoTaskAssignmentInstances.size() > 1) {
            throw new WorkflowException("Cannot complete a task that is not assigned to an individual user");
        }
        KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = (KaleoTaskAssignmentInstance)kaleoTaskAssignmentInstances.get(0);
        kaleoTaskAssignmentInstance.setCompleted(true);
        kaleoTaskAssignmentInstance.setCompletionDate(new Date());
        this.kaleoTaskAssignmentInstancePersistence.update((BaseModel)kaleoTaskAssignmentInstance);
        return kaleoTaskAssignmentInstance;
    }

    public void deleteCompanyKaleoTaskAssignmentInstances(long companyId) {
        this.kaleoTaskAssignmentInstancePersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTaskAssignmentInstances(long kaleoDefinitionId) {
        this.kaleoTaskAssignmentInstancePersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionId);
    }

    public void deleteKaleoInstanceKaleoTaskAssignmentInstances(long kaleoInstanceId) {
        this.kaleoTaskAssignmentInstancePersistence.removeByKaleoInstanceId(kaleoInstanceId);
    }

    public void deleteKaleoTaskAssignmentInstances(KaleoTaskInstanceToken kaleoTaskInstanceToken) {
        List kaleoTaskAssignmentInstances = this.kaleoTaskAssignmentInstancePersistence.findBykaleoTaskInstanceTokenId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        for (KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance : kaleoTaskAssignmentInstances) {
            this.kaleoTaskAssignmentInstancePersistence.remove((BaseModel)kaleoTaskAssignmentInstance);
        }
    }

    public KaleoTaskAssignmentInstance fetchFirstKaleoTaskAssignmentInstance(long kaleoTaskInstanceTokenId, OrderByComparator<KaleoTaskAssignmentInstance> orderByComparator) {
        return this.kaleoTaskAssignmentInstancePersistence.fetchBykaleoTaskInstanceTokenId_First(kaleoTaskInstanceTokenId, orderByComparator);
    }

    public List<KaleoTaskAssignmentInstance> getKaleoTaskAssignmentInstances(long kaleoTaskInstanceTokenId) {
        return this.kaleoTaskAssignmentInstancePersistence.findBykaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId);
    }

    public int getKaleoTaskAssignmentInstancesCount(long kaleoTaskInstanceTokenId) {
        return this.kaleoTaskAssignmentInstancePersistence.countBykaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId);
    }
}

