/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.service.base.KaleoInstanceTokenLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class KaleoInstanceTokenLocalServiceImpl
extends KaleoInstanceTokenLocalServiceBaseImpl {
    public KaleoInstanceToken addKaleoInstanceToken(long parentKaleoInstanceTokenId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        KaleoInstanceToken parentKaleoInstanceToken = this.kaleoInstanceTokenPersistence.findByPrimaryKey(parentKaleoInstanceTokenId);
        Date now = new Date();
        long kaleoInstanceTokenId = this.counterLocalService.increment();
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.create(kaleoInstanceTokenId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoInstanceToken.setGroupId(groupId);
        kaleoInstanceToken.setCompanyId(user.getCompanyId());
        kaleoInstanceToken.setUserId(user.getUserId());
        kaleoInstanceToken.setUserName(user.getFullName());
        kaleoInstanceToken.setCreateDate(now);
        kaleoInstanceToken.setModifiedDate(now);
        kaleoInstanceToken.setKaleoDefinitionVersionId(parentKaleoInstanceToken.getKaleoDefinitionVersionId());
        kaleoInstanceToken.setKaleoInstanceId(parentKaleoInstanceToken.getKaleoInstanceId());
        kaleoInstanceToken.setParentKaleoInstanceTokenId(parentKaleoInstanceToken.getKaleoInstanceTokenId());
        this.setCurrentKaleoNode(kaleoInstanceToken, parentKaleoInstanceToken.getCurrentKaleoNodeId());
        kaleoInstanceToken.setClassName((String)((Object)workflowContext.get("entryClassName")));
        if (workflowContext.containsKey("entryClassPK")) {
            kaleoInstanceToken.setClassPK(GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK")))));
        }
        kaleoInstanceToken.setCompleted(false);
        this.kaleoInstanceTokenPersistence.update((BaseModel)kaleoInstanceToken);
        return kaleoInstanceToken;
    }

    public KaleoInstanceToken completeKaleoInstanceToken(long kaleoInstanceTokenId) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.findByPrimaryKey(kaleoInstanceTokenId);
        kaleoInstanceToken.setCompleted(true);
        kaleoInstanceToken.setCompletionDate(new Date());
        this.kaleoInstanceTokenPersistence.update((BaseModel)kaleoInstanceToken);
        return kaleoInstanceToken;
    }

    public void deleteCompanyKaleoInstanceTokens(long companyId) {
        this.kaleoInstanceTokenPersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoInstanceTokens(long kaleoDefinitionVersionId) {
        this.kaleoInstanceTokenPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    public void deleteKaleoInstanceKaleoInstanceTokens(long kaleoInstanceId) {
        this.kaleoInstanceTokenPersistence.removeByKaleoInstanceId(kaleoInstanceId);
    }

    public List<KaleoInstanceToken> getKaleoInstanceTokens(long parentKaleoInstanceTokenId, Date completionDate, ServiceContext serviceContext) {
        return this.kaleoInstanceTokenPersistence.findByC_PKITI_CD(serviceContext.getCompanyId(), parentKaleoInstanceTokenId, completionDate);
    }

    public List<KaleoInstanceToken> getKaleoInstanceTokens(long parentKaleoInstanceTokenId, ServiceContext serviceContext) {
        return this.kaleoInstanceTokenPersistence.findByC_PKITI(serviceContext.getCompanyId(), parentKaleoInstanceTokenId);
    }

    public int getKaleoInstanceTokensCount(long parentKaleoInstanceTokenId, Date completionDate, ServiceContext serviceContext) {
        return this.kaleoInstanceTokenPersistence.countByC_PKITI_CD(serviceContext.getCompanyId(), parentKaleoInstanceTokenId, completionDate);
    }

    public int getKaleoInstanceTokensCount(long parentKaleoInstanceTokenId, ServiceContext serviceContext) {
        return this.kaleoInstanceTokenPersistence.countByC_PKITI(serviceContext.getCompanyId(), parentKaleoInstanceTokenId);
    }

    public KaleoInstanceToken getRootKaleoInstanceToken(long kaleoInstanceId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        long rootKaleoInstanceTokenId = kaleoInstance.getRootKaleoInstanceTokenId();
        if (rootKaleoInstanceTokenId > 0L) {
            return this.kaleoInstanceTokenPersistence.findByPrimaryKey(rootKaleoInstanceTokenId);
        }
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date now = new Date();
        rootKaleoInstanceTokenId = this.counterLocalService.increment();
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.create(rootKaleoInstanceTokenId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoInstanceToken.setGroupId(groupId);
        kaleoInstanceToken.setCompanyId(user.getCompanyId());
        kaleoInstanceToken.setUserId(user.getUserId());
        kaleoInstanceToken.setUserName(user.getFullName());
        kaleoInstanceToken.setCreateDate(now);
        kaleoInstanceToken.setModifiedDate(now);
        kaleoInstanceToken.setKaleoDefinitionVersionId(kaleoInstance.getKaleoDefinitionVersionId());
        kaleoInstanceToken.setKaleoInstanceId(kaleoInstance.getKaleoInstanceId());
        kaleoInstanceToken.setParentKaleoInstanceTokenId(0L);
        kaleoInstanceToken.setClassName((String)((Object)workflowContext.get("entryClassName")));
        if (workflowContext.containsKey("entryClassPK")) {
            kaleoInstanceToken.setClassPK(GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK")))));
        }
        this.kaleoInstanceTokenPersistence.update((BaseModel)kaleoInstanceToken);
        kaleoInstance.setRootKaleoInstanceTokenId(rootKaleoInstanceTokenId);
        this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
        return kaleoInstanceToken;
    }

    public KaleoInstanceToken updateKaleoInstanceToken(long kaleoInstanceTokenId, long currentKaleoNodeId) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.findByPrimaryKey(kaleoInstanceTokenId);
        kaleoInstanceToken.setModifiedDate(new Date());
        this.setCurrentKaleoNode(kaleoInstanceToken, currentKaleoNodeId);
        this.kaleoInstanceTokenPersistence.update((BaseModel)kaleoInstanceToken);
        return kaleoInstanceToken;
    }

    protected void setCurrentKaleoNode(KaleoInstanceToken kaleoInstanceToken, long currentKaleoNodeId) throws PortalException {
        kaleoInstanceToken.setCurrentKaleoNodeId(currentKaleoNodeId);
        KaleoNode currentKaleoNode = this.kaleoNodeLocalService.getKaleoNode(currentKaleoNodeId);
        kaleoInstanceToken.setCurrentKaleoNodeName(currentKaleoNode.getName());
    }
}

