/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.exception.NoSuchInstanceException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.base.KaleoInstanceLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class KaleoInstanceLocalServiceImpl
extends KaleoInstanceLocalServiceBaseImpl {
    public KaleoInstance addKaleoInstance(long kaleoDefinitionVersionId, String kaleoDefinitionName, int kaleoDefinitionVersion, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.fetchUser(serviceContext.getUserId());
        if (user == null) {
            user = this.userLocalService.getDefaultUser(serviceContext.getCompanyId());
        }
        Date now = new Date();
        long kaleoInstanceId = this.counterLocalService.increment();
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.create(kaleoInstanceId);
        long groupId = StagingUtil.getLiveGroupId((long)serviceContext.getScopeGroupId());
        kaleoInstance.setGroupId(groupId);
        kaleoInstance.setCompanyId(user.getCompanyId());
        kaleoInstance.setUserId(user.getUserId());
        kaleoInstance.setUserName(user.getFullName());
        kaleoInstance.setCreateDate(now);
        kaleoInstance.setModifiedDate(now);
        kaleoInstance.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoInstance.setKaleoDefinitionName(kaleoDefinitionName);
        kaleoInstance.setKaleoDefinitionVersion(kaleoDefinitionVersion);
        kaleoInstance.setClassName((String)((Object)workflowContext.get("entryClassName")));
        if (workflowContext.containsKey("entryClassPK")) {
            kaleoInstance.setClassPK(GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK")))));
        }
        kaleoInstance.setCompleted(false);
        kaleoInstance.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
        return kaleoInstance;
    }

    public KaleoInstance completeKaleoInstance(long kaleoInstanceId) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setCompleted(true);
        kaleoInstance.setCompletionDate(new Date());
        this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
        return kaleoInstance;
    }

    public void deleteCompanyKaleoInstances(long companyId) {
        this.kaleoInstancePersistence.removeByCompanyId(companyId);
        this.kaleoInstanceTokenLocalService.deleteCompanyKaleoInstanceTokens(companyId);
        this.kaleoLogLocalService.deleteCompanyKaleoLogs(companyId);
        this.kaleoTaskInstanceTokenLocalService.deleteCompanyKaleoTaskInstanceTokens(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoInstances(long kaleoDefinitionVersionId) {
        this.kaleoInstancePersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        this.kaleoInstanceTokenLocalService.deleteKaleoDefinitionVersionKaleoInstanceTokens(kaleoDefinitionVersionId);
        this.kaleoLogLocalService.deleteKaleoDefinitionVersionKaleoLogs(kaleoDefinitionVersionId);
        this.kaleoTaskInstanceTokenLocalService.deleteKaleoDefinitionVersionKaleoTaskInstanceTokens(kaleoDefinitionVersionId);
    }

    @Override
    public KaleoInstance deleteKaleoInstance(long kaleoInstanceId) {
        KaleoInstance kaleoInstance = null;
        try {
            kaleoInstance = this.kaleoInstancePersistence.remove(kaleoInstanceId);
        }
        catch (NoSuchInstanceException nsie) {
            return null;
        }
        this.kaleoInstanceTokenLocalService.deleteKaleoInstanceKaleoInstanceTokens(kaleoInstanceId);
        this.kaleoLogLocalService.deleteKaleoInstanceKaleoLogs(kaleoInstanceId);
        this.kaleoTaskInstanceTokenLocalService.deleteKaleoInstanceKaleoTaskInstanceTokens(kaleoInstanceId);
        this.kaleoTimerInstanceTokenLocalService.deleteKaleoTimerInstanceTokens(kaleoInstanceId);
        return kaleoInstance;
    }

    public List<KaleoInstance> getKaleoInstances(Long userId, String assetClassName, Long assetClassPK, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(userId, assetClassName, assetClassPK, completed, serviceContext);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public List<KaleoInstance> getKaleoInstances(Long userId, String[] assetClassNames, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(userId, assetClassNames, null, completed, serviceContext);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public List<KaleoInstance> getKaleoInstances(String kaleoDefinitionName, int kaleoDefinitionVersion, boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(kaleoDefinitionName, kaleoDefinitionVersion, completed, serviceContext);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public int getKaleoInstancesCount(long kaleoDefinitionVersionId, boolean completed) {
        return this.kaleoInstancePersistence.countByKDVI_C(kaleoDefinitionVersionId, completed);
    }

    public int getKaleoInstancesCount(Long userId, String assetClassName, Long assetClassPK, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(userId, assetClassName, assetClassPK, completed, serviceContext);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public int getKaleoInstancesCount(Long userId, String[] assetClassNames, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(userId, assetClassNames, null, completed, serviceContext);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public int getKaleoInstancesCount(String kaleoDefinitionName, int kaleoDefinitionVersion, boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(kaleoDefinitionName, kaleoDefinitionVersion, completed, serviceContext);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public List<KaleoInstance> search(Long userId, String assetType, String nodeName, String kaleoDefinitionName, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(userId, assetType, nodeName, kaleoDefinitionName, completed, serviceContext);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public int searchCount(Long userId, String assetType, String nodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(userId, assetType, nodeName, kaleoDefinitionName, completed, serviceContext);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public KaleoInstance updateKaleoInstance(long kaleoInstanceId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
        return kaleoInstance;
    }

    protected DynamicQuery buildDynamicQuery(Long userId, String assetClassName, Long assetClassPK, Boolean completed, ServiceContext serviceContext) {
        String[] assetClassNames = null;
        if (Validator.isNotNull((String)assetClassName)) {
            assetClassNames = new String[]{assetClassName};
        }
        Long[] assetClassPKs = null;
        if (Validator.isNotNull((Long)assetClassPK)) {
            assetClassPKs = new Long[]{assetClassPK};
        }
        return this.buildDynamicQuery(userId, assetClassNames, assetClassPKs, completed, serviceContext);
    }

    protected DynamicQuery buildDynamicQuery(Long userId, String assetType, String nodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoInstance.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        if (Validator.isNotNull((Long)userId)) {
            Property userIdProperty = PropertyFactoryUtil.forName((String)"userId");
            dynamicQuery.add(userIdProperty.eq((Object)userId));
        }
        if (completed != null) {
            Property completionDateProperty;
            if (completed.booleanValue()) {
                completionDateProperty = PropertyFactoryUtil.forName((String)"completionDate");
                dynamicQuery.add(completionDateProperty.isNotNull());
            } else {
                completionDateProperty = PropertyFactoryUtil.forName((String)"completionDate");
                dynamicQuery.add(completionDateProperty.isNull());
            }
        }
        Disjunction junction = RestrictionsFactoryUtil.disjunction();
        if (Validator.isNotNull((String)assetType)) {
            Property classNameProperty = PropertyFactoryUtil.forName((String)"className");
            junction.add(classNameProperty.like((Object)assetType));
        }
        if (Validator.isNotNull((String)kaleoDefinitionName)) {
            Property kaleoDefinitionNameProperty = PropertyFactoryUtil.forName((String)"kaleoDefinitionName");
            junction.add(kaleoDefinitionNameProperty.eq((Object)kaleoDefinitionName));
        }
        if (Validator.isNotNull((String)nodeName)) {
            Property kaleoInstanceIdProperty = PropertyFactoryUtil.forName((String)"kaleoInstanceId");
            DynamicQuery subdynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoInstanceToken.class, (ClassLoader)this.getClassLoader());
            subdynamicQuery = subdynamicQuery.setProjection((Projection)kaleoInstanceIdProperty);
            Property currentKaleoNodeNameProperty = PropertyFactoryUtil.forName((String)"currentKaleoNodeName");
            subdynamicQuery.add(currentKaleoNodeNameProperty.like((Object)nodeName));
            junction.add(kaleoInstanceIdProperty.in(subdynamicQuery));
        }
        dynamicQuery.add((Criterion)junction);
        return dynamicQuery;
    }

    protected DynamicQuery buildDynamicQuery(Long userId, String[] assetClassNames, Long[] assetClassPKs, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoInstance.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        if (userId != null) {
            Property userIdProperty = PropertyFactoryUtil.forName((String)"userId");
            dynamicQuery.add(userIdProperty.eq((Object)userId));
        }
        if (ArrayUtil.isNotEmpty((Object[])assetClassNames)) {
            dynamicQuery.add(this.getAssetClassNames(assetClassNames));
        }
        if (ArrayUtil.isNotEmpty((Object[])assetClassPKs)) {
            dynamicQuery.add(this.getAssetClassPKs(assetClassPKs));
        }
        if (completed != null) {
            Property completionDateProperty;
            if (completed.booleanValue()) {
                completionDateProperty = PropertyFactoryUtil.forName((String)"completionDate");
                dynamicQuery.add(completionDateProperty.isNotNull());
            } else {
                completionDateProperty = PropertyFactoryUtil.forName((String)"completionDate");
                dynamicQuery.add(completionDateProperty.isNull());
            }
        }
        return dynamicQuery;
    }

    protected DynamicQuery buildDynamicQuery(String kaleoDefinitionName, int kaleoDefinitionVersion, boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoInstance.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        Property kaleoDefinitionNameProperty = PropertyFactoryUtil.forName((String)"kaleoDefinitionName");
        dynamicQuery.add(kaleoDefinitionNameProperty.eq((Object)kaleoDefinitionName));
        Property kaleoDefinitionVersionProperty = PropertyFactoryUtil.forName((String)"kaleoDefinitionVersion");
        dynamicQuery.add(kaleoDefinitionVersionProperty.eq((Object)kaleoDefinitionVersion));
        if (completed) {
            Property completionDateProperty = PropertyFactoryUtil.forName((String)"completionDate");
            dynamicQuery.add(completionDateProperty.isNotNull());
        } else {
            Property completionDateProperty = PropertyFactoryUtil.forName((String)"completionDate");
            dynamicQuery.add(completionDateProperty.isNull());
        }
        return dynamicQuery;
    }

    protected Criterion getAssetClassNames(String[] assetClassNames) {
        Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
        for (String assetClassName : assetClassNames) {
            Property classNameProperty = PropertyFactoryUtil.forName((String)"className");
            disjunction.add(classNameProperty.like((Object)assetClassName));
        }
        return disjunction;
    }

    protected Criterion getAssetClassPKs(Long[] assetClassPKs) {
        Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
        for (Long assetClassPK : assetClassPKs) {
            Property classPKProperty = PropertyFactoryUtil.forName((String)"classPK");
            disjunction.add(classPKProperty.eq((Object)assetClassPK));
        }
        return disjunction;
    }
}

